/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.auth.oauth2.Credential;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.auth.oauth2.TokenResponse;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.util.Clock;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.AccessTokenProviderClassFromConfigFactory;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.GoogleLogger;
import com.google.cloud.hadoop.util.AccessTokenProvider;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;

public final class CredentialFromAccessTokenProviderClassFactory {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();

    public static Credential credential(AccessTokenProvider accessTokenProvider, Collection<String> scopes) throws IOException, GeneralSecurityException {
        return CredentialFromAccessTokenProviderClassFactory.getCredentialFromAccessTokenProvider(accessTokenProvider, scopes);
    }

    public static Credential credential(AccessTokenProviderClassFromConfigFactory providerClassFactory, Configuration config, Collection<String> scopes) throws IOException, GeneralSecurityException {
        Class<? extends AccessTokenProvider> clazz = providerClassFactory.getAccessTokenProviderClass(config);
        if (clazz != null) {
            ((GoogleLogger.Api)logger.atFine()).log("Using AccessTokenProvider (%s)", clazz.getName());
            try {
                AccessTokenProvider accessTokenProvider = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                accessTokenProvider.setConf(config);
                return CredentialFromAccessTokenProviderClassFactory.getCredentialFromAccessTokenProvider(accessTokenProvider, scopes);
            }
            catch (ReflectiveOperationException ex) {
                throw new IOException("Can't instantiate " + clazz.getName(), ex);
            }
        }
        return null;
    }

    private static Credential getCredentialFromAccessTokenProvider(AccessTokenProvider accessTokenProvider, Collection<String> scopes) throws IOException, GeneralSecurityException {
        Preconditions.checkArgument(accessTokenProvider.getAccessToken() != null, "Access Token cannot be null!");
        GoogleCredential credential = GoogleCredentialWithAccessTokenProvider.fromAccessTokenProvider(Clock.SYSTEM, accessTokenProvider);
        return credential.createScoped(scopes);
    }

    static final class GoogleCredentialWithAccessTokenProvider
    extends GoogleCredential {
        private final Clock clock;
        private final AccessTokenProvider accessTokenProvider;

        private GoogleCredentialWithAccessTokenProvider(Clock clock, AccessTokenProvider accessTokenProvider) {
            this.clock = clock;
            this.accessTokenProvider = accessTokenProvider;
        }

        static GoogleCredential fromAccessTokenProvider(Clock clock, AccessTokenProvider accessTokenProvider) {
            GoogleCredentialWithAccessTokenProvider withProvider = new GoogleCredentialWithAccessTokenProvider(clock, accessTokenProvider);
            AccessTokenProvider.AccessToken accessToken = Preconditions.checkNotNull(accessTokenProvider.getAccessToken(), "Access Token cannot be null!");
            withProvider.setAccessToken(accessToken.getToken()).setExpirationTimeMilliseconds(accessToken.getExpirationTimeMilliSeconds());
            return withProvider;
        }

        @Override
        protected TokenResponse executeRefreshToken() throws IOException {
            this.accessTokenProvider.refresh();
            AccessTokenProvider.AccessToken accessToken = Preconditions.checkNotNull(this.accessTokenProvider.getAccessToken(), "Access Token cannot be null!");
            String token = Preconditions.checkNotNull(accessToken.getToken(), "Access Token cannot be null!");
            Long expirationTimeMilliSeconds = accessToken.getExpirationTimeMilliSeconds();
            return new TokenResponse().setAccessToken(token).setExpiresInSeconds(expirationTimeMilliSeconds == null ? null : Long.valueOf((expirationTimeMilliSeconds - this.clock.currentTimeMillis()) / 1000L));
        }
    }
}

