/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.auth.oauth2.Credential;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.auth.oauth2.TokenRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.auth.oauth2.TokenResponse;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.extensions.java6.auth.oauth2.AuthorizationCodeInstalledApp;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.extensions.java6.auth.oauth2.FileCredentialStore;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.googleapis.compute.ComputeCredential;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.googleapis.extensions.java6.auth.oauth2.GooglePromptReceiver;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.GenericUrl;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpBackOffIOExceptionHandler;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpBackOffUnsuccessfulResponseHandler;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpRequestInitializer;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpTransport;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.json.JsonFactory;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.json.JsonObjectParser;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.json.jackson2.JacksonFactory;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.json.webtoken.JsonWebSignature;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.json.webtoken.JsonWebToken;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.util.ExponentialBackOff;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.util.PemReader;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.util.SecurityUtils;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.HttpTransportFactory;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Joiner;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.MoreObjects;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Strings;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableList;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.GoogleLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.List;

public class CredentialFactory {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    static final String CREDENTIAL_ENV_VAR = "GOOGLE_APPLICATION_CREDENTIALS";
    private static final String TOKEN_SERVER_URL_ENV_VAR = "GOOGLE_OAUTH_TOKEN_SERVER_URL";
    private static final String TOKEN_SERVER_URL_DEFAULT = "https://oauth2.googleapis.com/token";
    private static final String TOKEN_SERVER_URL = MoreObjects.firstNonNull(System.getenv("GOOGLE_OAUTH_TOKEN_SERVER_URL"), "https://oauth2.googleapis.com/token");
    public static final ImmutableList<String> GCS_SCOPES = ImmutableList.of("https://www.googleapis.com/auth/devstorage.full_control");
    private static final JsonFactory JSON_FACTORY = new JacksonFactory();
    private static HttpTransport staticHttpTransport = null;

    private static synchronized HttpTransport getStaticHttpTransport() throws IOException, GeneralSecurityException {
        if (staticHttpTransport == null) {
            staticHttpTransport = HttpTransportFactory.createHttpTransport(HttpTransportFactory.HttpTransportType.JAVA_NET);
        }
        return staticHttpTransport;
    }

    public Credential getCredentialFromMetadataServiceAccount() throws IOException, GeneralSecurityException {
        ((GoogleLogger.Api)logger.atFine()).log("getCredentialFromMetadataServiceAccount()");
        ComputeCredentialWithRetry cred = new ComputeCredentialWithRetry(new ComputeCredential.Builder(CredentialFactory.getStaticHttpTransport(), JSON_FACTORY).setRequestInitializer(new CredentialHttpRetryInitializer()));
        try {
            cred.refreshToken();
        }
        catch (IOException e) {
            throw new IOException("Error getting access token from metadata server at: " + cred.getTokenServerEncodedUrl(), e);
        }
        return cred;
    }

    public Credential getCredentialFromPrivateKeyServiceAccount(String serviceAccountEmail, String privateKeyFile, List<String> scopes, HttpTransport transport) throws IOException, GeneralSecurityException {
        ((GoogleLogger.Api)logger.atFine()).log("getCredentialFromPrivateKeyServiceAccount(%s, %s, %s)", serviceAccountEmail, privateKeyFile, scopes);
        return new GoogleCredentialWithRetry(new GoogleCredential.Builder().setTransport(transport).setJsonFactory(JSON_FACTORY).setServiceAccountId(serviceAccountEmail).setServiceAccountScopes(scopes).setServiceAccountPrivateKeyFromP12File(new File(privateKeyFile)).setRequestInitializer(new CredentialHttpRetryInitializer()));
    }

    public Credential getCredentialFromJsonKeyFile(String serviceAccountJsonKeyFile, List<String> scopes, HttpTransport transport) throws IOException, GeneralSecurityException {
        ((GoogleLogger.Api)logger.atFine()).log("getCredentialFromJsonKeyFile(%s, %s)", (Object)serviceAccountJsonKeyFile, scopes);
        try (FileInputStream fis = new FileInputStream(serviceAccountJsonKeyFile);){
            GoogleCredentialWithRetry googleCredentialWithRetry = GoogleCredentialWithRetry.fromGoogleCredential(GoogleCredential.fromStream(fis, transport, JSON_FACTORY).createScoped(scopes));
            return googleCredentialWithRetry;
        }
    }

    public Credential getCredentialsFromSAParameters(String privateKeyId, String privateKeyPem, String serviceAccountEmail, List<String> scopes, HttpTransport transport) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("getServiceAccountCredentialFromHadoopConfiguration(%s)", serviceAccountEmail);
        if (serviceAccountEmail == null || privateKeyPem == null || privateKeyId == null) {
            throw new IOException("Error reading service account credential from stream, expecting, 'client_email', 'private_key' and 'private_key_id'.");
        }
        PrivateKey privateKey = CredentialFactory.privateKeyFromPkcs8(privateKeyPem);
        GoogleCredential.Builder builder = new GoogleCredential.Builder().setTransport(transport).setJsonFactory(JSON_FACTORY).setServiceAccountId(serviceAccountEmail).setServiceAccountScopes(scopes).setServiceAccountPrivateKey(privateKey).setServiceAccountPrivateKeyId(privateKeyId);
        return new GoogleCredentialWithRetry(builder);
    }

    public Credential getCredentialFromFileCredentialStoreForInstalledApp(String clientId, String clientSecret, String filePath, List<String> scopes, HttpTransport transport) throws IOException, GeneralSecurityException {
        ((GoogleLogger.Api)logger.atFine()).log("getCredentialFromFileCredentialStoreForInstalledApp(%s, %s, %s, %s)", clientId, clientSecret, filePath, scopes);
        Preconditions.checkArgument(!Strings.isNullOrEmpty(clientId), "clientId must not be null or empty");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(clientSecret), "clientSecret must not be null or empty");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(filePath), "filePath must not be null or empty");
        Preconditions.checkNotNull(scopes, "scopes must not be null");
        GoogleClientSecrets.Details details = new GoogleClientSecrets.Details().setClientId(clientId).setClientSecret(clientSecret);
        GoogleClientSecrets clientSecrets = new GoogleClientSecrets().setInstalled(details);
        FileCredentialStore credentialStore = new FileCredentialStore(new File(filePath), JSON_FACTORY);
        GoogleAuthorizationCodeFlow flow = new GoogleAuthorizationCodeFlow.Builder(transport, JSON_FACTORY, clientSecrets, scopes).setCredentialStore(credentialStore).setRequestInitializer(new CredentialHttpRetryInitializer()).setTokenServerUrl(new GenericUrl(TOKEN_SERVER_URL)).build();
        return new AuthorizationCodeInstalledApp(flow, new GooglePromptReceiver()).authorize("user");
    }

    boolean hasApplicationDefaultCredentialsConfigured() {
        return System.getenv(CREDENTIAL_ENV_VAR) != null;
    }

    public Credential getApplicationDefaultCredentials(List<String> scopes, HttpTransport transport) throws IOException, GeneralSecurityException {
        ((GoogleLogger.Api)logger.atFine()).log("getApplicationDefaultCredential(%s)", scopes);
        return GoogleCredentialWithRetry.fromGoogleCredential(GoogleCredential.getApplicationDefault(transport, JSON_FACTORY).createScoped(scopes));
    }

    private static PrivateKey privateKeyFromPkcs8(String privateKeyPem) throws IOException {
        StringReader reader = new StringReader(privateKeyPem);
        PemReader.Section section = PemReader.readFirstSectionAndClose(reader, "PRIVATE KEY");
        if (section == null) {
            throw new IOException("Invalid PKCS8 data.");
        }
        byte[] bytes = section.getBase64DecodedBytes();
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(bytes);
        try {
            KeyFactory keyFactory = SecurityUtils.getRsaKeyFactory();
            PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
            return privateKey;
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException exception) {
            throw new IOException("Unexpected expcetion reading PKCS data", exception);
        }
    }

    public static class ComputeCredentialWithRetry
    extends ComputeCredential {
        public ComputeCredentialWithRetry(ComputeCredential.Builder builder) {
            super(builder);
        }

        @Override
        protected TokenResponse executeRefreshToken() throws IOException {
            HttpRequest request = this.getTransport().createRequestFactory(this.getRequestInitializer()).buildGetRequest(new GenericUrl(this.getTokenServerEncodedUrl())).setParser(new JsonObjectParser(this.getJsonFactory()));
            request.getHeaders().set("Metadata-Flavor", "Google");
            return request.execute().parseAs(TokenResponse.class);
        }
    }

    public static class GoogleCredentialWithRetry
    extends GoogleCredential {
        private static final int DEFAULT_TOKEN_EXPIRATION_SECONDS = 3600;

        public static GoogleCredentialWithRetry fromGoogleCredential(GoogleCredential credential) {
            GoogleCredential.Builder builder = new GoogleCredential.Builder().setServiceAccountPrivateKey(credential.getServiceAccountPrivateKey()).setServiceAccountPrivateKeyId(credential.getServiceAccountPrivateKeyId()).setServiceAccountId(credential.getServiceAccountId()).setServiceAccountUser(credential.getServiceAccountUser()).setServiceAccountScopes(credential.getServiceAccountScopes()).setTokenServerEncodedUrl(credential.getTokenServerEncodedUrl()).setTransport(credential.getTransport()).setClientAuthentication(credential.getClientAuthentication()).setJsonFactory(credential.getJsonFactory()).setClock(credential.getClock()).setRequestInitializer(new CredentialHttpRetryInitializer());
            GoogleCredentialWithRetry withRetry = new GoogleCredentialWithRetry(builder);
            if (credential.getRefreshToken() != null) {
                withRetry.setRefreshToken(credential.getRefreshToken());
            }
            return withRetry;
        }

        public GoogleCredentialWithRetry(GoogleCredential.Builder builder) {
            super(builder.setTokenServerEncodedUrl(TOKEN_SERVER_URL));
        }

        @Override
        protected TokenResponse executeRefreshToken() throws IOException {
            if (this.getServiceAccountPrivateKey() == null) {
                return super.executeRefreshToken();
            }
            JsonWebSignature.Header header = new JsonWebSignature.Header().setAlgorithm("RS256").setType("JWT").setKeyId(this.getServiceAccountPrivateKeyId());
            long currentTime = this.getClock().currentTimeMillis();
            JsonWebToken.Payload payload = new JsonWebToken.Payload().setIssuer(this.getServiceAccountId()).setAudience(this.getTokenServerEncodedUrl()).setIssuedAtTimeSeconds(currentTime / 1000L).setExpirationTimeSeconds(currentTime / 1000L + 3600L).setSubject(this.getServiceAccountUser());
            payload.put("scope", (Object)Joiner.on(' ').join(this.getServiceAccountScopes()));
            try {
                String assertion = JsonWebSignature.signUsingRsaSha256(this.getServiceAccountPrivateKey(), this.getJsonFactory(), header, payload);
                TokenRequest request = new TokenRequest(this.getTransport(), this.getJsonFactory(), new GenericUrl(this.getTokenServerEncodedUrl()), "urn:ietf:params:oauth:grant-type:jwt-bearer").setRequestInitializer(this.getRequestInitializer());
                request.put("assertion", (Object)assertion);
                return request.execute();
            }
            catch (GeneralSecurityException exception) {
                throw (IOException)new IOException().initCause(exception);
            }
        }
    }

    public static class CredentialHttpRetryInitializer
    implements HttpRequestInitializer {
        @Override
        public void initialize(HttpRequest httpRequest) throws IOException {
            httpRequest.setIOExceptionHandler(new HttpBackOffIOExceptionHandler(new ExponentialBackOff()));
            httpRequest.setUnsuccessfulResponseHandler(new HttpBackOffUnsuccessfulResponseHandler(new ExponentialBackOff()));
        }
    }
}

