/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.util.Strings;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.ForwardingGoogleCloudStorage;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.PerformanceCachingGoogleCloudStorageOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.PrefixMappedItemCache;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.UpdatableItemInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

public class PerformanceCachingGoogleCloudStorage
extends ForwardingGoogleCloudStorage {
    private final PrefixMappedItemCache cache;
    private final GoogleCloudStorageOptions delegateOptions;
    private final PerformanceCachingGoogleCloudStorageOptions options;

    public PerformanceCachingGoogleCloudStorage(GoogleCloudStorage delegate, PerformanceCachingGoogleCloudStorageOptions options) {
        this(delegate, options, PerformanceCachingGoogleCloudStorage.createCache(options));
    }

    @VisibleForTesting
    PerformanceCachingGoogleCloudStorage(GoogleCloudStorage delegate, PerformanceCachingGoogleCloudStorageOptions options, PrefixMappedItemCache cache) {
        super(delegate);
        this.delegateOptions = delegate.getOptions();
        this.options = options;
        this.cache = cache;
    }

    private static PrefixMappedItemCache createCache(PerformanceCachingGoogleCloudStorageOptions options) {
        PrefixMappedItemCache.Config config = new PrefixMappedItemCache.Config();
        config.setMaxEntryAgeMillis(options.getMaxEntryAgeMillis());
        return new PrefixMappedItemCache(config);
    }

    @Override
    public void deleteBuckets(List<String> bucketNames) throws IOException {
        super.deleteBuckets(bucketNames);
        for (String bucket : bucketNames) {
            this.cache.invalidateBucket(bucket);
        }
    }

    @Override
    public void deleteObjects(List<StorageResourceId> fullObjectNames) throws IOException {
        super.deleteObjects(fullObjectNames);
        for (StorageResourceId id : fullObjectNames) {
            this.cache.removeItem(id);
        }
    }

    @Override
    public List<GoogleCloudStorageItemInfo> listBucketInfo() throws IOException {
        List<GoogleCloudStorageItemInfo> result = super.listBucketInfo();
        for (GoogleCloudStorageItemInfo item : result) {
            this.cache.putItem(item);
        }
        return result;
    }

    @Override
    public List<GoogleCloudStorageItemInfo> listObjectInfo(String bucketName, String objectNamePrefix, String delimiter) throws IOException {
        return this.listObjectInfo(bucketName, objectNamePrefix, delimiter, -1L);
    }

    @Override
    public List<GoogleCloudStorageItemInfo> listObjectInfo(String bucketName, String objectNamePrefix, String delimiter, long maxResults) throws IOException {
        List<GoogleCloudStorageItemInfo> result;
        if (this.options.isListCachingEnabled()) {
            result = this.cache.getList(bucketName, objectNamePrefix);
            if (result == null) {
                result = super.listObjectInfo(bucketName, objectNamePrefix, null);
                this.cache.putList(bucketName, objectNamePrefix, result);
            }
            this.filter(result, bucketName, objectNamePrefix, delimiter);
            if (maxResults > 0L && (long)result.size() > maxResults) {
                result = result.subList(0, (int)maxResults);
            }
        } else {
            result = super.listObjectInfo(bucketName, objectNamePrefix, delimiter, maxResults);
            for (GoogleCloudStorageItemInfo item : result) {
                this.cache.putItem(item);
            }
        }
        return result;
    }

    @Override
    public GoogleCloudStorage.ListPage<GoogleCloudStorageItemInfo> listObjectInfoPage(String bucketName, String objectNamePrefix, String delimiter, String pageToken) throws IOException {
        if (this.options.isListCachingEnabled()) {
            return new GoogleCloudStorage.ListPage<GoogleCloudStorageItemInfo>(this.listObjectInfo(bucketName, objectNamePrefix, delimiter), null);
        }
        GoogleCloudStorage.ListPage<GoogleCloudStorageItemInfo> result = super.listObjectInfoPage(bucketName, objectNamePrefix, delimiter, pageToken);
        for (GoogleCloudStorageItemInfo item : result.getItems()) {
            this.cache.putItem(item);
        }
        return result;
    }

    private void filter(List<GoogleCloudStorageItemInfo> items, String bucketName, @Nullable String prefix, @Nullable String delimiter) throws IOException {
        prefix = com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Strings.nullToEmpty(prefix);
        if (Strings.isNullOrEmpty(delimiter)) {
            if (prefix.isEmpty()) {
                Iterator<GoogleCloudStorageItemInfo> itr = items.iterator();
                while (itr.hasNext()) {
                    GoogleCloudStorageItemInfo item = itr.next();
                    if (!item.isBucket()) continue;
                    itr.remove();
                    break;
                }
            }
            return;
        }
        HashSet<String> dirs = new HashSet<String>();
        Iterator<GoogleCloudStorageItemInfo> itr = items.iterator();
        while (itr.hasNext()) {
            int lastIndex;
            GoogleCloudStorageItemInfo item = itr.next();
            String string = item.getObjectName();
            if (item.isBucket() || !string.startsWith(prefix) || prefix.endsWith(delimiter) && string.equals(prefix)) {
                itr.remove();
                continue;
            }
            int firstIndex = string.indexOf(delimiter, prefix.length());
            if (firstIndex == -1 || firstIndex == (lastIndex = string.lastIndexOf(delimiter)) && lastIndex == string.length() - 1) continue;
            itr.remove();
            dirs.add(string.substring(0, firstIndex + 1));
        }
        for (GoogleCloudStorageItemInfo googleCloudStorageItemInfo : items) {
            dirs.remove(googleCloudStorageItemInfo.getObjectName());
        }
        if (dirs.isEmpty()) {
            return;
        }
        ArrayList<StorageResourceId> dirIds = new ArrayList<StorageResourceId>(dirs.size());
        for (String dir : dirs) {
            dirIds.add(new StorageResourceId(bucketName, dir));
        }
        boolean bl = this.delegateOptions.isInferImplicitDirectoriesEnabled();
        if (bl) {
            for (StorageResourceId dirId : dirIds) {
                items.add(GoogleCloudStorageItemInfo.createInferredDirectory(dirId));
            }
        }
    }

    @Override
    public GoogleCloudStorageItemInfo getItemInfo(StorageResourceId resourceId) throws IOException {
        GoogleCloudStorageItemInfo item = this.cache.getItem(resourceId);
        if (item == null && resourceId.isStorageObject()) {
            String bucketName = resourceId.getBucketName();
            String objectName = resourceId.getObjectName();
            int lastSlashIndex = objectName.lastIndexOf("/");
            String directoryName = lastSlashIndex >= 0 ? objectName.substring(0, lastSlashIndex + 1) : null;
            List<GoogleCloudStorageItemInfo> cachedInDirectory = this.cache.listItems(bucketName, directoryName);
            this.filter(cachedInDirectory, bucketName, directoryName, "/");
            if (cachedInDirectory.isEmpty()) {
                this.listObjectInfoPage(bucketName, directoryName, "/", null);
                item = this.cache.getItem(resourceId);
            }
        }
        if (item == null) {
            item = super.getItemInfo(resourceId);
            this.cache.putItem(item);
        }
        return item;
    }

    @Override
    public List<GoogleCloudStorageItemInfo> getItemInfos(List<StorageResourceId> resourceIds) throws IOException {
        ArrayList<GoogleCloudStorageItemInfo> result = new ArrayList<GoogleCloudStorageItemInfo>(resourceIds.size());
        ArrayList<StorageResourceId> request = new ArrayList<StorageResourceId>(resourceIds.size());
        for (StorageResourceId resourceId : resourceIds) {
            GoogleCloudStorageItemInfo item = this.cache.getItem(resourceId);
            if (item == null) {
                request.add(resourceId);
            }
            result.add(item);
        }
        if (!request.isEmpty()) {
            List<GoogleCloudStorageItemInfo> response = super.getItemInfos(request);
            Iterator<GoogleCloudStorageItemInfo> responseIterator = response.iterator();
            for (int i = 0; i < result.size() && responseIterator.hasNext(); ++i) {
                if (result.get(i) != null) continue;
                GoogleCloudStorageItemInfo item = responseIterator.next();
                this.cache.putItem(item);
                result.set(i, item);
            }
        }
        return result;
    }

    @Override
    public List<GoogleCloudStorageItemInfo> updateItems(List<UpdatableItemInfo> itemInfoList) throws IOException {
        List<GoogleCloudStorageItemInfo> result = super.updateItems(itemInfoList);
        for (GoogleCloudStorageItemInfo item : result) {
            this.cache.putItem(item);
        }
        return result;
    }

    @Override
    public void close() {
        super.close();
        this.cache.invalidateAll();
    }

    @Override
    public GoogleCloudStorageItemInfo composeObjects(List<StorageResourceId> sources, StorageResourceId destination, CreateObjectOptions options) throws IOException {
        GoogleCloudStorageItemInfo item = super.composeObjects(sources, destination, options);
        this.cache.putItem(item);
        return item;
    }

    @VisibleForTesting
    public void invalidateCache() {
        this.cache.invalidateAll();
    }
}

