/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.auth.oauth2.Credential;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.googleapis.batch.json.JsonBatchCallback;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.ByteArrayContent;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpHeaders;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpRequestInitializer;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpTransport;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.InputStreamContent;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.json.JsonFactory;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.json.jackson2.JacksonFactory;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.util.BackOff;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.util.Data;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.util.ExponentialBackOff;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.util.Sleeper;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.Storage;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.StorageRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.model.Bucket;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.model.Buckets;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.model.ComposeRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.model.Objects;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.model.RewriteResponse;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.model.StorageObject;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.BatchHelper;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.CreateBucketOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageExceptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadChannel;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageWriteChannel;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.ObjectWriteConditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.UpdatableItemInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.VerificationAttributes;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.ApiErrorExtractor;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.ClientRequestHelper;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.HttpTransportFactory;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.RequesterPaysOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.ResilientOperation;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.RetryDeterminer;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.RetryHttpInitializer;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Optional;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Strings;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.cache.CacheBuilder;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.cache.CacheLoader;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.cache.LoadingCache;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableList;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.Iterables;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.Lists;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.Maps;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.Sets;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.GoogleLogger;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.io.BaseEncoding;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.FileAlreadyExistsException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class GoogleCloudStorageImpl
implements GoogleCloudStorage {
    public static final int BUCKET_EMPTY_MAX_RETRIES = 20;
    public static final int BUCKET_EMPTY_WAIT_TIME_MS = 500;
    private static final JsonFactory JSON_FACTORY = new JacksonFactory();
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final int MAXIMUM_PRECONDITION_FAILURES_IN_DELETE = 4;
    private static final String USER_PROJECT_FIELD_NAME = "userProject";
    private final LoadingCache<String, Boolean> autoBuckets = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofHours(1L)).build(new CacheLoader<String, Boolean>(){
        final List<String> iamPermissions = ImmutableList.of("storage.buckets.get");

        @Override
        public Boolean load(String bucketName) throws Exception {
            try {
                GoogleCloudStorageImpl.this.gcs.buckets().testIamPermissions(bucketName, this.iamPermissions).executeUnparsed().disconnect();
            }
            catch (IOException e) {
                return GoogleCloudStorageImpl.this.errorExtractor.userProjectMissing(e);
            }
            return false;
        }
    });
    private Storage gcs;
    private ExecutorService backgroundTasksThreadPool = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("gcs-async-channel-pool-%d").setDaemon(true).build());
    private ExecutorService manualBatchingThreadPool = this.createManualBatchingThreadPool();
    private ApiErrorExtractor errorExtractor = ApiErrorExtractor.INSTANCE;
    private ClientRequestHelper<StorageObject> clientRequestHelper = new ClientRequestHelper();
    private BatchHelper.Factory batchFactory = new BatchHelper.Factory();
    private HttpRequestInitializer httpRequestInitializer;
    private final GoogleCloudStorageOptions storageOptions;
    private Sleeper sleeper = Sleeper.DEFAULT;
    private BackOffFactory backOffFactory = BackOffFactory.DEFAULT;
    private RetryDeterminer<IOException> rateLimitedRetryDeterminer = RetryDeterminer.createRateLimitedRetryDeterminer(this.errorExtractor);

    private static String encodeMetadataValues(byte[] bytes) {
        return bytes == null ? Data.NULL_STRING : BaseEncoding.base64().encode(bytes);
    }

    private static byte[] decodeMetadataValues(String value) {
        try {
            return BaseEncoding.base64().decode(value);
        }
        catch (IllegalArgumentException iae) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withCause(iae)).log("Failed to parse base64 encoded attribute value %s - %s", (Object)value, (Object)iae);
            return null;
        }
    }

    public GoogleCloudStorageImpl(GoogleCloudStorageOptions options, Credential credential) throws IOException {
        this(options, new RetryHttpInitializer(Preconditions.checkNotNull(credential, "credential must not be null"), options.getAppName(), options.getMaxHttpRequestRetries(), options.getHttpRequestConnectTimeout(), options.getHttpRequestReadTimeout()));
    }

    @VisibleForTesting
    public GoogleCloudStorageImpl(GoogleCloudStorageOptions options, HttpRequestInitializer httpRequestInitializer) throws IOException {
        Preconditions.checkNotNull(options, "options must not be null");
        options.throwIfNotValid();
        ((GoogleLogger.Api)logger.atFine()).log("GCS(%s)", options.getAppName());
        this.storageOptions = options;
        this.httpRequestInitializer = httpRequestInitializer;
        HttpTransport httpTransport = HttpTransportFactory.createHttpTransport(options.getTransportType(), options.getProxyAddress(), options.getProxyUsername(), options.getProxyPassword());
        this.gcs = new Storage.Builder(httpTransport, JSON_FACTORY, httpRequestInitializer).setApplicationName(options.getAppName()).build();
    }

    public GoogleCloudStorageImpl(GoogleCloudStorageOptions options, Storage gcs) {
        Preconditions.checkNotNull(options, "options must not be null");
        ((GoogleLogger.Api)logger.atFine()).log("GCS(%s)", options.getAppName());
        options.throwIfNotValid();
        this.storageOptions = options;
        Preconditions.checkNotNull(gcs, "gcs must not be null");
        this.gcs = gcs;
        if (gcs.getRequestFactory() != null) {
            this.httpRequestInitializer = gcs.getRequestFactory().getInitializer();
        }
    }

    @VisibleForTesting
    protected GoogleCloudStorageImpl() {
        this.storageOptions = GoogleCloudStorageOptions.builder().setAppName("test-app").build();
    }

    private ExecutorService createManualBatchingThreadPool() {
        ThreadPoolExecutor service = new ThreadPoolExecutor(10, 20, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("gcs-manual-batching-pool-%d").setDaemon(true).build());
        service.allowCoreThreadTimeOut(true);
        return service;
    }

    @VisibleForTesting
    void setBackgroundTasksThreadPool(ExecutorService backgroundTasksThreadPool) {
        this.backgroundTasksThreadPool = backgroundTasksThreadPool;
    }

    @VisibleForTesting
    void setErrorExtractor(ApiErrorExtractor errorExtractor) {
        this.errorExtractor = errorExtractor;
        this.rateLimitedRetryDeterminer = RetryDeterminer.createRateLimitedRetryDeterminer(errorExtractor);
    }

    @VisibleForTesting
    void setClientRequestHelper(ClientRequestHelper<StorageObject> clientRequestHelper) {
        this.clientRequestHelper = clientRequestHelper;
    }

    @VisibleForTesting
    void setBatchFactory(BatchHelper.Factory batchFactory) {
        this.batchFactory = batchFactory;
    }

    @VisibleForTesting
    void setSleeper(Sleeper sleeper) {
        this.sleeper = sleeper;
    }

    @VisibleForTesting
    void setBackOffFactory(BackOffFactory factory) {
        this.backOffFactory = factory;
    }

    @Override
    public GoogleCloudStorageOptions getOptions() {
        return this.storageOptions;
    }

    @Override
    public WritableByteChannel create(final StorageResourceId resourceId, CreateObjectOptions options) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("create(%s)", resourceId);
        Preconditions.checkArgument(resourceId.isStorageObject(), "Expected full StorageObject id, got %s", (Object)resourceId);
        Optional<Long> overwriteGeneration = resourceId.hasGenerationId() ? Optional.of(resourceId.getGenerationId()) : Optional.of(this.getWriteGeneration(resourceId, options.overwriteExisting()));
        ObjectWriteConditions writeConditions = new ObjectWriteConditions(overwriteGeneration, Optional.absent());
        Map<String, String> rewrittenMetadata = GoogleCloudStorageImpl.encodeMetadata(options.getMetadata());
        GoogleCloudStorageWriteChannel channel = new GoogleCloudStorageWriteChannel(this.backgroundTasksThreadPool, this.gcs, this.clientRequestHelper, resourceId.getBucketName(), resourceId.getObjectName(), options.getContentType(), options.getContentEncoding(), null, this.storageOptions.getWriteChannelOptions(), writeConditions, rewrittenMetadata){

            @Override
            public Storage.Objects.Insert createRequest(InputStreamContent inputStream) throws IOException {
                return GoogleCloudStorageImpl.this.configureRequest(super.createRequest(inputStream), resourceId.getBucketName());
            }
        };
        channel.initialize();
        return channel;
    }

    @Override
    public WritableByteChannel create(StorageResourceId resourceId) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("create(%s)", resourceId);
        Preconditions.checkArgument(resourceId.isStorageObject(), "Expected full StorageObject id, got %s", (Object)resourceId);
        return this.create(resourceId, CreateObjectOptions.DEFAULT);
    }

    @Override
    public void create(String bucketName) throws IOException {
        this.create(bucketName, CreateBucketOptions.DEFAULT);
    }

    @Override
    public void create(String bucketName, CreateBucketOptions options) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("create(%s)", bucketName);
        Preconditions.checkArgument(!Strings.isNullOrEmpty(bucketName), "bucketName must not be null or empty");
        Preconditions.checkNotNull(options, "options must not be null");
        Preconditions.checkNotNull(this.storageOptions.getProjectId(), "projectId must not be null");
        Bucket bucket = new Bucket().setName(bucketName).setLocation(options.getLocation()).setStorageClass(options.getStorageClass());
        Storage.Buckets.Insert insertBucket = this.configureRequest(this.gcs.buckets().insert(this.storageOptions.getProjectId(), bucket), bucketName);
        try {
            ResilientOperation.retry(ResilientOperation.getGoogleRequestCallable(insertBucket), this.backOffFactory.newBackOff(), this.rateLimitedRetryDeterminer, IOException.class, this.sleeper);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Failed to create bucket", e);
        }
    }

    @Override
    public void createEmptyObject(StorageResourceId resourceId, CreateObjectOptions options) throws IOException {
        Preconditions.checkArgument(resourceId.isStorageObject(), "Expected full StorageObject id, got %s", (Object)resourceId);
        Storage.Objects.Insert insertObject = this.prepareEmptyInsert(resourceId, options);
        try {
            insertObject.execute();
        }
        catch (IOException ioe) {
            if (this.canIgnoreExceptionForEmptyObject(ioe, resourceId, options)) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atInfo()).withCause(ioe)).log("Ignoring exception; verified object already exists with desired state.");
            }
            throw ioe;
        }
    }

    @Override
    public void createEmptyObject(StorageResourceId resourceId) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("createEmptyObject(%s)", resourceId);
        Preconditions.checkArgument(resourceId.isStorageObject(), "Expected full StorageObject id, got %s", (Object)resourceId);
        this.createEmptyObject(resourceId, CreateObjectOptions.DEFAULT);
    }

    public void updateMetadata(GoogleCloudStorageItemInfo itemInfo, Map<String, byte[]> metadata) throws IOException {
        StorageResourceId resourceId = itemInfo.getResourceId();
        Preconditions.checkArgument(resourceId.isStorageObject(), "Expected full StorageObject ID, got %s", (Object)resourceId);
        StorageObject storageObject = new StorageObject().setMetadata(GoogleCloudStorageImpl.encodeMetadata(metadata));
        Storage.Objects.Patch patchObject = this.configureRequest(this.gcs.objects().patch(resourceId.getBucketName(), resourceId.getObjectName(), storageObject), resourceId.getBucketName()).setIfMetagenerationMatch(itemInfo.getMetaGeneration());
        patchObject.execute();
    }

    @Override
    public void createEmptyObjects(List<StorageResourceId> resourceIds, CreateObjectOptions options) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("createEmptyObjects(%s)", resourceIds);
        if (resourceIds.isEmpty()) {
            return;
        }
        if (resourceIds.size() == 1) {
            this.createEmptyObject(Iterables.getOnlyElement(resourceIds), options);
            return;
        }
        for (StorageResourceId resourceId : resourceIds) {
            Preconditions.checkArgument(resourceId.isStorageObject(), "Expected full StorageObject names only, got: '%s'", (Object)resourceId);
        }
        Set<IOException> innerExceptions = Sets.newConcurrentHashSet();
        CountDownLatch latch = new CountDownLatch(resourceIds.size());
        for (StorageResourceId resourceId : resourceIds) {
            Storage.Objects.Insert insertObject = this.prepareEmptyInsert(resourceId, options);
            this.manualBatchingThreadPool.execute(() -> {
                try {
                    insertObject.execute();
                    ((GoogleLogger.Api)logger.atFine()).log("Successfully inserted %s", resourceId);
                }
                catch (IOException ioe) {
                    boolean canIgnoreException = false;
                    try {
                        canIgnoreException = this.canIgnoreExceptionForEmptyObject(ioe, resourceId, options);
                    }
                    catch (Exception e) {
                        innerExceptions.add(new IOException("Error re-fetching after rate-limit error: " + resourceId, e));
                    }
                    if (canIgnoreException) {
                        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atInfo()).withCause(ioe)).log("Ignoring exception; verified object already exists with desired state.");
                    } else {
                        innerExceptions.add(new IOException("Error inserting " + resourceId, ioe));
                    }
                }
                catch (Exception e) {
                    innerExceptions.add(new IOException("Error inserting " + resourceId, e));
                }
                finally {
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new IOException("Failed to create empty objects", ie);
        }
        if (!innerExceptions.isEmpty()) {
            throw GoogleCloudStorageExceptions.createCompositeException(innerExceptions);
        }
    }

    @Override
    public void createEmptyObjects(List<StorageResourceId> resourceIds) throws IOException {
        this.createEmptyObjects(resourceIds, CreateObjectOptions.DEFAULT);
    }

    @Override
    public SeekableByteChannel open(StorageResourceId resourceId) throws IOException {
        return this.open(resourceId, GoogleCloudStorageReadOptions.DEFAULT);
    }

    @Override
    public SeekableByteChannel open(final StorageResourceId resourceId, GoogleCloudStorageReadOptions readOptions) throws IOException {
        GoogleCloudStorageItemInfo info;
        ((GoogleLogger.Api)logger.atFine()).log("open(%s, %s)", (Object)resourceId, (Object)readOptions);
        Preconditions.checkArgument(resourceId.isStorageObject(), "Expected full StorageObject id, got %s", (Object)resourceId);
        if (readOptions.getFastFailOnNotFound()) {
            info = this.getItemInfo(resourceId);
            if (!info.exists()) {
                throw GoogleCloudStorageExceptions.createFileNotFoundException(resourceId.getBucketName(), resourceId.getObjectName(), null);
            }
        } else {
            info = null;
        }
        return new GoogleCloudStorageReadChannel(this.gcs, resourceId.getBucketName(), resourceId.getObjectName(), this.errorExtractor, this.clientRequestHelper, readOptions){

            @Override
            @Nullable
            protected GoogleCloudStorageItemInfo getInitialMetadata() {
                return info;
            }

            @Override
            protected Storage.Objects.Get createRequest() throws IOException {
                return GoogleCloudStorageImpl.this.configureRequest(super.createRequest(), resourceId.getBucketName());
            }
        };
    }

    @Override
    public void deleteBuckets(List<String> bucketNames) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("deleteBuckets(%s)", bucketNames);
        for (String bucketName : bucketNames) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(bucketName), "bucketName must not be null or empty");
        }
        ArrayList<IOException> innerExceptions = new ArrayList<IOException>();
        for (String bucketName : bucketNames) {
            Storage.Buckets.Delete deleteBucket = this.configureRequest(this.gcs.buckets().delete(bucketName), bucketName);
            try {
                ResilientOperation.retry(ResilientOperation.getGoogleRequestCallable(deleteBucket), this.backOffFactory.newBackOff(), this.rateLimitedRetryDeterminer, IOException.class, this.sleeper);
            }
            catch (IOException e) {
                innerExceptions.add(this.errorExtractor.itemNotFound(e) ? GoogleCloudStorageExceptions.createFileNotFoundException(bucketName, null, e) : new IOException(String.format("Error deleting '%s' bucket", bucketName), e));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Failed to delete buckets", e);
            }
        }
        if (!innerExceptions.isEmpty()) {
            throw GoogleCloudStorageExceptions.createCompositeException(innerExceptions);
        }
    }

    public void deleteObject(StorageResourceId resourceId, long metaGeneration) throws IOException {
        String bucketName = resourceId.getBucketName();
        Storage.Objects.Delete deleteObject = this.configureRequest(this.gcs.objects().delete(bucketName, resourceId.getObjectName()), bucketName).setIfMetagenerationMatch(metaGeneration);
        deleteObject.execute();
    }

    @Override
    public void deleteObjects(List<StorageResourceId> fullObjectNames) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("deleteObjects(%s)", fullObjectNames);
        if (fullObjectNames.isEmpty()) {
            return;
        }
        for (StorageResourceId fullObjectName : fullObjectNames) {
            Preconditions.checkArgument(fullObjectName.isStorageObject(), "Expected full StorageObject names only, got: %s", (Object)fullObjectName);
        }
        ConcurrentHashMap.KeySetView<IOException, Boolean> innerExceptions = ConcurrentHashMap.newKeySet();
        BatchHelper batchHelper = this.batchFactory.newBatchHelper(this.httpRequestInitializer, this.gcs, this.storageOptions.getMaxRequestsPerBatch(), fullObjectNames.size(), this.storageOptions.getBatchThreads());
        for (StorageResourceId fullObjectName : fullObjectNames) {
            this.queueSingleObjectDelete(fullObjectName, innerExceptions, batchHelper, 1);
        }
        batchHelper.flush();
        if (!innerExceptions.isEmpty()) {
            throw GoogleCloudStorageExceptions.createCompositeException(innerExceptions);
        }
    }

    private JsonBatchCallback<Void> getDeletionCallback(final StorageResourceId resourceId, final ConcurrentHashMap.KeySetView<IOException, Boolean> innerExceptions, final BatchHelper batchHelper, final int attempt, final long generation) {
        return new JsonBatchCallback<Void>(){

            @Override
            public void onSuccess(Void obj, HttpHeaders responseHeaders) {
                ((GoogleLogger.Api)logger.atFine()).log("Successfully deleted %s at generation %s", (Object)resourceId, generation);
            }

            @Override
            public void onFailure(GoogleJsonError jsonError, HttpHeaders responseHeaders) throws IOException {
                GoogleJsonResponseException cause = GoogleCloudStorageExceptions.createJsonResponseException(jsonError, responseHeaders);
                if (GoogleCloudStorageImpl.this.errorExtractor.itemNotFound(cause)) {
                    ((GoogleLogger.Api)logger.atFine()).log("Delete object '%s' not found:%n%s", (Object)resourceId, (Object)jsonError);
                } else if (GoogleCloudStorageImpl.this.errorExtractor.preconditionNotMet(cause) && attempt <= 4) {
                    ((GoogleLogger.Api)logger.atInfo()).log("Precondition not met while deleting '%s' at generation %s. Attempt %s. Retrying:%n%s", resourceId, generation, attempt, jsonError);
                    GoogleCloudStorageImpl.this.queueSingleObjectDelete(resourceId, innerExceptions, batchHelper, attempt + 1);
                } else {
                    innerExceptions.add(new IOException(String.format("Error deleting '%s', stage 2 with generation %s", resourceId, generation), cause));
                }
            }
        };
    }

    private void queueSingleObjectDelete(final StorageResourceId resourceId, final ConcurrentHashMap.KeySetView<IOException, Boolean> innerExceptions, final BatchHelper batchHelper, final int attempt) throws IOException {
        final String bucketName = resourceId.getBucketName();
        final String objectName = resourceId.getObjectName();
        if (resourceId.hasGenerationId()) {
            long generationId = resourceId.getGenerationId();
            Storage.Objects.Delete deleteObject = this.configureRequest(this.gcs.objects().delete(bucketName, objectName), bucketName).setIfGenerationMatch(generationId);
            batchHelper.queue(deleteObject, this.getDeletionCallback(resourceId, innerExceptions, batchHelper, attempt, generationId));
        } else {
            Storage.Objects.Get getObject = this.configureRequest(this.gcs.objects().get(bucketName, objectName), bucketName);
            batchHelper.queue(getObject, new JsonBatchCallback<StorageObject>(){

                @Override
                public void onSuccess(StorageObject storageObject, HttpHeaders httpHeaders) throws IOException {
                    Long generation = storageObject.getGeneration();
                    Storage.Objects.Delete deleteObject = GoogleCloudStorageImpl.this.configureRequest(GoogleCloudStorageImpl.this.gcs.objects().delete(bucketName, objectName), bucketName).setIfGenerationMatch(generation);
                    batchHelper.queue(deleteObject, GoogleCloudStorageImpl.this.getDeletionCallback(resourceId, innerExceptions, batchHelper, attempt, generation));
                }

                @Override
                public void onFailure(GoogleJsonError jsonError, HttpHeaders responseHeaders) {
                    GoogleJsonResponseException cause = GoogleCloudStorageExceptions.createJsonResponseException(jsonError, responseHeaders);
                    if (GoogleCloudStorageImpl.this.errorExtractor.itemNotFound(cause)) {
                        ((GoogleLogger.Api)logger.atFine()).log("deleteObjects(%s): get not found:%n%s", (Object)resourceId, (Object)jsonError);
                    } else {
                        innerExceptions.add(new IOException(String.format("Error deleting '%s', stage 1", resourceId), cause));
                    }
                }
            });
        }
    }

    public static void validateCopyArguments(String srcBucketName, List<String> srcObjectNames, String dstBucketName, List<String> dstObjectNames, GoogleCloudStorage gcsImpl) throws IOException {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(srcBucketName), "srcBucketName must not be null or empty");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(dstBucketName), "dstBucketName must not be null or empty");
        Preconditions.checkArgument(srcObjectNames != null, "srcObjectNames must not be null");
        Preconditions.checkArgument(dstObjectNames != null, "dstObjectNames must not be null");
        Preconditions.checkArgument(srcObjectNames.size() == dstObjectNames.size(), "Must supply same number of elements in srcObjectNames and dstObjectNames");
        if (!srcBucketName.equals(dstBucketName)) {
            GoogleCloudStorageItemInfo srcBucketInfo = gcsImpl.getItemInfo(new StorageResourceId(srcBucketName));
            if (!srcBucketInfo.exists()) {
                throw new FileNotFoundException("Bucket not found: " + srcBucketName);
            }
            GoogleCloudStorageItemInfo dstBucketInfo = gcsImpl.getItemInfo(new StorageResourceId(dstBucketName));
            if (!dstBucketInfo.exists()) {
                throw new FileNotFoundException("Bucket not found: " + dstBucketName);
            }
            if (!gcsImpl.getOptions().isCopyWithRewriteEnabled()) {
                if (!srcBucketInfo.getLocation().equals(dstBucketInfo.getLocation())) {
                    throw new UnsupportedOperationException("This operation is not supported across two different storage locations.");
                }
                if (!srcBucketInfo.getStorageClass().equals(dstBucketInfo.getStorageClass())) {
                    throw new UnsupportedOperationException("This operation is not supported across two different storage classes.");
                }
            }
        }
        for (int i = 0; i < srcObjectNames.size(); ++i) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(srcObjectNames.get(i)), "srcObjectName must not be null or empty");
            Preconditions.checkArgument(!Strings.isNullOrEmpty(dstObjectNames.get(i)), "dstObjectName must not be null or empty");
            if (!srcBucketName.equals(dstBucketName) || !srcObjectNames.get(i).equals(dstObjectNames.get(i))) continue;
            throw new IllegalArgumentException(String.format("Copy destination must be different from source for %s.", StorageResourceId.createReadableString(srcBucketName, srcObjectNames.get(i))));
        }
    }

    @Override
    public void copy(String srcBucketName, List<String> srcObjectNames, String dstBucketName, List<String> dstObjectNames) throws IOException {
        GoogleCloudStorageImpl.validateCopyArguments(srcBucketName, srcObjectNames, dstBucketName, dstObjectNames, this);
        if (srcObjectNames.isEmpty()) {
            return;
        }
        ConcurrentHashMap.KeySetView<IOException, Boolean> innerExceptions = ConcurrentHashMap.newKeySet();
        BatchHelper batchHelper = this.batchFactory.newBatchHelper(this.httpRequestInitializer, this.gcs, this.storageOptions.getCopyMaxRequestsPerBatch(), srcObjectNames.size(), this.storageOptions.getCopyBatchThreads());
        for (int i = 0; i < srcObjectNames.size(); ++i) {
            if (this.storageOptions.isCopyWithRewriteEnabled()) {
                this.rewriteInternal(batchHelper, innerExceptions, srcBucketName, srcObjectNames.get(i), dstBucketName, dstObjectNames.get(i));
                continue;
            }
            this.copyInternal(batchHelper, innerExceptions, srcBucketName, srcObjectNames.get(i), dstBucketName, dstObjectNames.get(i));
        }
        batchHelper.flush();
        if (!innerExceptions.isEmpty()) {
            throw GoogleCloudStorageExceptions.createCompositeException(innerExceptions);
        }
    }

    private void rewriteInternal(final BatchHelper batchHelper, final ConcurrentHashMap.KeySetView<IOException, Boolean> innerExceptions, final String srcBucketName, final String srcObjectName, final String dstBucketName, final String dstObjectName) throws IOException {
        Storage.Objects.Rewrite rewriteObject = this.configureRequest(this.gcs.objects().rewrite(srcBucketName, srcObjectName, dstBucketName, dstObjectName, null), srcBucketName);
        if (this.storageOptions.getMaxBytesRewrittenPerCall() > 0L) {
            rewriteObject.setMaxBytesRewrittenPerCall(this.storageOptions.getMaxBytesRewrittenPerCall());
        }
        batchHelper.queue(rewriteObject, new JsonBatchCallback<RewriteResponse>(){

            @Override
            public void onSuccess(RewriteResponse rewriteResponse, HttpHeaders responseHeaders) {
                String srcString = StorageResourceId.createReadableString(srcBucketName, srcObjectName);
                String dstString = StorageResourceId.createReadableString(dstBucketName, dstObjectName);
                if (rewriteResponse.getDone().booleanValue()) {
                    ((GoogleLogger.Api)logger.atFine()).log("Successfully copied %s to %s", (Object)srcString, (Object)dstString);
                } else {
                    ((GoogleLogger.Api)logger.atFine()).log("Copy (%s to %s) did not complete. Resuming...", (Object)srcString, (Object)dstString);
                    try {
                        Storage.Objects.Rewrite rewriteObjectWithToken = GoogleCloudStorageImpl.this.configureRequest(GoogleCloudStorageImpl.this.gcs.objects().rewrite(srcBucketName, srcObjectName, dstBucketName, dstObjectName, null), srcBucketName);
                        if (GoogleCloudStorageImpl.this.storageOptions.getMaxBytesRewrittenPerCall() > 0L) {
                            rewriteObjectWithToken.setMaxBytesRewrittenPerCall(GoogleCloudStorageImpl.this.storageOptions.getMaxBytesRewrittenPerCall());
                        }
                        rewriteObjectWithToken.setRewriteToken(rewriteResponse.getRewriteToken());
                        batchHelper.queue(rewriteObjectWithToken, this);
                    }
                    catch (IOException e) {
                        innerExceptions.add(e);
                    }
                }
            }

            @Override
            public void onFailure(GoogleJsonError e, HttpHeaders responseHeaders) {
                GoogleCloudStorageImpl.this.onCopyFailure(innerExceptions, e, responseHeaders, srcBucketName, srcObjectName);
            }
        });
    }

    private void copyInternal(BatchHelper batchHelper, final ConcurrentHashMap.KeySetView<IOException, Boolean> innerExceptions, final String srcBucketName, final String srcObjectName, final String dstBucketName, final String dstObjectName) throws IOException {
        Storage.Objects.Copy copyObject = this.configureRequest(this.gcs.objects().copy(srcBucketName, srcObjectName, dstBucketName, dstObjectName, null), srcBucketName);
        batchHelper.queue(copyObject, new JsonBatchCallback<StorageObject>(){

            @Override
            public void onSuccess(StorageObject copyResponse, HttpHeaders responseHeaders) {
                String srcString = StorageResourceId.createReadableString(srcBucketName, srcObjectName);
                String dstString = StorageResourceId.createReadableString(dstBucketName, dstObjectName);
                ((GoogleLogger.Api)logger.atFine()).log("Successfully copied %s to %s", (Object)srcString, (Object)dstString);
            }

            @Override
            public void onFailure(GoogleJsonError jsonError, HttpHeaders responseHeaders) {
                GoogleCloudStorageImpl.this.onCopyFailure(innerExceptions, jsonError, responseHeaders, srcBucketName, srcObjectName);
            }
        });
    }

    private void onCopyFailure(ConcurrentHashMap.KeySetView<IOException, Boolean> innerExceptions, GoogleJsonError jsonError, HttpHeaders responseHeaders, String srcBucketName, String srcObjectName) {
        GoogleJsonResponseException cause = GoogleCloudStorageExceptions.createJsonResponseException(jsonError, responseHeaders);
        innerExceptions.add(this.errorExtractor.itemNotFound(cause) ? GoogleCloudStorageExceptions.createFileNotFoundException(srcBucketName, srcObjectName, cause) : new IOException(String.format("Error copying '%s'", StorageResourceId.createReadableString(srcBucketName, srcObjectName)), cause));
    }

    private List<Bucket> listBucketsInternal() throws IOException {
        Buckets items;
        ((GoogleLogger.Api)logger.atFine()).log("listBucketsInternal()");
        Preconditions.checkNotNull(this.storageOptions.getProjectId(), "projectId must not be null");
        ArrayList<Bucket> allBuckets = new ArrayList<Bucket>();
        Storage.Buckets.List listBucket = this.configureRequest(this.gcs.buckets().list(this.storageOptions.getProjectId()), null);
        listBucket.setMaxResults(this.storageOptions.getMaxListItemsPerCall());
        String pageToken = null;
        do {
            List<Bucket> buckets;
            if (pageToken != null) {
                ((GoogleLogger.Api)logger.atFine()).log("listBucketsInternal: next page %s", pageToken);
                listBucket.setPageToken(pageToken);
            }
            if ((buckets = (items = (Buckets)listBucket.execute()).getItems()) == null) continue;
            ((GoogleLogger.Api)logger.atFine()).log("listed %s items", buckets.size());
            allBuckets.addAll(buckets);
        } while ((pageToken = items.getNextPageToken()) != null);
        return allBuckets;
    }

    @Override
    public List<String> listBucketNames() throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("listBucketNames()");
        List<Bucket> allBuckets = this.listBucketsInternal();
        ArrayList<String> bucketNames = new ArrayList<String>(allBuckets.size());
        for (Bucket bucket : allBuckets) {
            bucketNames.add(bucket.getName());
        }
        return bucketNames;
    }

    @Override
    public List<GoogleCloudStorageItemInfo> listBucketInfo() throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("listBucketInfo()");
        List<Bucket> allBuckets = this.listBucketsInternal();
        ArrayList<GoogleCloudStorageItemInfo> bucketInfos = new ArrayList<GoogleCloudStorageItemInfo>(allBuckets.size());
        for (Bucket bucket : allBuckets) {
            bucketInfos.add(new GoogleCloudStorageItemInfo(new StorageResourceId(bucket.getName()), bucket.getTimeCreated().getValue(), bucket.getUpdated().getValue(), 0L, bucket.getLocation(), bucket.getStorageClass()));
        }
        return bucketInfos;
    }

    private Storage.Objects.Insert prepareEmptyInsert(StorageResourceId resourceId, CreateObjectOptions createObjectOptions) throws IOException {
        Map<String, String> rewrittenMetadata = GoogleCloudStorageImpl.encodeMetadata(createObjectOptions.getMetadata());
        StorageObject object = new StorageObject().setName(resourceId.getObjectName()).setMetadata(rewrittenMetadata).setContentEncoding(createObjectOptions.getContentEncoding());
        ByteArrayContent emptyContent = new ByteArrayContent(createObjectOptions.getContentType(), new byte[0]);
        Storage.Objects.Insert insertObject = this.configureRequest(this.gcs.objects().insert(resourceId.getBucketName(), object, emptyContent), resourceId.getBucketName());
        insertObject.setDisableGZipContent(true);
        this.clientRequestHelper.setDirectUploadEnabled(insertObject, true);
        if (resourceId.hasGenerationId()) {
            insertObject.setIfGenerationMatch(resourceId.getGenerationId());
        } else if (!createObjectOptions.overwriteExisting()) {
            insertObject.setIfGenerationMatch(0L);
        }
        return insertObject;
    }

    private void listStorageObjectsAndPrefixes(String bucketName, String objectNamePrefix, String delimiter, boolean includeTrailingDelimiter, long maxResults, List<StorageObject> listedObjects, List<String> listedPrefixes) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("listStorageObjectsAndPrefixes(%s, %s, %s, %s, %d)", bucketName, objectNamePrefix, delimiter, includeTrailingDelimiter, maxResults);
        Preconditions.checkArgument(listedObjects != null && listedObjects.isEmpty(), "Must provide a non-null empty container for listedObjects.");
        Preconditions.checkArgument(listedPrefixes != null && listedPrefixes.isEmpty(), "Must provide a non-null empty container for listedPrefixes.");
        Storage.Objects.List listObject = this.createListRequest(bucketName, objectNamePrefix, delimiter, includeTrailingDelimiter, maxResults);
        String pageToken = null;
        do {
            if (pageToken == null) continue;
            ((GoogleLogger.Api)logger.atFine()).log("listStorageObjectsAndPrefixes: next page %s", pageToken);
            listObject.setPageToken(pageToken);
        } while ((pageToken = this.listStorageObjectsAndPrefixesPage(listObject, maxResults, listedObjects, listedPrefixes)) != null && GoogleCloudStorageImpl.getMaxRemainingResults(maxResults, listedPrefixes, listedObjects) > 0L);
    }

    private String listStorageObjectsAndPrefixesPage(Storage.Objects.List listObject, long maxResults, List<StorageObject> listedObjects, List<String> listedPrefixes) throws IOException {
        List<StorageObject> objects;
        Objects items;
        ((GoogleLogger.Api)logger.atFine()).log("listStorageObjectsAndPrefixesPage(%s, %d)", (Object)listObject, maxResults);
        Preconditions.checkNotNull(listedObjects, "Must provide a non-null container for listedObjects.");
        Preconditions.checkNotNull(listedPrefixes, "Must provide a non-null container for listedPrefixes.");
        LinkedHashSet<String> prefixes = new LinkedHashSet<String>(listedPrefixes);
        try {
            items = (Objects)listObject.execute();
        }
        catch (IOException e) {
            String resource = StorageResourceId.createReadableString(listObject.getBucket(), listObject.getPrefix());
            if (this.errorExtractor.itemNotFound(e)) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withCause(e)).log("listStorageObjectsAndPrefixesPage(%s, %d): item not found", (Object)resource, maxResults);
                return null;
            }
            throw new IOException("Error listing " + resource, e);
        }
        List<String> pagePrefixes = items.getPrefixes();
        if (pagePrefixes != null) {
            ((GoogleLogger.Api)logger.atFine()).log("listed %s prefixes", pagePrefixes.size());
            long maxRemainingResults = GoogleCloudStorageImpl.getMaxRemainingResults(maxResults, prefixes, listedObjects);
            long maxPrefixes = Math.min(maxRemainingResults, (long)pagePrefixes.size());
            prefixes.addAll(pagePrefixes.subList(0, (int)maxPrefixes));
        }
        if ((objects = items.getItems()) != null) {
            ((GoogleLogger.Api)logger.atFine()).log("listed %s objects", objects.size());
            String objectNamePrefix = listObject.getPrefix();
            boolean objectPrefixEndsWithDelimiter = !Strings.isNullOrEmpty(objectNamePrefix) && objectNamePrefix.endsWith("/");
            long maxRemainingResults = GoogleCloudStorageImpl.getMaxRemainingResults(maxResults, prefixes, listedObjects);
            for (StorageObject object : objects) {
                String objectName = object.getName();
                if (objectPrefixEndsWithDelimiter && objectName.equals(objectNamePrefix)) continue;
                if (prefixes.remove(objectName)) {
                    listedObjects.add(object);
                    continue;
                }
                if (maxRemainingResults <= 0L) continue;
                listedObjects.add(object);
                --maxRemainingResults;
            }
        }
        listedPrefixes.clear();
        listedPrefixes.addAll(prefixes);
        return items.getNextPageToken();
    }

    private Storage.Objects.List createListRequest(String bucketName, String objectNamePrefix, String delimiter, boolean includeTrailingDelimiter, long maxResults) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("createListRequest(%s, %s, %s, %s, %d)", bucketName, objectNamePrefix, delimiter, includeTrailingDelimiter, maxResults);
        Preconditions.checkArgument(!Strings.isNullOrEmpty(bucketName), "bucketName must not be null or empty");
        Storage.Objects.List listObject = this.configureRequest(this.gcs.objects().list(bucketName), bucketName);
        if (delimiter != null) {
            listObject.setDelimiter(delimiter);
            listObject.setIncludeTrailingDelimiter(includeTrailingDelimiter);
        }
        if (maxResults <= 0L || maxResults + 1L >= this.storageOptions.getMaxListItemsPerCall()) {
            listObject.setMaxResults(this.storageOptions.getMaxListItemsPerCall());
        } else {
            listObject.setMaxResults(maxResults + 1L);
        }
        if (!Strings.isNullOrEmpty(objectNamePrefix)) {
            listObject.setPrefix(objectNamePrefix);
        }
        return listObject;
    }

    private static long getMaxRemainingResults(long maxResults, Collection<String> prefixes, List<StorageObject> objects) {
        if (maxResults <= 0L) {
            return Long.MAX_VALUE;
        }
        long numResults = (long)prefixes.size() + (long)objects.size();
        return maxResults - numResults;
    }

    @Override
    public List<String> listObjectNames(String bucketName, String objectNamePrefix, String delimiter) throws IOException {
        return this.listObjectNames(bucketName, objectNamePrefix, delimiter, -1L);
    }

    @Override
    public List<String> listObjectNames(String bucketName, String objectNamePrefix, String delimiter, long maxResults) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("listObjectNames(%s, %s, %s, %s)", bucketName, objectNamePrefix, delimiter, maxResults);
        ArrayList<StorageObject> listedObjects = new ArrayList<StorageObject>();
        ArrayList<String> listedPrefixes = new ArrayList<String>();
        this.listStorageObjectsAndPrefixes(bucketName, objectNamePrefix, delimiter, false, maxResults, listedObjects, listedPrefixes);
        ArrayList<String> objectNames = listedPrefixes;
        for (StorageObject obj : listedObjects) {
            objectNames.add(obj.getName());
        }
        return objectNames;
    }

    @Override
    public List<GoogleCloudStorageItemInfo> listObjectInfo(String bucketName, String objectNamePrefix, String delimiter) throws IOException {
        return this.listObjectInfo(bucketName, objectNamePrefix, delimiter, -1L);
    }

    @Override
    public List<GoogleCloudStorageItemInfo> listObjectInfo(String bucketName, String objectNamePrefix, String delimiter, long maxResults) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("listObjectInfo(%s, %s, %s, %s)", bucketName, objectNamePrefix, delimiter, maxResults);
        ArrayList<StorageObject> listedObjects = new ArrayList<StorageObject>();
        ArrayList<String> listedPrefixes = new ArrayList<String>();
        this.listStorageObjectsAndPrefixes(bucketName, objectNamePrefix, delimiter, true, maxResults, listedObjects, listedPrefixes);
        ArrayList<GoogleCloudStorageItemInfo> objectInfos = new ArrayList<GoogleCloudStorageItemInfo>(listedObjects.size());
        for (StorageObject obj : listedObjects) {
            objectInfos.add(GoogleCloudStorageImpl.createItemInfoForStorageObject(new StorageResourceId(bucketName, obj.getName()), obj));
        }
        if (listedPrefixes.isEmpty()) {
            return objectInfos;
        }
        this.handlePrefixes(bucketName, listedPrefixes, objectInfos);
        return objectInfos;
    }

    @Override
    public GoogleCloudStorage.ListPage<GoogleCloudStorageItemInfo> listObjectInfoPage(String bucketName, String objectNamePrefix, String delimiter, String pageToken) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("listObjectInfoPage(%s, %s, %s, %s)", bucketName, objectNamePrefix, delimiter, pageToken);
        Storage.Objects.List listObject = this.createListRequest(bucketName, objectNamePrefix, delimiter, true, -1L);
        if (pageToken != null) {
            ((GoogleLogger.Api)logger.atFine()).log("listObjectInfoPage: next page %s", pageToken);
            listObject.setPageToken(pageToken);
        }
        ArrayList<StorageObject> listedObjects = new ArrayList<StorageObject>();
        ArrayList<String> listedPrefixes = new ArrayList<String>();
        String nextPageToken = this.listStorageObjectsAndPrefixesPage(listObject, -1L, listedObjects, listedPrefixes);
        ArrayList<GoogleCloudStorageItemInfo> objectInfos = new ArrayList<GoogleCloudStorageItemInfo>(listedObjects.size());
        for (StorageObject obj : listedObjects) {
            objectInfos.add(GoogleCloudStorageImpl.createItemInfoForStorageObject(new StorageResourceId(bucketName, obj.getName()), obj));
        }
        if (!listedPrefixes.isEmpty()) {
            this.handlePrefixes(bucketName, listedPrefixes, objectInfos);
        }
        return new GoogleCloudStorage.ListPage<GoogleCloudStorageItemInfo>(objectInfos, nextPageToken);
    }

    private void handlePrefixes(String bucketName, List<String> prefixes, List<GoogleCloudStorageItemInfo> objectInfos) {
        if (this.storageOptions.isInferImplicitDirectoriesEnabled()) {
            for (String prefix : prefixes) {
                objectInfos.add(GoogleCloudStorageItemInfo.createInferredDirectory(new StorageResourceId(bucketName, prefix)));
            }
        } else {
            ((GoogleLogger.Api)logger.atInfo()).log("Inferred directories are disabled, giving up on retrieving missing directories: %s", prefixes);
        }
    }

    public static GoogleCloudStorageItemInfo createItemInfoForBucket(StorageResourceId resourceId, Bucket bucket) {
        Preconditions.checkArgument(resourceId != null, "resourceId must not be null");
        Preconditions.checkArgument(bucket != null, "bucket must not be null");
        Preconditions.checkArgument(resourceId.isBucket(), "resourceId must be a Bucket. resourceId: %s", (Object)resourceId);
        Preconditions.checkArgument(resourceId.getBucketName().equals(bucket.getName()), "resourceId.getBucketName() must equal bucket.getName(): '%s' vs '%s'", (Object)resourceId.getBucketName(), (Object)bucket.getName());
        return new GoogleCloudStorageItemInfo(resourceId, bucket.getTimeCreated().getValue(), bucket.getUpdated().getValue(), 0L, bucket.getLocation(), bucket.getStorageClass());
    }

    public static GoogleCloudStorageItemInfo createItemInfoForStorageObject(StorageResourceId resourceId, StorageObject object) {
        Preconditions.checkArgument(resourceId != null, "resourceId must not be null");
        Preconditions.checkArgument(object != null, "object must not be null");
        Preconditions.checkArgument(resourceId.isStorageObject(), "resourceId must be a StorageObject. resourceId: %s", (Object)resourceId);
        Preconditions.checkArgument(resourceId.getBucketName().equals(object.getBucket()), "resourceId.getBucketName() must equal object.getBucket(): '%s' vs '%s'", (Object)resourceId.getBucketName(), (Object)object.getBucket());
        Preconditions.checkArgument(resourceId.getObjectName().equals(object.getName()), "resourceId.getObjectName() must equal object.getName(): '%s' vs '%s'", (Object)resourceId.getObjectName(), (Object)object.getName());
        Map<String, byte[]> decodedMetadata = object.getMetadata() == null ? null : GoogleCloudStorageImpl.decodeMetadata(object.getMetadata());
        byte[] md5Hash = null;
        byte[] crc32c = null;
        if (!Strings.isNullOrEmpty(object.getCrc32c())) {
            crc32c = BaseEncoding.base64().decode(object.getCrc32c());
        }
        if (!Strings.isNullOrEmpty(object.getMd5Hash())) {
            md5Hash = BaseEncoding.base64().decode(object.getMd5Hash());
        }
        return new GoogleCloudStorageItemInfo(resourceId, object.getTimeCreated().getValue(), object.getUpdated().getValue(), object.getSize().longValue(), null, null, object.getContentType(), object.getContentEncoding(), decodedMetadata, object.getGeneration(), object.getMetageneration(), new VerificationAttributes(md5Hash, crc32c));
    }

    @VisibleForTesting
    static Map<String, String> encodeMetadata(Map<String, byte[]> metadata) {
        return Maps.transformValues(metadata, GoogleCloudStorageImpl::encodeMetadataValues);
    }

    @VisibleForTesting
    static Map<String, byte[]> decodeMetadata(Map<String, String> metadata) {
        return Maps.transformValues(metadata, GoogleCloudStorageImpl::decodeMetadataValues);
    }

    @Override
    public List<GoogleCloudStorageItemInfo> getItemInfos(List<StorageResourceId> resourceIds) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("getItemInfos(%s)", resourceIds);
        if (resourceIds.isEmpty()) {
            return new ArrayList<GoogleCloudStorageItemInfo>();
        }
        final ConcurrentHashMap<StorageResourceId, GoogleCloudStorageItemInfo> itemInfos = new ConcurrentHashMap<StorageResourceId, GoogleCloudStorageItemInfo>();
        final Set<IOException> innerExceptions = Sets.newConcurrentHashSet();
        BatchHelper batchHelper = this.batchFactory.newBatchHelper(this.httpRequestInitializer, this.gcs, this.storageOptions.getMaxRequestsPerBatch(), resourceIds.size(), this.storageOptions.getBatchThreads());
        for (final StorageResourceId resourceId : resourceIds) {
            if (resourceId.isRoot()) {
                itemInfos.put(resourceId, GoogleCloudStorageItemInfo.ROOT_INFO);
                continue;
            }
            if (resourceId.isBucket()) {
                batchHelper.queue(this.configureRequest(this.gcs.buckets().get(resourceId.getBucketName()), resourceId.getBucketName()), new JsonBatchCallback<Bucket>(){

                    @Override
                    public void onSuccess(Bucket bucket, HttpHeaders responseHeaders) {
                        ((GoogleLogger.Api)logger.atFine()).log("getItemInfos: Successfully fetched bucket: %s for resourceId: %s", (Object)bucket, (Object)resourceId);
                        itemInfos.put(resourceId, GoogleCloudStorageImpl.createItemInfoForBucket(resourceId, bucket));
                    }

                    @Override
                    public void onFailure(GoogleJsonError jsonError, HttpHeaders responseHeaders) {
                        GoogleJsonResponseException cause = GoogleCloudStorageExceptions.createJsonResponseException(jsonError, responseHeaders);
                        if (GoogleCloudStorageImpl.this.errorExtractor.itemNotFound(cause)) {
                            ((GoogleLogger.Api)logger.atFine()).log("getItemInfos: bucket '%s' not found:%n%s", (Object)resourceId.getBucketName(), (Object)jsonError);
                            itemInfos.put(resourceId, GoogleCloudStorageItemInfo.createNotFound(resourceId));
                        } else {
                            innerExceptions.add(new IOException(String.format("Error getting '%s' bucket", resourceId.getBucketName()), cause));
                        }
                    }
                });
                continue;
            }
            String bucketName = resourceId.getBucketName();
            String objectName = resourceId.getObjectName();
            batchHelper.queue(this.configureRequest(this.gcs.objects().get(bucketName, objectName), bucketName), new JsonBatchCallback<StorageObject>(){

                @Override
                public void onSuccess(StorageObject obj, HttpHeaders responseHeaders) {
                    ((GoogleLogger.Api)logger.atFine()).log("getItemInfos: Successfully fetched object '%s' for resourceId '%s'", (Object)obj, (Object)resourceId);
                    itemInfos.put(resourceId, GoogleCloudStorageImpl.createItemInfoForStorageObject(resourceId, obj));
                }

                @Override
                public void onFailure(GoogleJsonError jsonError, HttpHeaders responseHeaders) {
                    GoogleJsonResponseException cause = GoogleCloudStorageExceptions.createJsonResponseException(jsonError, responseHeaders);
                    if (GoogleCloudStorageImpl.this.errorExtractor.itemNotFound(cause)) {
                        ((GoogleLogger.Api)logger.atFine()).log("getItemInfos: object '%s' not found:%n%s", (Object)resourceId, (Object)jsonError);
                        itemInfos.put(resourceId, GoogleCloudStorageItemInfo.createNotFound(resourceId));
                    } else {
                        innerExceptions.add(new IOException(String.format("Error getting '%s' object", resourceId), cause));
                    }
                }
            });
        }
        batchHelper.flush();
        if (!innerExceptions.isEmpty()) {
            throw GoogleCloudStorageExceptions.createCompositeException(innerExceptions);
        }
        ArrayList<GoogleCloudStorageItemInfo> sortedItemInfos = new ArrayList<GoogleCloudStorageItemInfo>();
        for (StorageResourceId resourceId : resourceIds) {
            Preconditions.checkState(itemInfos.containsKey(resourceId), "Somehow missing resourceId '%s' from map: %s", (Object)resourceId, itemInfos);
            sortedItemInfos.add((GoogleCloudStorageItemInfo)itemInfos.get(resourceId));
        }
        Preconditions.checkState(sortedItemInfos.size() == resourceIds.size(), "sortedItemInfos.size() (%s) != resourceIds.size() (%s). infos: %s, ids: %s", (Object)sortedItemInfos.size(), (Object)resourceIds.size(), sortedItemInfos, resourceIds);
        return sortedItemInfos;
    }

    @Override
    public List<GoogleCloudStorageItemInfo> updateItems(List<UpdatableItemInfo> itemInfoList) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("updateItems(%s)", itemInfoList);
        if (itemInfoList.isEmpty()) {
            return new ArrayList<GoogleCloudStorageItemInfo>();
        }
        final ConcurrentHashMap resultItemInfos = new ConcurrentHashMap();
        final Set<IOException> innerExceptions = Sets.newConcurrentHashSet();
        BatchHelper batchHelper = this.batchFactory.newBatchHelper(this.httpRequestInitializer, this.gcs, this.storageOptions.getMaxRequestsPerBatch(), itemInfoList.size(), this.storageOptions.getBatchThreads());
        for (UpdatableItemInfo itemInfo : itemInfoList) {
            Preconditions.checkArgument(!itemInfo.getStorageResourceId().isBucket() && !itemInfo.getStorageResourceId().isRoot(), "Buckets and GCS Root resources are not supported for updateItems");
        }
        for (UpdatableItemInfo itemInfo : itemInfoList) {
            final StorageResourceId resourceId = itemInfo.getStorageResourceId();
            String bucketName = resourceId.getBucketName();
            String objectName = resourceId.getObjectName();
            Map<String, byte[]> originalMetadata = itemInfo.getMetadata();
            Map<String, String> rewrittenMetadata = GoogleCloudStorageImpl.encodeMetadata(originalMetadata);
            Storage.Objects.Patch patch = this.configureRequest(this.gcs.objects().patch(bucketName, objectName, new StorageObject().setMetadata(rewrittenMetadata)), bucketName);
            batchHelper.queue(patch, new JsonBatchCallback<StorageObject>(){

                @Override
                public void onSuccess(StorageObject obj, HttpHeaders responseHeaders) {
                    ((GoogleLogger.Api)logger.atFine()).log("updateItems: Successfully updated object '%s' for resourceId '%s'", (Object)obj, (Object)resourceId);
                    resultItemInfos.put(resourceId, GoogleCloudStorageImpl.createItemInfoForStorageObject(resourceId, obj));
                }

                @Override
                public void onFailure(GoogleJsonError jsonError, HttpHeaders responseHeaders) {
                    GoogleJsonResponseException cause = GoogleCloudStorageExceptions.createJsonResponseException(jsonError, responseHeaders);
                    if (GoogleCloudStorageImpl.this.errorExtractor.itemNotFound(cause)) {
                        ((GoogleLogger.Api)logger.atFine()).log("updateItems: object not found %s:%n%s", (Object)resourceId, (Object)jsonError);
                        resultItemInfos.put(resourceId, GoogleCloudStorageItemInfo.createNotFound(resourceId));
                    } else {
                        innerExceptions.add(new IOException(String.format("Error updating '%s' object", resourceId), cause));
                    }
                }
            });
        }
        batchHelper.flush();
        if (!innerExceptions.isEmpty()) {
            throw GoogleCloudStorageExceptions.createCompositeException(innerExceptions);
        }
        ArrayList<GoogleCloudStorageItemInfo> sortedItemInfos = new ArrayList<GoogleCloudStorageItemInfo>();
        for (UpdatableItemInfo itemInfo : itemInfoList) {
            Preconditions.checkState(resultItemInfos.containsKey(itemInfo.getStorageResourceId()), "Missing resourceId '%s' from map: %s", (Object)itemInfo.getStorageResourceId(), resultItemInfos);
            sortedItemInfos.add((GoogleCloudStorageItemInfo)resultItemInfos.get(itemInfo.getStorageResourceId()));
        }
        Preconditions.checkState(sortedItemInfos.size() == itemInfoList.size(), "sortedItemInfos.size() (%s) != resourceIds.size() (%s). infos: %s, updateItemInfos: %s", (Object)sortedItemInfos.size(), (Object)itemInfoList.size(), sortedItemInfos, itemInfoList);
        return sortedItemInfos;
    }

    @Override
    public GoogleCloudStorageItemInfo getItemInfo(StorageResourceId resourceId) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("getItemInfo(%s)", resourceId);
        if (resourceId.isRoot()) {
            return GoogleCloudStorageItemInfo.ROOT_INFO;
        }
        GoogleCloudStorageItemInfo itemInfo = null;
        if (resourceId.isBucket()) {
            Bucket bucket = this.getBucket(resourceId.getBucketName());
            if (bucket != null) {
                itemInfo = GoogleCloudStorageImpl.createItemInfoForBucket(resourceId, bucket);
            }
        } else {
            StorageObject object = this.getObject(resourceId);
            if (object != null) {
                itemInfo = GoogleCloudStorageImpl.createItemInfoForStorageObject(resourceId, object);
            }
        }
        if (itemInfo == null) {
            itemInfo = GoogleCloudStorageItemInfo.createNotFound(resourceId);
        }
        ((GoogleLogger.Api)logger.atFine()).log("getItemInfo: %s", itemInfo);
        return itemInfo;
    }

    @Override
    public void close() {
        ((GoogleLogger.Api)logger.atFine()).log("close()");
        try {
            this.backgroundTasksThreadPool.shutdown();
            this.manualBatchingThreadPool.shutdown();
        }
        finally {
            this.backgroundTasksThreadPool = null;
            this.manualBatchingThreadPool = null;
        }
    }

    private Bucket getBucket(String bucketName) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("getBucket(%s)", bucketName);
        Preconditions.checkArgument(!Strings.isNullOrEmpty(bucketName), "bucketName must not be null or empty");
        Storage.Buckets.Get getBucket = this.configureRequest(this.gcs.buckets().get(bucketName), bucketName);
        try {
            return (Bucket)getBucket.execute();
        }
        catch (IOException e) {
            if (this.errorExtractor.itemNotFound(e)) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withCause(e)).log("getBucket(%s): not found", bucketName);
                return null;
            }
            throw new IOException("Error accessing Bucket " + bucketName, e);
        }
    }

    private long getWriteGeneration(StorageResourceId resourceId, boolean overwritable) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("getWriteGeneration(%s, %s)", (Object)resourceId, overwritable);
        GoogleCloudStorageItemInfo info = this.getItemInfo(resourceId);
        if (!info.exists()) {
            return 0L;
        }
        if (info.exists() && overwritable) {
            long generation = info.getContentGeneration();
            Preconditions.checkState(generation != 0L, "Generation should not be 0 for an existing item");
            return generation;
        }
        throw new FileAlreadyExistsException(String.format("Object %s already exists.", resourceId));
    }

    private StorageObject getObject(StorageResourceId resourceId) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("getObject(%s)", resourceId);
        Preconditions.checkArgument(resourceId.isStorageObject(), "Expected full StorageObject id, got %s", (Object)resourceId);
        String bucketName = resourceId.getBucketName();
        String objectName = resourceId.getObjectName();
        Storage.Objects.Get getObject = this.configureRequest(this.gcs.objects().get(bucketName, objectName), bucketName);
        try {
            return (StorageObject)getObject.execute();
        }
        catch (IOException e) {
            if (this.errorExtractor.itemNotFound(e)) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withCause(e)).log("getObject(%s): not found", resourceId);
                return null;
            }
            throw new IOException("Error accessing " + resourceId, e);
        }
    }

    private boolean canIgnoreExceptionForEmptyObject(IOException exceptionOnCreate, StorageResourceId resourceId, CreateObjectOptions options) throws IOException {
        if (this.errorExtractor.rateLimited(exceptionOnCreate) || this.errorExtractor.internalServerError(exceptionOnCreate)) {
            GoogleCloudStorageItemInfo existingInfo;
            int maxWaitMillis = this.storageOptions.getMaxWaitMillisForEmptyObjectCreation();
            BackOff backOff = maxWaitMillis > 0 ? new ExponentialBackOff.Builder().setMaxElapsedTimeMillis(maxWaitMillis).setMaxIntervalMillis(500).setInitialIntervalMillis(100).setMultiplier(1.5).setRandomizationFactor(0.15).build() : BackOff.STOP_BACKOFF;
            long nextSleep = 0L;
            do {
                if (nextSleep > 0L) {
                    try {
                        this.sleeper.sleep(nextSleep);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        nextSleep = -1L;
                    }
                }
                existingInfo = this.getItemInfo(resourceId);
                long l = nextSleep = nextSleep == -1L ? -1L : backOff.nextBackOffMillis();
            } while (!existingInfo.exists() && nextSleep != -1L);
            if (existingInfo.exists() && existingInfo.getSize() == 0L) {
                if (!options.getRequireMetadataMatchForEmptyObjects()) {
                    return true;
                }
                if (existingInfo.metadataEquals(options.getMetadata())) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void compose(String bucketName, List<String> sources, String destination, String contentType) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("compose(%s, %s, %s, %s)", bucketName, sources, destination, contentType);
        List<StorageResourceId> sourceIds = Lists.transform(sources, objectName -> new StorageResourceId(bucketName, (String)objectName));
        StorageResourceId destinationId = new StorageResourceId(bucketName, destination);
        CreateObjectOptions options = new CreateObjectOptions(true, contentType, CreateObjectOptions.EMPTY_METADATA);
        this.composeObjects(sourceIds, destinationId, options);
    }

    @Override
    public GoogleCloudStorageItemInfo composeObjects(List<StorageResourceId> sources, StorageResourceId destination, CreateObjectOptions options) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("composeObjects(%s, %s, %s)", sources, destination, options);
        for (StorageResourceId inputId : sources) {
            if (destination.getBucketName().equals(inputId.getBucketName())) continue;
            throw new IOException(String.format("Bucket doesn't match for source '%s' and destination '%s'!", inputId, destination));
        }
        List<ComposeRequest.SourceObjects> sourceObjects = Lists.transform(sources, input -> new ComposeRequest.SourceObjects().setName(input.getObjectName()));
        Storage.Objects.Compose compose = this.configureRequest(this.gcs.objects().compose(destination.getBucketName(), destination.getObjectName(), new ComposeRequest().setSourceObjects(sourceObjects).setDestination(new StorageObject().setContentType(options.getContentType()).setContentEncoding(options.getContentEncoding()).setMetadata(GoogleCloudStorageImpl.encodeMetadata(options.getMetadata())))), destination.getBucketName());
        compose.setIfGenerationMatch(destination.hasGenerationId() ? destination.getGenerationId() : this.getWriteGeneration(destination, true));
        ((GoogleLogger.Api)logger.atFine()).log("composeObjects.execute()");
        GoogleCloudStorageItemInfo compositeInfo = GoogleCloudStorageImpl.createItemInfoForStorageObject(destination, (StorageObject)compose.execute());
        ((GoogleLogger.Api)logger.atFine()).log("composeObjects() done, returning: %s", compositeInfo);
        return compositeInfo;
    }

    <RequestT extends StorageRequest<?>> RequestT configureRequest(RequestT request, String bucketName) {
        this.setRequesterPaysProject(request, bucketName);
        return request;
    }

    private <RequestT extends StorageRequest<?>> void setRequesterPaysProject(RequestT request, String bucketName) {
        RequesterPaysOptions requesterPaysOptions = this.storageOptions.getRequesterPaysOptions();
        if (bucketName == null || requesterPaysOptions.getMode() == RequesterPaysOptions.RequesterPaysMode.DISABLED) {
            return;
        }
        if (requesterPaysOptions.getMode() == RequesterPaysOptions.RequesterPaysMode.ENABLED || requesterPaysOptions.getMode() == RequesterPaysOptions.RequesterPaysMode.CUSTOM && requesterPaysOptions.getBuckets().contains(bucketName) || requesterPaysOptions.getMode() == RequesterPaysOptions.RequesterPaysMode.AUTO && this.autoBuckets.getUnchecked(bucketName).booleanValue()) {
            GoogleCloudStorageImpl.setUserProject(request, requesterPaysOptions.getProjectId());
        }
    }

    private static <RequestT extends StorageRequest<?>> void setUserProject(RequestT request, String projectId) {
        Field userProjectField = request.getClassInfo().getField(USER_PROJECT_FIELD_NAME);
        if (userProjectField != null) {
            request.set(USER_PROJECT_FIELD_NAME, projectId);
        }
    }

    public static interface BackOffFactory {
        public static final BackOffFactory DEFAULT = new BackOffFactory(){

            @Override
            public BackOff newBackOff() {
                return new ExponentialBackOff();
            }
        };

        public BackOff newBackOff();
    }
}

