/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.internal;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Attributes;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ChannelLogger;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.InternalChannelz;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.SecurityLevel;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.internal.AltsProtocolNegotiator;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.internal.NettyTsiHandshaker;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.internal.TsiFrameHandler;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.internal.TsiFrameProtector;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.internal.TsiPeer;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.GrpcAttributes;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiationEvent;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiators;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.grpc.netty.ProtocolNegotiationEvent;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.channel.ChannelFutureListener;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.channel.ChannelHandler;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.handler.codec.ByteToMessageDecoder;
import java.security.GeneralSecurityException;
import java.util.List;
import javax.annotation.Nullable;

public final class TsiHandshakeHandler
extends ByteToMessageDecoder {
    private static final int HANDSHAKE_FRAME_SIZE = 1024;
    private final NettyTsiHandshaker handshaker;
    private final HandshakeValidator handshakeValidator;
    private final ChannelHandler next;
    private ProtocolNegotiationEvent pne;

    public TsiHandshakeHandler(ChannelHandler next, NettyTsiHandshaker handshaker, HandshakeValidator handshakeValidator) {
        this.handshaker = Preconditions.checkNotNull(handshaker, "handshaker");
        this.handshakeValidator = Preconditions.checkNotNull(handshakeValidator, "handshakeValidator");
        this.next = Preconditions.checkNotNull(next, "next");
    }

    @Override
    protected void decodeLast(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        this.decode(ctx, in, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (this.handshaker.processBytesFromPeer(in) && this.handshaker.isInProgress()) {
            this.sendHandshake(ctx);
        }
        if (!this.handshaker.isInProgress()) {
            TsiPeer peer = this.handshaker.extractPeer();
            Object authContext = this.handshaker.extractPeerObject();
            HandshakeValidator.SecurityDetails details = this.handshakeValidator.validatePeerObject(authContext);
            TsiFrameProtector protector = this.handshaker.createFrameProtector(ctx.alloc());
            boolean success = false;
            try {
                TsiFrameHandler framer = new TsiFrameHandler(protector);
                ctx.pipeline().addAfter(ctx.name(), null, framer);
                ctx.pipeline().addAfter(ctx.pipeline().context(framer).name(), null, this.next);
                ctx.pipeline().remove(ctx.name());
                this.fireProtocolNegotiationEvent(ctx, peer, authContext, details);
                success = true;
            }
            finally {
                if (!success && protector != null) {
                    protector.destroy();
                }
            }
        }
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof ProtocolNegotiationEvent) {
            Preconditions.checkState(this.pne == null, "negotiation already started");
            this.pne = (ProtocolNegotiationEvent)evt;
            InternalProtocolNegotiators.negotiationLogger(ctx).log(ChannelLogger.ChannelLogLevel.INFO, "TsiHandshake started");
            this.sendHandshake(ctx);
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    private void fireProtocolNegotiationEvent(ChannelHandlerContext ctx, TsiPeer peer, Object authContext, HandshakeValidator.SecurityDetails details) {
        Preconditions.checkState(this.pne != null, "negotiation not yet complete");
        InternalProtocolNegotiators.negotiationLogger(ctx).log(ChannelLogger.ChannelLogLevel.INFO, "TsiHandshake finished");
        ProtocolNegotiationEvent localPne = this.pne;
        Attributes.Builder attrs = InternalProtocolNegotiationEvent.getAttributes(localPne).toBuilder().set(AltsProtocolNegotiator.TSI_PEER_KEY, peer).set(AltsProtocolNegotiator.AUTH_CONTEXT_KEY, authContext).set(GrpcAttributes.ATTR_SECURITY_LEVEL, details.getSecurityLevel());
        localPne = InternalProtocolNegotiationEvent.withAttributes(localPne, attrs.build());
        localPne = InternalProtocolNegotiationEvent.withSecurity(localPne, details.getSecurity());
        ctx.fireUserEventTriggered(localPne);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendHandshake(ChannelHandlerContext ctx) throws GeneralSecurityException {
        while (true) {
            ByteBuf buf;
            boolean written;
            block6: {
                int n;
                written = false;
                buf = ctx.alloc().buffer(1024).retain();
                try {
                    this.handshaker.getBytesToSendToPeer(buf);
                    if (buf.isReadable()) {
                        ctx.writeAndFlush(buf).addListener(ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
                        written = true;
                        break block6;
                    }
                    n = written ? 1 : 2;
                }
                catch (GeneralSecurityException e) {
                    try {
                        throw new GeneralSecurityException("TsiHandshakeHandler encountered exception", e);
                    }
                    catch (Throwable throwable) {
                        buf.release(written ? 1 : 2);
                        throw throwable;
                    }
                }
                buf.release(n);
                return;
            }
            buf.release(written ? 1 : 2);
        }
    }

    @Override
    protected void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
        this.handshaker.close();
    }

    public static abstract class HandshakeValidator {
        public abstract SecurityDetails validatePeerObject(Object var1) throws GeneralSecurityException;

        public static final class SecurityDetails {
            private final SecurityLevel securityLevel;
            private final InternalChannelz.Security security;

            public SecurityDetails(SecurityLevel securityLevel, @Nullable InternalChannelz.Security security) {
                this.securityLevel = Preconditions.checkNotNull(securityLevel, "securityLevel");
                this.security = security;
            }

            public InternalChannelz.Security getSecurity() {
                return this.security;
            }

            public SecurityLevel getSecurityLevel() {
                return this.securityLevel;
            }
        }
    }
}

