/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.internal;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableList;
import com.google.cloud.hadoop.repackaged.gcs.com.google.protobuf.Any;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Attributes;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Channel;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.InternalChannelz;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.SecurityLevel;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Status;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.internal.AltsAuthContext;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.internal.AltsClientOptions;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.internal.AltsHandshakerOptions;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.internal.AltsTsiHandshaker;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.internal.HandshakerServiceGrpc;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.internal.NettyTsiHandshaker;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.internal.RpcProtocolVersionsUtil;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.internal.TsiHandshakeHandler;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.internal.TsiHandshaker;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.internal.TsiHandshakerFactory;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.internal.TsiPeer;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.grpclb.GrpclbConstants;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.ObjectPool;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.grpc.netty.GrpcHttp2ConnectionHandler;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.grpc.netty.InternalNettyChannelBuilder;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiator;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiators;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.channel.ChannelHandler;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.util.AsciiString;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class AltsProtocolNegotiator {
    private static final Logger logger = Logger.getLogger(AltsProtocolNegotiator.class.getName());
    public static final Attributes.Key<TsiPeer> TSI_PEER_KEY = Attributes.Key.create("TSI_PEER");
    public static final Attributes.Key<Object> AUTH_CONTEXT_KEY = Attributes.Key.create("AUTH_CONTEXT_KEY");
    private static final AsciiString SCHEME = AsciiString.of("https");

    public static InternalProtocolNegotiator.ProtocolNegotiator serverAltsProtocolNegotiator(ObjectPool<Channel> handshakerChannelPool) {
        LazyChannel lazyHandshakerChannel = new LazyChannel(handshakerChannelPool);
        final class ServerTsiHandshakerFactory
        implements TsiHandshakerFactory {
            final /* synthetic */ LazyChannel val$lazyHandshakerChannel;

            ServerTsiHandshakerFactory(LazyChannel lazyChannel) {
                this.val$lazyHandshakerChannel = lazyChannel;
            }

            @Override
            public TsiHandshaker newHandshaker(@Nullable String authority) {
                assert (authority == null);
                return AltsTsiHandshaker.newServer(HandshakerServiceGrpc.newStub(this.val$lazyHandshakerChannel.get()), new AltsHandshakerOptions(RpcProtocolVersionsUtil.getRpcProtocolVersions()));
            }
        }
        return new ServerAltsProtocolNegotiator(new ServerTsiHandshakerFactory(lazyHandshakerChannel), lazyHandshakerChannel);
    }

    private AltsProtocolNegotiator() {
    }

    private static final class AltsHandshakeValidator
    extends TsiHandshakeHandler.HandshakeValidator {
        private AltsHandshakeValidator() {
        }

        @Override
        public TsiHandshakeHandler.HandshakeValidator.SecurityDetails validatePeerObject(Object peerObject) throws GeneralSecurityException {
            AltsAuthContext altsAuthContext = (AltsAuthContext)peerObject;
            RpcProtocolVersionsUtil.RpcVersionsCheckResult checkResult = RpcProtocolVersionsUtil.checkRpcProtocolVersions(RpcProtocolVersionsUtil.getRpcProtocolVersions(), altsAuthContext.getPeerRpcVersions());
            if (!checkResult.getResult()) {
                String errorMessage = "Local Rpc Protocol Versions " + RpcProtocolVersionsUtil.getRpcProtocolVersions() + " are not compatible with peer Rpc Protocol Versions " + altsAuthContext.getPeerRpcVersions();
                throw Status.UNAVAILABLE.withDescription(errorMessage).asRuntimeException();
            }
            return new TsiHandshakeHandler.HandshakeValidator.SecurityDetails(SecurityLevel.PRIVACY_AND_INTEGRITY, new InternalChannelz.Security(new InternalChannelz.OtherSecurity("alts", Any.pack(altsAuthContext.context))));
        }
    }

    @VisibleForTesting
    static final class LazyChannel {
        private final ObjectPool<Channel> channelPool;
        private Channel channel;

        @VisibleForTesting
        LazyChannel(ObjectPool<Channel> channelPool) {
            this.channelPool = Preconditions.checkNotNull(channelPool, "channelPool");
        }

        synchronized Channel get() {
            if (this.channel == null) {
                this.channel = this.channelPool.getObject();
            }
            return this.channel;
        }

        synchronized void close() {
            if (this.channel != null) {
                this.channel = this.channelPool.returnObject(this.channel);
            }
        }
    }

    private static final class ClientTsiHandshakerFactory
    implements TsiHandshakerFactory {
        private final ImmutableList<String> targetServiceAccounts;
        private final LazyChannel lazyHandshakerChannel;

        ClientTsiHandshakerFactory(ImmutableList<String> targetServiceAccounts, LazyChannel lazyHandshakerChannel) {
            this.targetServiceAccounts = Preconditions.checkNotNull(targetServiceAccounts, "targetServiceAccounts");
            this.lazyHandshakerChannel = Preconditions.checkNotNull(lazyHandshakerChannel, "lazyHandshakerChannel");
        }

        @Override
        public TsiHandshaker newHandshaker(@Nullable String authority) {
            AltsClientOptions handshakerOptions = new AltsClientOptions.Builder().setRpcProtocolVersions(RpcProtocolVersionsUtil.getRpcProtocolVersions()).setTargetServiceAccounts(this.targetServiceAccounts).setTargetName(authority).build();
            return AltsTsiHandshaker.newClient(HandshakerServiceGrpc.newStub(this.lazyHandshakerChannel.get()), handshakerOptions);
        }
    }

    private static final class GoogleDefaultProtocolNegotiator
    implements InternalProtocolNegotiator.ProtocolNegotiator {
        private final TsiHandshakerFactory handshakerFactory;
        private final LazyChannel lazyHandshakerChannel;
        private final SslContext sslContext;

        GoogleDefaultProtocolNegotiator(TsiHandshakerFactory handshakerFactory, LazyChannel lazyHandshakerChannel, SslContext sslContext) {
            this.handshakerFactory = Preconditions.checkNotNull(handshakerFactory, "handshakerFactory");
            this.lazyHandshakerChannel = Preconditions.checkNotNull(lazyHandshakerChannel, "lazyHandshakerChannel");
            this.sslContext = Preconditions.checkNotNull(sslContext, "checkNotNull");
        }

        @Override
        public AsciiString scheme() {
            return SCHEME;
        }

        @Override
        public ChannelHandler newHandler(GrpcHttp2ConnectionHandler grpcHandler) {
            ChannelHandler securityHandler;
            ChannelHandler gnh = InternalProtocolNegotiators.grpcNegotiationHandler(grpcHandler);
            if (grpcHandler.getEagAttributes().get(GrpclbConstants.ATTR_LB_ADDR_AUTHORITY) != null || grpcHandler.getEagAttributes().get(GrpclbConstants.ATTR_LB_PROVIDED_BACKEND) != null) {
                TsiHandshaker handshaker = this.handshakerFactory.newHandshaker(grpcHandler.getAuthority());
                NettyTsiHandshaker nettyHandshaker = new NettyTsiHandshaker(handshaker);
                securityHandler = new TsiHandshakeHandler(gnh, nettyHandshaker, new AltsHandshakeValidator());
            } else {
                securityHandler = InternalProtocolNegotiators.clientTlsHandler(gnh, this.sslContext, grpcHandler.getAuthority());
            }
            ChannelHandler wuah = InternalProtocolNegotiators.waitUntilActiveHandler(securityHandler);
            return wuah;
        }

        @Override
        public void close() {
            logger.finest("ALTS Server ProtocolNegotiator Closed");
            this.lazyHandshakerChannel.close();
        }
    }

    public static final class GoogleDefaultProtocolNegotiatorFactory
    implements InternalNettyChannelBuilder.ProtocolNegotiatorFactory {
        private final ImmutableList<String> targetServiceAccounts;
        private final LazyChannel lazyHandshakerChannel;
        private final SslContext sslContext;

        public GoogleDefaultProtocolNegotiatorFactory(List<String> targetServiceAccounts, ObjectPool<Channel> handshakerChannelPool, SslContext sslContext) {
            this.targetServiceAccounts = ImmutableList.copyOf(targetServiceAccounts);
            this.lazyHandshakerChannel = new LazyChannel(handshakerChannelPool);
            this.sslContext = Preconditions.checkNotNull(sslContext, "sslContext");
        }

        @Override
        public InternalProtocolNegotiator.ProtocolNegotiator buildProtocolNegotiator() {
            return new GoogleDefaultProtocolNegotiator(new ClientTsiHandshakerFactory(this.targetServiceAccounts, this.lazyHandshakerChannel), this.lazyHandshakerChannel, this.sslContext);
        }
    }

    @VisibleForTesting
    static final class ServerAltsProtocolNegotiator
    implements InternalProtocolNegotiator.ProtocolNegotiator {
        private final TsiHandshakerFactory handshakerFactory;
        private final LazyChannel lazyHandshakerChannel;

        @VisibleForTesting
        ServerAltsProtocolNegotiator(TsiHandshakerFactory handshakerFactory, LazyChannel lazyHandshakerChannel) {
            this.handshakerFactory = Preconditions.checkNotNull(handshakerFactory, "handshakerFactory");
            this.lazyHandshakerChannel = Preconditions.checkNotNull(lazyHandshakerChannel, "lazyHandshakerChannel");
        }

        @Override
        public AsciiString scheme() {
            return SCHEME;
        }

        @Override
        public ChannelHandler newHandler(GrpcHttp2ConnectionHandler grpcHandler) {
            TsiHandshaker handshaker = this.handshakerFactory.newHandshaker(null);
            NettyTsiHandshaker nettyHandshaker = new NettyTsiHandshaker(handshaker);
            ChannelHandler gnh = InternalProtocolNegotiators.grpcNegotiationHandler(grpcHandler);
            TsiHandshakeHandler thh = new TsiHandshakeHandler(gnh, nettyHandshaker, new AltsHandshakeValidator());
            ChannelHandler wuah = InternalProtocolNegotiators.waitUntilActiveHandler(thh);
            return wuah;
        }

        @Override
        public void close() {
            logger.finest("ALTS Server ProtocolNegotiator Closed");
            this.lazyHandshakerChannel.close();
        }
    }

    private static final class ClientAltsProtocolNegotiator
    implements InternalProtocolNegotiator.ProtocolNegotiator {
        private final TsiHandshakerFactory handshakerFactory;
        private final LazyChannel lazyHandshakerChannel;

        ClientAltsProtocolNegotiator(TsiHandshakerFactory handshakerFactory, LazyChannel lazyHandshakerChannel) {
            this.handshakerFactory = Preconditions.checkNotNull(handshakerFactory, "handshakerFactory");
            this.lazyHandshakerChannel = Preconditions.checkNotNull(lazyHandshakerChannel, "lazyHandshakerChannel");
        }

        @Override
        public AsciiString scheme() {
            return SCHEME;
        }

        @Override
        public ChannelHandler newHandler(GrpcHttp2ConnectionHandler grpcHandler) {
            TsiHandshaker handshaker = this.handshakerFactory.newHandshaker(grpcHandler.getAuthority());
            NettyTsiHandshaker nettyHandshaker = new NettyTsiHandshaker(handshaker);
            ChannelHandler gnh = InternalProtocolNegotiators.grpcNegotiationHandler(grpcHandler);
            TsiHandshakeHandler thh = new TsiHandshakeHandler(gnh, nettyHandshaker, new AltsHandshakeValidator());
            ChannelHandler wuah = InternalProtocolNegotiators.waitUntilActiveHandler(thh);
            return wuah;
        }

        @Override
        public void close() {
            this.lazyHandshakerChannel.close();
        }
    }

    public static final class ClientAltsProtocolNegotiatorFactory
    implements InternalNettyChannelBuilder.ProtocolNegotiatorFactory {
        private final ImmutableList<String> targetServiceAccounts;
        private final LazyChannel lazyHandshakerChannel;

        public ClientAltsProtocolNegotiatorFactory(List<String> targetServiceAccounts, ObjectPool<Channel> handshakerChannelPool) {
            this.targetServiceAccounts = ImmutableList.copyOf(targetServiceAccounts);
            this.lazyHandshakerChannel = new LazyChannel(handshakerChannelPool);
        }

        @Override
        public InternalProtocolNegotiator.ProtocolNegotiator buildProtocolNegotiator() {
            return new ClientAltsProtocolNegotiator(new ClientTsiHandshakerFactory(this.targetServiceAccounts, this.lazyHandshakerChannel), this.lazyHandshakerChannel);
        }
    }
}

