/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts;

import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableList;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.CallCredentials;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ClientInterceptor;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ForwardingChannelBuilder;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Status;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.CallCredentialsInterceptor;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.HandshakerServiceChannel;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.internal.AltsProtocolNegotiator;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.auth.MoreCallCredentials;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.GrpcUtil;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.SharedResourcePool;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.grpc.netty.InternalNettyChannelBuilder;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiator;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import java.io.IOException;
import javax.net.ssl.SSLException;

public final class GoogleDefaultChannelBuilder
extends ForwardingChannelBuilder<GoogleDefaultChannelBuilder> {
    private final NettyChannelBuilder delegate;

    private GoogleDefaultChannelBuilder(String target) {
        SslContext sslContext;
        this.delegate = NettyChannelBuilder.forTarget(target);
        try {
            sslContext = GrpcSslContexts.forClient().build();
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
        InternalNettyChannelBuilder.setProtocolNegotiatorFactory(this.delegate(), new AltsProtocolNegotiator.GoogleDefaultProtocolNegotiatorFactory(ImmutableList.of(), SharedResourcePool.forResource(HandshakerServiceChannel.SHARED_HANDSHAKER_CHANNEL), sslContext));
        CallCredentials credentials = null;
        Status status = Status.OK;
        try {
            credentials = MoreCallCredentials.from(GoogleCredentials.getApplicationDefault());
        }
        catch (IOException e) {
            status = Status.UNAUTHENTICATED.withDescription("Failed to get Google default credentials").withCause(e);
        }
        this.delegate().intercept(new ClientInterceptor[]{new CallCredentialsInterceptor(credentials, status)});
    }

    public static final GoogleDefaultChannelBuilder forTarget(String target) {
        return new GoogleDefaultChannelBuilder(target);
    }

    public static GoogleDefaultChannelBuilder forAddress(String name, int port) {
        return GoogleDefaultChannelBuilder.forTarget(GrpcUtil.authorityFromHostAndPort(name, port));
    }

    protected NettyChannelBuilder delegate() {
        return this.delegate;
    }

    @VisibleForTesting
    InternalProtocolNegotiator.ProtocolNegotiator getProtocolNegotiatorForTest() {
        SslContext sslContext;
        try {
            sslContext = GrpcSslContexts.forClient().build();
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
        return new AltsProtocolNegotiator.GoogleDefaultProtocolNegotiatorFactory(ImmutableList.of(), SharedResourcePool.forResource(HandshakerServiceChannel.SHARED_HANDSHAKER_CHANNEL), sslContext).buildProtocolNegotiator();
    }
}

