/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts;

import com.google.cloud.hadoop.repackaged.gcs.io.grpc.CallCredentials;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.CallOptions;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Channel;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ClientCall;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ClientInterceptor;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.MethodDescriptor;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Status;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.FailingClientCall;
import javax.annotation.Nullable;

final class CallCredentialsInterceptor
implements ClientInterceptor {
    @Nullable
    private final CallCredentials credentials;
    private final Status status;

    public CallCredentialsInterceptor(@Nullable CallCredentials credentials, Status status) {
        this.credentials = credentials;
        this.status = status;
    }

    @Override
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        if (!this.status.isOk()) {
            return new FailingClientCall(this.status);
        }
        return next.newCall(method, callOptions.withCallCredentials(this.credentials));
    }
}

