/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.protobuf.util;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Splitter;
import com.google.cloud.hadoop.repackaged.gcs.com.google.protobuf.Descriptors;
import com.google.cloud.hadoop.repackaged.gcs.com.google.protobuf.FieldMask;
import com.google.cloud.hadoop.repackaged.gcs.com.google.protobuf.Message;
import com.google.cloud.hadoop.repackaged.gcs.com.google.protobuf.util.FieldMaskUtil;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Logger;

final class FieldMaskTree {
    private static final Logger logger = Logger.getLogger(FieldMaskTree.class.getName());
    private static final String FIELD_PATH_SEPARATOR_REGEX = "\\.";
    private final Node root = new Node();

    FieldMaskTree() {
    }

    FieldMaskTree(FieldMask mask) {
        this.mergeFromFieldMask(mask);
    }

    public String toString() {
        return FieldMaskUtil.toString(this.toFieldMask());
    }

    @CanIgnoreReturnValue
    FieldMaskTree addFieldPath(String path) {
        String[] parts = path.split(FIELD_PATH_SEPARATOR_REGEX);
        if (parts.length == 0) {
            return this;
        }
        Node node = this.root;
        boolean createNewBranch = false;
        for (String part : parts) {
            if (!createNewBranch && node != this.root && node.children.isEmpty()) {
                return this;
            }
            if (node.children.containsKey(part)) {
                node = (Node)node.children.get(part);
                continue;
            }
            createNewBranch = true;
            Node tmp = new Node();
            node.children.put(part, tmp);
            node = tmp;
        }
        node.children.clear();
        return this;
    }

    @CanIgnoreReturnValue
    FieldMaskTree mergeFromFieldMask(FieldMask mask) {
        for (String path : mask.getPathsList()) {
            this.addFieldPath(path);
        }
        return this;
    }

    @CanIgnoreReturnValue
    FieldMaskTree removeFieldPath(String path) {
        List<String> parts = Splitter.onPattern(FIELD_PATH_SEPARATOR_REGEX).splitToList(path);
        if (parts.isEmpty()) {
            return this;
        }
        Node node = this.root;
        for (int i = 0; i < parts.size(); ++i) {
            String key = parts.get(i);
            if (!node.children.containsKey(key)) {
                return this;
            }
            if (i == parts.size() - 1) {
                node.children.remove(key);
                return this;
            }
            node = (Node)node.children.get(key);
        }
        return this;
    }

    @CanIgnoreReturnValue
    FieldMaskTree removeFromFieldMask(FieldMask mask) {
        for (String path : mask.getPathsList()) {
            this.removeFieldPath(path);
        }
        return this;
    }

    FieldMask toFieldMask() {
        if (this.root.children.isEmpty()) {
            return FieldMask.getDefaultInstance();
        }
        ArrayList<String> paths = new ArrayList<String>();
        this.getFieldPaths(this.root, "", paths);
        return FieldMask.newBuilder().addAllPaths(paths).build();
    }

    private void getFieldPaths(Node node, String path, List<String> paths) {
        if (node.children.isEmpty()) {
            paths.add(path);
            return;
        }
        for (Map.Entry<String, Node> entry : node.children.entrySet()) {
            String string;
            if (path.isEmpty()) {
                string = entry.getKey();
            } else {
                String string2 = entry.getKey();
                string = new StringBuilder(1 + String.valueOf(path).length() + String.valueOf(string2).length()).append(path).append(".").append(string2).toString();
            }
            String childPath = string;
            this.getFieldPaths(entry.getValue(), childPath, paths);
        }
    }

    void intersectFieldPath(String path, FieldMaskTree output) {
        if (this.root.children.isEmpty()) {
            return;
        }
        String[] parts = path.split(FIELD_PATH_SEPARATOR_REGEX);
        if (parts.length == 0) {
            return;
        }
        Node node = this.root;
        for (String part : parts) {
            if (node != this.root && node.children.isEmpty()) {
                output.addFieldPath(path);
                return;
            }
            if (!node.children.containsKey(part)) {
                return;
            }
            node = (Node)node.children.get(part);
        }
        ArrayList<String> paths = new ArrayList<String>();
        this.getFieldPaths(node, path, paths);
        for (String value : paths) {
            output.addFieldPath(value);
        }
    }

    void merge(Message source, Message.Builder destination, FieldMaskUtil.MergeOptions options) {
        if (source.getDescriptorForType() != destination.getDescriptorForType()) {
            throw new IllegalArgumentException("Cannot merge messages of different types.");
        }
        if (this.root.children.isEmpty()) {
            return;
        }
        this.merge(this.root, "", source, destination, options);
    }

    private void merge(Node node, String path, Message source, Message.Builder destination, FieldMaskUtil.MergeOptions options) {
        if (source.getDescriptorForType() != destination.getDescriptorForType()) {
            throw new IllegalArgumentException(String.format("source (%s) and destination (%s) descriptor must be equal", source.getDescriptorForType(), destination.getDescriptorForType()));
        }
        Descriptors.Descriptor descriptor = source.getDescriptorForType();
        for (Map.Entry<String, Node> entry : node.children.entrySet()) {
            String string;
            Object object;
            Descriptors.FieldDescriptor field = descriptor.findFieldByName(entry.getKey());
            if (field == null) {
                object = entry.getKey();
                string = descriptor.getFullName();
                logger.warning(new StringBuilder(37 + String.valueOf(object).length() + String.valueOf(string).length()).append("Cannot find field \"").append((String)object).append("\" in message type ").append(string).toString());
                continue;
            }
            if (!entry.getValue().children.isEmpty()) {
                String string2;
                if (field.isRepeated() || field.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                    object = field.getFullName();
                    logger.warning(new StringBuilder(68 + String.valueOf(object).length()).append("Field \"").append((String)object).append("\" is not a singular message field and cannot have sub-fields.").toString());
                    continue;
                }
                if (!source.hasField(field) && !destination.hasField(field)) continue;
                if (path.isEmpty()) {
                    string2 = entry.getKey();
                } else {
                    string = entry.getKey();
                    string2 = new StringBuilder(1 + String.valueOf(path).length() + String.valueOf(string).length()).append(path).append(".").append(string).toString();
                }
                String childPath = string2;
                Message.Builder childBuilder = ((Message)destination.getField(field)).toBuilder();
                this.merge(entry.getValue(), childPath, (Message)source.getField(field), childBuilder, options);
                destination.setField(field, childBuilder.buildPartial());
                continue;
            }
            if (field.isRepeated()) {
                if (options.replaceRepeatedFields()) {
                    destination.setField(field, source.getField(field));
                    continue;
                }
                for (Object element : (List)source.getField(field)) {
                    destination.addRepeatedField(field, element);
                }
                continue;
            }
            if (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                if (options.replaceMessageFields()) {
                    if (!source.hasField(field)) {
                        destination.clearField(field);
                        continue;
                    }
                    destination.setField(field, source.getField(field));
                    continue;
                }
                if (!source.hasField(field)) continue;
                destination.setField(field, ((Message)destination.getField(field)).toBuilder().mergeFrom((Message)source.getField(field)).build());
                continue;
            }
            if (source.hasField(field) || !options.replacePrimitiveFields()) {
                destination.setField(field, source.getField(field));
                continue;
            }
            destination.clearField(field);
        }
    }

    private static final class Node {
        final SortedMap<String, Node> children = new TreeMap<String, Node>();

        private Node() {
        }
    }
}

