/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.util.BackOff;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.util.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.util.Sleeper;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.RetryDeterminer;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.GoogleLogger;
import java.io.IOException;
import java.util.concurrent.Callable;

public class ResilientOperation {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();

    public static <T, X extends Exception> T retry(CheckedCallable<T, X> callable, BackOff backoff, RetryDeterminer<? super X> retryDet, Class<X> classType, Sleeper sleeper) throws X, InterruptedException {
        Preconditions.checkNotNull(backoff, "Must provide a non-null BackOff.");
        Preconditions.checkNotNull(retryDet, "Must provide a non-null RetryDeterminer.");
        Preconditions.checkNotNull(sleeper, "Must provide a non-null Sleeper.");
        Preconditions.checkNotNull(callable, "Must provide a non-null Executable object.");
        while (true) {
            try {
                return callable.call();
            }
            catch (Exception e) {
                Exception currentException;
                if (classType.isInstance(e)) {
                    currentException = e;
                    if (retryDet.shouldRetry(currentException)) continue;
                    throw currentException;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException("Retrying with unchecked exceptions that are not RuntimeExceptions is not supported.", e);
                if (ResilientOperation.nextSleep(backoff, sleeper, currentException)) continue;
                throw currentException;
            }
            break;
        }
    }

    public static <T, X extends Exception> T retry(CheckedCallable<T, X> callable, BackOff backoff, RetryDeterminer<? super X> retryDet, Class<X> classType) throws X, InterruptedException {
        return ResilientOperation.retry(callable, backoff, retryDet, classType, Sleeper.DEFAULT);
    }

    private static boolean nextSleep(BackOff backoff, Sleeper sleeper, Exception currentException) throws InterruptedException {
        long backOffTime;
        try {
            backOffTime = backoff.nextBackOffMillis();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to to get next back off time", e);
        }
        if (backOffTime == -1L) {
            return false;
        }
        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atInfo()).withCause(currentException)).log("Transient exception caught. Sleeping for %d, then retrying.", backOffTime);
        sleeper.sleep(backOffTime);
        return true;
    }

    public static <V> CheckedCallable<V, IOException> getGoogleRequestCallable(AbstractGoogleClientRequest<V> request) {
        return new AbstractGoogleClientRequestExecutor(request);
    }

    private static class AbstractGoogleClientRequestExecutor<T>
    implements CheckedCallable<T, IOException> {
        private final AbstractGoogleClientRequest<T> request;

        private AbstractGoogleClientRequestExecutor(AbstractGoogleClientRequest<T> request) {
            this.request = request;
        }

        @Override
        public T call() throws IOException {
            return this.request.execute();
        }
    }

    public static interface CheckedCallable<T, X extends Exception>
    extends Callable<T> {
        @Override
        public T call() throws X;
    }
}

