/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.InputStreamContent;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.BaseAbstractGoogleAsyncWriteChannel;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.ClientRequestHelper;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.GoogleLogger;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;

public abstract class AbstractGoogleAsyncWriteChannel<T extends AbstractGoogleClientRequest<S>, S>
extends BaseAbstractGoogleAsyncWriteChannel<S> {
    private ClientRequestHelper<S> clientRequestHelper = new ClientRequestHelper();

    public AbstractGoogleAsyncWriteChannel(ExecutorService threadPool, AsyncWriteChannelOptions options) {
        super(threadPool, options);
    }

    @VisibleForTesting
    public void setClientRequestHelper(ClientRequestHelper<S> helper) {
        this.clientRequestHelper = helper;
    }

    public abstract T createRequest(InputStreamContent var1) throws IOException;

    @Override
    public void setUploadChunkSize(int chunkSize) {
        Preconditions.checkArgument(chunkSize > 0, "Upload chunk size must be great than 0.");
        Preconditions.checkArgument(chunkSize % 262144 == 0, "Upload chunk size must be a multiple of MediaHttpUploader.MINIMUM_CHUNK_SIZE");
        if (chunkSize > 0x800000 && chunkSize % 0x800000 != 0) {
            ((GoogleLogger.Api)logger.atWarning()).log("Upload chunk size should be a multiple of %s for best performance, got %s", 0x800000, chunkSize);
        }
        this.uploadChunkSize = chunkSize;
    }

    @Override
    public void startUpload(InputStream pipeSource) throws IOException {
        InputStreamContent objectContentStream = new InputStreamContent(this.contentType, pipeSource);
        objectContentStream.setLength(-1L);
        objectContentStream.setCloseInputStream(false);
        T request = this.createRequest(objectContentStream);
        ((AbstractGoogleClientRequest)request).setDisableGZipContent(true);
        this.clientRequestHelper.setChunkSize((AbstractGoogleClientRequest<S>)request, this.uploadChunkSize);
        this.uploadOperation = this.threadPool.submit(new UploadOperation(this, request, pipeSource));
    }

    static class UploadOperation
    implements Callable<S> {
        private final T uploadObject;
        private final InputStream pipeSource;
        final /* synthetic */ AbstractGoogleAsyncWriteChannel this$0;

        public UploadOperation(T uploadObject, InputStream pipeSource) {
            this.this$0 = this$0;
            this.uploadObject = uploadObject;
            this.pipeSource = pipeSource;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public S call() throws Exception {
            try (InputStream ignore = this.pipeSource;){
                Object throwable3 = ((AbstractGoogleClientRequest)this.uploadObject).execute();
                return throwable3;
            }
            catch (IOException ioe) {
                Object response = this.this$0.createResponseFromException(ioe);
                if (response == null) throw ioe;
                ((GoogleLogger.Api)((GoogleLogger.Api)BaseAbstractGoogleAsyncWriteChannel.logger.atWarning()).withCause(ioe)).log("Received IOException, but successfully converted to response '%s'.", response);
                return response;
            }
        }
    }
}

