/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery.samples;

import com.google.cloud.hadoop.io.bigquery.BigQueryConfiguration;
import com.google.cloud.hadoop.io.bigquery.DirectBigQueryInputFormat;
import java.io.IOException;
import java.util.stream.StreamSupport;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.Utf8;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.GenericOptionsParser;

public class DirectBigQueryWordCount {
    public static void main(String[] args) throws IOException, InterruptedException, ClassNotFoundException {
        GenericOptionsParser parser = new GenericOptionsParser(args);
        if ((args = parser.getRemainingArgs()).length != 3) {
            System.out.println("Usage: hadoop jar bigquery_wordcount.jar [ProjectId] [QualifiedInputTableId] [GcsOutputPath]\n    ProjectId - Project under which to issue the BigQuery operations. Also serves as the default project for table IDs which don't explicitly specify a project for the table.\n    QualifiedInputTableId - Input table ID of the form (Optional ProjectId):[DatasetId].[TableId]\n    OutputPath - The output path to write data, e.g. gs://bucket/dir/");
            System.exit(1);
        }
        String projectId = args[0];
        String inputQualifiedTableId = args[1];
        String outputPath = args[2];
        Job job = new Job(parser.getConfiguration(), "wordcount");
        Configuration conf = job.getConfiguration();
        conf.set(BigQueryConfiguration.PROJECT_ID.getKey(), projectId);
        BigQueryConfiguration.configureBigQueryInput(conf, inputQualifiedTableId);
        conf.set(BigQueryConfiguration.SELECTED_FIELDS.getKey(), "word,word_count");
        conf.set(BigQueryConfiguration.SQL_FILTER.getKey(), "word >= 'A' AND word <= 'zzz'");
        conf.set("mapreduce.job.maps", "999");
        job.setJarByClass(DirectBigQueryWordCount.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(LongWritable.class);
        job.setMapperClass(Map.class);
        job.setReducerClass(Reduce.class);
        job.setInputFormatClass(DirectBigQueryInputFormat.class);
        job.setOutputFormatClass(TextOutputFormat.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(outputPath));
        job.waitForCompletion(true);
    }

    public static class Reduce
    extends Reducer<Text, LongWritable, Text, LongWritable> {
        private final LongWritable count = new LongWritable();

        public void reduce(Text word, Iterable<LongWritable> counts, Reducer.Context context) throws IOException, InterruptedException {
            this.count.set(StreamSupport.stream(counts.spliterator(), false).mapToLong(LongWritable::get).sum());
            context.write((Object)word, (Object)this.count);
        }
    }

    public static class Map
    extends Mapper<NullWritable, GenericRecord, Text, LongWritable> {
        private final Text word = new Text();
        private final LongWritable count = new LongWritable();

        public void setup(Mapper.Context context) {
        }

        public void map(NullWritable unusedKey, GenericRecord row, Mapper.Context context) throws IOException, InterruptedException {
            this.word.set(((Utf8)row.get("word")).toString());
            this.count.set(((Long)row.get("word_count")).longValue());
            context.write((Object)this.word, (Object)this.count);
        }
    }
}

