/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery.output;

import com.google.api.client.json.JsonParser;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableSchema;
import java.io.IOException;
import java.util.ArrayList;

class BigQueryTableHelper {
    BigQueryTableHelper() {
    }

    static TableSchema parseTableSchema(String tableSchemaJson) throws IOException {
        JsonParser parser = JacksonFactory.getDefaultInstance().createJsonParser(tableSchemaJson);
        return (TableSchema)parser.parseAndClose(TableSchema.class);
    }

    static TableSchema createTableSchemaFromFields(String fieldsJson) throws IOException {
        ArrayList fields = new ArrayList();
        JsonParser parser = JacksonFactory.getDefaultInstance().createJsonParser(fieldsJson);
        parser.parseArrayAndClose(fields, TableFieldSchema.class);
        return new TableSchema().setFields(fields);
    }

    static String getTableSchemaJson(TableSchema tableSchema) throws IOException {
        return JacksonFactory.getDefaultInstance().toString((Object)tableSchema);
    }

    static String getTableFieldsJson(TableSchema tableSchema) throws IOException {
        return JacksonFactory.getDefaultInstance().toString((Object)tableSchema.getFields());
    }
}

