/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery.output;

import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.api.services.bigquery.model.TimePartitioning;
import com.google.cloud.hadoop.io.bigquery.BigQueryConfiguration;
import com.google.cloud.hadoop.io.bigquery.BigQueryFileFormat;
import com.google.cloud.hadoop.io.bigquery.BigQueryStrings;
import com.google.cloud.hadoop.io.bigquery.HadoopConfigurationProperty;
import com.google.cloud.hadoop.io.bigquery.output.BigQueryTableHelper;
import com.google.cloud.hadoop.io.bigquery.output.BigQueryTableSchema;
import com.google.cloud.hadoop.io.bigquery.output.BigQueryTimePartitioning;
import com.google.cloud.hadoop.util.ConfigurationUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceStability.Unstable
public class BigQueryOutputConfiguration {
    public static final List<HadoopConfigurationProperty<?>> REQUIRED_PROPERTIES = ImmutableList.of(BigQueryConfiguration.OUTPUT_DATASET_ID, BigQueryConfiguration.OUTPUT_TABLE_ID, BigQueryConfiguration.OUTPUT_FILE_FORMAT, BigQueryConfiguration.OUTPUT_FORMAT_CLASS);

    public static void configure(Configuration conf, String qualifiedOutputTableId, String outputTableSchemaJson, String outputGcsPath, BigQueryFileFormat outputFileFormat, Class<? extends FileOutputFormat> outputFormatClass) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)outputTableSchemaJson) ? 1 : 0) != 0, (Object)"outputTableSchemaJson must not be null or empty.");
        TableReference outputTable = BigQueryStrings.parseTableReference(qualifiedOutputTableId);
        BigQueryOutputConfiguration.configure(conf, outputTable.getProjectId(), outputTable.getDatasetId(), outputTable.getTableId(), Optional.of(outputTableSchemaJson), outputGcsPath, outputFileFormat, outputFormatClass);
    }

    private static void configure(Configuration conf, String outputProjectId, String outputDatasetId, String outputTableId, Optional<String> outputTableSchemaJson, String outputGcsPath, BigQueryFileFormat outputFileFormat, Class<? extends FileOutputFormat> outputFormatClass) throws IOException {
        if (Strings.isNullOrEmpty((String)outputProjectId)) {
            outputProjectId = (String)BigQueryConfiguration.PROJECT_ID.get(conf, (arg_0, arg_1) -> ((Configuration)conf).get(arg_0, arg_1));
        }
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)outputProjectId) ? 1 : 0) != 0, (Object)"outputProjectId must not be null or empty.");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)outputDatasetId) ? 1 : 0) != 0, (Object)"outputDatasetId must not be null or empty.");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)outputTableId) ? 1 : 0) != 0, (Object)"outputTableId must not be null or empty.");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)outputGcsPath) ? 1 : 0) != 0, (Object)"outputGcsPath must not be null or empty.");
        Preconditions.checkNotNull((Object)((Object)outputFileFormat), (Object)"outputFileFormat must not be null.");
        Preconditions.checkNotNull(outputFormatClass, (Object)"outputFormatClass must not be null.");
        conf.set(BigQueryConfiguration.OUTPUT_PROJECT_ID.getKey(), outputProjectId);
        conf.set(BigQueryConfiguration.OUTPUT_DATASET_ID.getKey(), outputDatasetId);
        conf.set(BigQueryConfiguration.OUTPUT_TABLE_ID.getKey(), outputTableId);
        conf.set(BigQueryConfiguration.OUTPUT_FILE_FORMAT.getKey(), outputFileFormat.name());
        conf.setClass(BigQueryConfiguration.OUTPUT_FORMAT_CLASS.getKey(), outputFormatClass, FileOutputFormat.class);
        BigQueryOutputConfiguration.setFileOutputFormatOutputPath(conf, outputGcsPath);
        if (outputTableSchemaJson.isPresent()) {
            TableSchema tableSchema = BigQueryTableHelper.parseTableSchema(outputTableSchemaJson.get());
            String fieldsJson = BigQueryTableHelper.getTableFieldsJson(tableSchema);
            conf.set(BigQueryConfiguration.OUTPUT_TABLE_SCHEMA.getKey(), fieldsJson);
        }
    }

    public static void configure(Configuration conf, String qualifiedOutputTableId, BigQueryTableSchema outputTableSchema, String outputGcsPath, BigQueryFileFormat outputFileFormat, Class<? extends FileOutputFormat> outputFormatClass) throws IOException {
        BigQueryOutputConfiguration.configure(conf, qualifiedOutputTableId, BigQueryTableHelper.getTableSchemaJson(outputTableSchema.get()), outputGcsPath, outputFileFormat, outputFormatClass);
    }

    public static void configureWithAutoSchema(Configuration conf, String qualifiedOutputTableId, String outputGcsPath, BigQueryFileFormat outputFileFormat, Class<? extends FileOutputFormat> outputFormatClass) throws IOException {
        TableReference outputTable = BigQueryStrings.parseTableReference(qualifiedOutputTableId);
        BigQueryOutputConfiguration.configure(conf, outputTable.getProjectId(), outputTable.getDatasetId(), outputTable.getTableId(), Optional.empty(), outputGcsPath, outputFileFormat, outputFormatClass);
    }

    public static void setKmsKeyName(Configuration conf, String kmsKeyName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)kmsKeyName) ? 1 : 0) != 0, (Object)"kmsKeyName must not be null or empty.");
        conf.set(BigQueryConfiguration.OUTPUT_TABLE_KMS_KEY_NAME.getKey(), kmsKeyName);
    }

    public static void validateConfiguration(Configuration conf) throws IOException {
        ConfigurationUtil.getMandatoryConfig((Configuration)conf, REQUIRED_PROPERTIES);
        BigQueryOutputConfiguration.getProjectId(conf);
        BigQueryOutputConfiguration.getJobProjectId(conf);
        BigQueryOutputConfiguration.getTableSchema(conf);
        BigQueryOutputConfiguration.getFileFormat(conf);
        BigQueryOutputConfiguration.getFileOutputFormat(conf);
        BigQueryOutputConfiguration.getGcsOutputPath(conf);
    }

    public static boolean getCleanupTemporaryDataFlag(Configuration conf) {
        return (Boolean)BigQueryConfiguration.OUTPUT_CLEANUP_TEMP.get(conf, (arg_0, arg_1) -> ((Configuration)conf).getBoolean(arg_0, arg_1));
    }

    public static String getProjectId(Configuration conf) throws IOException {
        String projectId = (String)BigQueryConfiguration.OUTPUT_PROJECT_ID.get(conf, (arg_0, arg_1) -> ((Configuration)conf).get(arg_0, arg_1));
        if (Strings.isNullOrEmpty((String)projectId)) {
            projectId = (String)BigQueryConfiguration.PROJECT_ID.get(conf, (arg_0, arg_1) -> ((Configuration)conf).get(arg_0, arg_1));
        }
        if (Strings.isNullOrEmpty((String)projectId)) {
            throw new IOException("Must supply a value for configuration setting: " + BigQueryConfiguration.OUTPUT_PROJECT_ID.getKey());
        }
        return projectId;
    }

    public static String getJobProjectId(Configuration conf) throws IOException {
        String projectId = (String)BigQueryConfiguration.PROJECT_ID.get(conf, (arg_0, arg_1) -> ((Configuration)conf).get(arg_0, arg_1));
        if (Strings.isNullOrEmpty((String)projectId)) {
            projectId = (String)BigQueryConfiguration.OUTPUT_PROJECT_ID.get(conf, (arg_0, arg_1) -> ((Configuration)conf).get(arg_0, arg_1));
        }
        if (Strings.isNullOrEmpty((String)projectId)) {
            throw new IOException("Must supply a value for configuration setting: " + BigQueryConfiguration.PROJECT_ID.getKey());
        }
        return projectId;
    }

    static TableReference getTableReference(Configuration conf) throws IOException {
        String projectId = BigQueryOutputConfiguration.getProjectId(conf);
        String datasetId = ConfigurationUtil.getMandatoryConfig((Configuration)conf, BigQueryConfiguration.OUTPUT_DATASET_ID);
        String tableId = ConfigurationUtil.getMandatoryConfig((Configuration)conf, BigQueryConfiguration.OUTPUT_TABLE_ID);
        return new TableReference().setProjectId(projectId).setDatasetId(datasetId).setTableId(tableId);
    }

    static Optional<BigQueryTableSchema> getTableSchema(Configuration conf) throws IOException {
        String fieldsJson = (String)BigQueryConfiguration.OUTPUT_TABLE_SCHEMA.get(conf, (arg_0, arg_1) -> ((Configuration)conf).get(arg_0, arg_1));
        if (!Strings.isNullOrEmpty((String)fieldsJson)) {
            try {
                TableSchema tableSchema = BigQueryTableHelper.createTableSchemaFromFields(fieldsJson);
                return Optional.of(BigQueryTableSchema.wrap(tableSchema));
            }
            catch (IOException e) {
                throw new IOException("Unable to parse key '" + BigQueryConfiguration.OUTPUT_TABLE_SCHEMA.getKey() + "'.", e);
            }
        }
        return Optional.empty();
    }

    static Optional<BigQueryTimePartitioning> getTablePartitioning(Configuration conf) throws IOException {
        String fieldsJson = (String)BigQueryConfiguration.OUTPUT_TABLE_PARTITIONING.get(conf, (arg_0, arg_1) -> ((Configuration)conf).get(arg_0, arg_1));
        if (!Strings.isNullOrEmpty((String)fieldsJson)) {
            try {
                TimePartitioning tablePartitioning = BigQueryTimePartitioning.getFromJson(fieldsJson);
                return Optional.of(BigQueryTimePartitioning.wrap(tablePartitioning));
            }
            catch (IOException e) {
                throw new IOException("Unable to parse key '" + BigQueryConfiguration.OUTPUT_TABLE_PARTITIONING.getKey() + "'.", e);
            }
        }
        return Optional.empty();
    }

    public static String getKmsKeyName(Configuration conf) throws IOException {
        return (String)BigQueryConfiguration.OUTPUT_TABLE_KMS_KEY_NAME.get(conf, (arg_0, arg_1) -> ((Configuration)conf).get(arg_0, arg_1));
    }

    public static BigQueryFileFormat getFileFormat(Configuration conf) throws IOException {
        String fileFormatName = ConfigurationUtil.getMandatoryConfig((Configuration)conf, BigQueryConfiguration.OUTPUT_FILE_FORMAT);
        return BigQueryFileFormat.fromName(fileFormatName);
    }

    public static FileOutputFormat getFileOutputFormat(Configuration conf) throws IOException {
        ConfigurationUtil.getMandatoryConfig((Configuration)conf, BigQueryConfiguration.OUTPUT_FORMAT_CLASS);
        Class confClass = (Class)BigQueryConfiguration.OUTPUT_FORMAT_CLASS.get(conf, (arg_0, arg_1) -> ((Configuration)conf).getClass(arg_0, arg_1));
        if (confClass == null) {
            throw new IOException("Unable to resolve value for the configuration key '" + BigQueryConfiguration.OUTPUT_FORMAT_CLASS.getKey() + "'.");
        }
        if (!FileOutputFormat.class.isAssignableFrom(confClass)) {
            throw new IOException("The class " + confClass.getName() + " is not a FileOutputFormat.");
        }
        Class<FileOutputFormat> fileOutputClass = confClass.asSubclass(FileOutputFormat.class);
        return (FileOutputFormat)ReflectionUtils.newInstance(fileOutputClass, (Configuration)conf);
    }

    public static Path getGcsOutputPath(Configuration conf) throws IOException {
        JobConfigurationAdapter tempJob = new JobConfigurationAdapter(conf);
        Path outputPath = FileOutputFormat.getOutputPath((JobContext)tempJob);
        if (outputPath == null) {
            throw new IOException("FileOutputFormat output path not set.");
        }
        FileSystem fs = outputPath.getFileSystem(conf);
        if (!"gs".equals(fs.getScheme())) {
            throw new IOException("Output FileSystem must be GCS ('gs' scheme).");
        }
        return outputPath;
    }

    public static String getCreateDisposition(Configuration conf) {
        return (String)BigQueryConfiguration.OUTPUT_TABLE_CREATE_DISPOSITION.get(conf, (arg_0, arg_1) -> ((Configuration)conf).get(arg_0, arg_1));
    }

    public static String getWriteDisposition(Configuration conf) {
        return (String)BigQueryConfiguration.OUTPUT_TABLE_WRITE_DISPOSITION.get(conf, (arg_0, arg_1) -> ((Configuration)conf).get(arg_0, arg_1));
    }

    @VisibleForTesting
    static void setFileOutputFormatOutputPath(Configuration conf, String outputPath) throws IOException {
        JobConfigurationAdapter tempJob = new JobConfigurationAdapter(conf);
        FileOutputFormat.setOutputPath((Job)tempJob, (Path)new Path(outputPath));
    }

    private static class JobConfigurationAdapter
    extends Job {
        private final Configuration config;

        public JobConfigurationAdapter(Configuration config) throws IOException {
            this.config = config;
        }

        public Configuration getConfiguration() {
            return this.config;
        }
    }
}

