/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery.output;

import com.google.cloud.hadoop.io.bigquery.BigQueryFactory;
import com.google.cloud.hadoop.io.bigquery.output.BigQueryOutputConfiguration;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.security.GeneralSecurityException;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileAlreadyExistsException;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Unstable
public class ForwardingBigQueryFileOutputFormat<K, V>
extends OutputFormat<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(ForwardingBigQueryFileOutputFormat.class);
    private FileOutputFormat<K, V> delegate = null;
    private OutputCommitter committer = null;

    public void checkOutputSpecs(JobContext job) throws FileAlreadyExistsException, IOException {
        Configuration conf = job.getConfiguration();
        BigQueryOutputConfiguration.validateConfiguration(conf);
        Path outputPath = BigQueryOutputConfiguration.getGcsOutputPath(conf);
        LOG.info("Using output path '{}'.", (Object)outputPath);
        FileSystem outputFileSystem = outputPath.getFileSystem(conf);
        if (outputFileSystem.exists(outputPath)) {
            throw new IOException("The output path '" + outputPath + "' already exists.");
        }
        if (FileOutputFormat.getCompressOutput((JobContext)job)) {
            throw new IOException("Compression isn't supported for this OutputFormat.");
        }
        try {
            new BigQueryFactory().getBigQueryHelper(conf);
        }
        catch (GeneralSecurityException gse) {
            throw new IOException("Failed to create BigQuery client", gse);
        }
        this.getDelegate(conf).checkOutputSpecs(job);
    }

    public synchronized OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException {
        if (this.committer == null) {
            this.committer = this.createCommitter(context);
        }
        return this.committer;
    }

    public RecordWriter<K, V> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        return this.getDelegate(conf).getRecordWriter(context);
    }

    protected OutputCommitter createCommitter(TaskAttemptContext context) throws IOException {
        Configuration conf = context.getConfiguration();
        return this.getDelegate(conf).getOutputCommitter(context);
    }

    protected synchronized FileOutputFormat<K, V> getDelegate(Configuration conf) throws IOException {
        if (this.delegate == null) {
            this.delegate = BigQueryOutputConfiguration.getFileOutputFormat(conf);
            LOG.info("Delegating functionality to '{}'.", (Object)this.delegate.getClass().getSimpleName());
        }
        return this.delegate;
    }

    @VisibleForTesting
    void setDelegate(FileOutputFormat<K, V> delegate) {
        this.delegate = delegate;
    }
}

