/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery.output;

import com.google.api.client.json.JsonParser;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemBase;
import com.google.cloud.hadoop.io.bigquery.BigQueryFileFormat;
import com.google.cloud.hadoop.io.bigquery.BigQueryStrings;
import com.google.cloud.hadoop.util.ConfigurationUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceStability.Unstable
public class BigQueryOutputConfiguration {
    public static final List<String> REQUIRED_KEYS = ImmutableList.of((Object)"mapred.bq.output.dataset.id", (Object)"mapred.bq.output.table.id", (Object)"mapred.bq.output.gcs.fileformat", (Object)"mapred.bq.output.gcs.outputformatclass");

    public static void configure(Configuration conf, String qualifiedOutputTableId, TableSchema outputTableSchema, String outputGcsPath, BigQueryFileFormat outputFileFormat, Class<? extends FileOutputFormat> outputFormatClass) throws IOException {
        TableReference outputTable = BigQueryStrings.parseTableReference(qualifiedOutputTableId);
        BigQueryOutputConfiguration.configure(conf, outputTable.getProjectId(), outputTable.getDatasetId(), outputTable.getTableId(), outputTableSchema, outputGcsPath, outputFileFormat, outputFormatClass);
    }

    public static void configure(Configuration conf, String outputProjectId, String outputDatasetId, String outputTableId, TableSchema outputTableSchema, String outputGcsPath, BigQueryFileFormat outputFileFormat, Class<? extends FileOutputFormat> outputFormatClass) throws IOException {
        if (Strings.isNullOrEmpty((String)outputProjectId)) {
            outputProjectId = conf.get("mapred.bq.project.id");
        }
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)outputProjectId) ? 1 : 0) != 0, (Object)"outputProjectId must not be null or empty.");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)outputDatasetId) ? 1 : 0) != 0, (Object)"outputDatasetId must not be null or empty.");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)outputTableId) ? 1 : 0) != 0, (Object)"outputTableId must not be null or empty.");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)outputGcsPath) ? 1 : 0) != 0, (Object)"outputGcsPath must not be null or empty.");
        Preconditions.checkNotNull((Object)((Object)outputFileFormat), (Object)"outputFileFormat must not be null.");
        Preconditions.checkNotNull(outputFormatClass, (Object)"outputFormatClass must not be null.");
        conf.set("mapred.bq.output.project.id", outputProjectId);
        conf.set("mapred.bq.output.dataset.id", outputDatasetId);
        conf.set("mapred.bq.output.table.id", outputTableId);
        conf.set("mapred.bq.output.gcs.fileformat", outputFileFormat.name());
        conf.setClass("mapred.bq.output.gcs.outputformatclass", outputFormatClass, FileOutputFormat.class);
        BigQueryOutputConfiguration.setFileOutputFormatOutputPath(conf, outputGcsPath);
        if (outputTableSchema != null) {
            String fields = JacksonFactory.getDefaultInstance().toString((Object)outputTableSchema.getFields());
            conf.set("mapred.bq.output.table.schema", fields);
        }
    }

    public static void validateConfiguration(Configuration conf) throws IOException {
        ConfigurationUtil.getMandatoryConfig((Configuration)conf, REQUIRED_KEYS);
        BigQueryOutputConfiguration.getProjectId(conf);
        BigQueryOutputConfiguration.getTableSchema(conf);
        BigQueryOutputConfiguration.getFileFormat(conf);
        BigQueryOutputConfiguration.getFileOutputFormat(conf);
        BigQueryOutputConfiguration.getGcsOutputPath(conf);
    }

    public static boolean getCleanupTemporaryDataFlag(Configuration conf) {
        return conf.getBoolean("mapred.bq.output.gcs.cleanup", true);
    }

    public static String getProjectId(Configuration conf) throws IOException {
        String projectId = conf.get("mapred.bq.output.project.id");
        if (Strings.isNullOrEmpty((String)projectId)) {
            projectId = conf.get("mapred.bq.project.id");
        }
        if (Strings.isNullOrEmpty((String)projectId)) {
            throw new IOException("Must supply a value for configuration setting: mapred.bq.output.project.id");
        }
        return projectId;
    }

    public static TableReference getTableReference(Configuration conf) throws IOException {
        String projectId = BigQueryOutputConfiguration.getProjectId(conf);
        String datasetId = ConfigurationUtil.getMandatoryConfig((Configuration)conf, (String)"mapred.bq.output.dataset.id");
        String tableId = ConfigurationUtil.getMandatoryConfig((Configuration)conf, (String)"mapred.bq.output.table.id");
        return new TableReference().setProjectId(projectId).setDatasetId(datasetId).setTableId(tableId);
    }

    public static TableSchema getTableSchema(Configuration conf) throws IOException {
        String outputSchema = conf.get("mapred.bq.output.table.schema");
        if (!Strings.isNullOrEmpty((String)outputSchema)) {
            try {
                ArrayList fields = new ArrayList();
                JsonParser parser = JacksonFactory.getDefaultInstance().createJsonParser(outputSchema);
                parser.parseArrayAndClose(fields, TableFieldSchema.class);
                return new TableSchema().setFields(fields);
            }
            catch (IOException e) {
                throw new IOException("Unable to parse key 'mapred.bq.output.table.schema'.", e);
            }
        }
        return null;
    }

    public static BigQueryFileFormat getFileFormat(Configuration conf) throws IOException {
        String fileFormatName = ConfigurationUtil.getMandatoryConfig((Configuration)conf, (String)"mapred.bq.output.gcs.fileformat");
        return BigQueryFileFormat.fromName(fileFormatName);
    }

    public static FileOutputFormat getFileOutputFormat(Configuration conf) throws IOException {
        ConfigurationUtil.getMandatoryConfig((Configuration)conf, (String)"mapred.bq.output.gcs.outputformatclass");
        Class confClass = conf.getClass("mapred.bq.output.gcs.outputformatclass", null);
        if (confClass == null) {
            throw new IOException("Unable to resolve value for the configuration key 'mapred.bq.output.gcs.outputformatclass'.");
        }
        if (!FileOutputFormat.class.isAssignableFrom(confClass)) {
            throw new IOException("The class " + confClass.getName() + " is not a FileOutputFormat.");
        }
        Class<FileOutputFormat> fileOutputClass = confClass.asSubclass(FileOutputFormat.class);
        return (FileOutputFormat)ReflectionUtils.newInstance(fileOutputClass, (Configuration)conf);
    }

    public static Path getGcsOutputPath(Configuration conf) throws IOException {
        JobConfigurationAdapter tempJob = new JobConfigurationAdapter(conf);
        Path outputPath = FileOutputFormat.getOutputPath((JobContext)tempJob);
        if (outputPath == null) {
            throw new IOException("FileOutputFormat output path not set.");
        }
        FileSystem fs = outputPath.getFileSystem(conf);
        if (!(fs instanceof GoogleHadoopFileSystemBase)) {
            throw new IOException("Output FileSystem must derive from GoogleHadoopFileSystemBase.");
        }
        return outputPath;
    }

    public static String getWriteDisposition(Configuration conf) {
        return conf.get("mapred.bq.output.table.writedisposition", "WRITE_APPEND");
    }

    @VisibleForTesting
    static void setFileOutputFormatOutputPath(Configuration conf, String outputPath) throws IOException {
        JobConfigurationAdapter tempJob = new JobConfigurationAdapter(conf);
        FileOutputFormat.setOutputPath((Job)tempJob, (Path)new Path(outputPath));
    }

    private static class JobConfigurationAdapter
    extends Job {
        private final Configuration config;

        public JobConfigurationAdapter(Configuration config) throws IOException {
            this.config = config;
        }

        public Configuration getConfiguration() {
            return this.config;
        }
    }
}

