/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery;

import com.google.api.services.bigquery.model.Table;
import com.google.cloud.hadoop.io.bigquery.AbstractExportToCloudStorage;
import com.google.cloud.hadoop.io.bigquery.BigQueryHelper;
import com.google.cloud.hadoop.io.bigquery.BigQueryStrings;
import com.google.cloud.hadoop.io.bigquery.ExportFileFormat;
import com.google.cloud.hadoop.io.bigquery.ShardedInputSplit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardedExportToCloudStorage
extends AbstractExportToCloudStorage {
    private static final Logger LOG = LoggerFactory.getLogger(ShardedExportToCloudStorage.class);
    public static final String NUM_MAP_TASKS_HINT_KEY = "mapred.map.tasks";
    public static final int NUM_MAP_TASKS_HINT_DEFAULT = 2;
    public static final String MAX_EXPORT_SHARDS_KEY = "mapred.bq.input.sharded.export.shards.max";
    public static final int MAX_EXPORT_SHARDS_DEFAULT = 500;
    public static final long APPROXIMATE_EXPORT_FILE_SIZE = 0x10000000L;
    public static final int APPROXIMATE_MAX_EXPORT_FILES = 10000;
    public static final int MIN_SHARDS_FOR_SHARDED_EXPORT = 2;

    public ShardedExportToCloudStorage(Configuration configuration, String gcsPath, ExportFileFormat fileFormat, BigQueryHelper bigQueryHelper, String projectId, Table tableToExport) throws IOException {
        super(configuration, gcsPath, fileFormat, bigQueryHelper, projectId, tableToExport);
    }

    @Override
    public void waitForUsableMapReduceInput() throws IOException, InterruptedException {
        LOG.debug("Using sharded input. waitForUsableMapReduceInput is a no-op.");
    }

    @Override
    public List<InputSplit> getSplits(JobContext context) throws IOException {
        long numTableRows = this.tableToExport.getNumRows().longValue();
        List<String> paths = this.getExportPaths();
        int pathCount = paths.size();
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        for (String exportPattern : paths) {
            splits.add(new ShardedInputSplit(new Path(exportPattern), Math.max(1L, numTableRows / (long)pathCount)));
        }
        return splits;
    }

    @Override
    public List<String> getExportPaths() throws IOException {
        ArrayList<String> paths = new ArrayList<String>();
        long numTableRows = this.tableToExport.getNumRows().longValue();
        long numTableBytes = this.tableToExport.getNumBytes();
        int numShards = this.computeNumShards(numTableBytes);
        LOG.info("Computed '{}' shards for sharded BigQuery export.", (Object)numShards);
        for (int i = 0; i < numShards; ++i) {
            String exportPattern = String.format("%s/shard-%d/%s", this.gcsPath, i, this.fileFormat.getFilePattern());
            paths.add(exportPattern);
        }
        LOG.info("Table '{}' to be exported has {} rows and {} bytes", new Object[]{BigQueryStrings.toString(this.tableToExport.getTableReference()), numTableRows, numTableBytes});
        return paths;
    }

    private int computeNumShards(long numTableBytes) {
        int desiredNumMaps = this.configuration.getInt(NUM_MAP_TASKS_HINT_KEY, 2);
        LOG.debug("Fetched desiredNumMaps from '{}': {}", (Object)NUM_MAP_TASKS_HINT_KEY, (Object)desiredNumMaps);
        int estimatedNumFiles = (int)Math.min(Math.max(2L, numTableBytes / 0x10000000L), 10000L);
        LOG.debug("estimatedNumFiles: {}", (Object)estimatedNumFiles);
        int serviceMaxShards = this.configuration.getInt(MAX_EXPORT_SHARDS_KEY, 500);
        LOG.debug("Fetched serviceMaxShards from '{}': {}", (Object)MAX_EXPORT_SHARDS_KEY, (Object)serviceMaxShards);
        int maxShards = Math.min(estimatedNumFiles, serviceMaxShards);
        if (maxShards < desiredNumMaps) {
            LOG.warn("Estimated max shards < desired num maps ({} < {}); clipping to {}.", new Object[]{maxShards, desiredNumMaps, maxShards});
            return maxShards;
        }
        return desiredNumMaps;
    }
}

