/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery;

import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfiguration;
import com.google.api.services.bigquery.model.JobConfigurationQuery;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.TableReference;
import com.google.cloud.hadoop.io.bigquery.BigQueryHelper;
import com.google.cloud.hadoop.io.bigquery.BigQueryStrings;
import com.google.cloud.hadoop.io.bigquery.BigQueryUtils;
import com.google.cloud.hadoop.io.bigquery.Export;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryBasedExport
implements Export {
    protected static final Logger LOG = LoggerFactory.getLogger(QueryBasedExport.class);
    private final String query;
    private final BigQueryHelper bigQueryHelper;
    private final String projectId;
    private final TableReference tableToExport;
    private final Export delegate;
    private final boolean deleteIntermediateTable;

    public QueryBasedExport(Export delegate, String query, String projectId, BigQueryHelper bigQueryHelper, TableReference tableToExport, boolean deleteIntermediateTable) {
        this.query = query;
        this.bigQueryHelper = bigQueryHelper;
        this.projectId = projectId;
        this.tableToExport = tableToExport;
        this.delegate = delegate;
        this.deleteIntermediateTable = deleteIntermediateTable;
    }

    @Override
    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        return this.delegate.getSplits(context);
    }

    @Override
    public List<String> getExportPaths() throws IOException {
        return this.delegate.getExportPaths();
    }

    @Override
    public void beginExport() throws IOException {
        this.delegate.beginExport();
    }

    @Override
    public void waitForUsableMapReduceInput() throws IOException, InterruptedException {
        this.delegate.waitForUsableMapReduceInput();
    }

    @Override
    public void prepare() throws IOException {
        if (!Strings.isNullOrEmpty((String)this.query)) {
            LOG.info("Invoking query '{}' and saving to '{}' before beginning export/read.", (Object)this.query, (Object)BigQueryStrings.toString(this.tableToExport));
            try {
                QueryBasedExport.runQuery(this.bigQueryHelper, this.projectId, this.tableToExport, this.query);
            }
            catch (InterruptedException ie) {
                throw new IOException(String.format("Interrupted during query '%s' into table '%s'", this.query, BigQueryStrings.toString(this.tableToExport)), ie);
            }
        }
        this.delegate.prepare();
    }

    @Override
    public void cleanupExport() throws IOException {
        if (this.deleteIntermediateTable) {
            LOG.info("Deleting input intermediate table: {}:{}.{}", new Object[]{this.tableToExport.getProjectId(), this.tableToExport.getDatasetId(), this.tableToExport.getTableId()});
            Bigquery.Tables tables = this.bigQueryHelper.getRawBigquery().tables();
            Bigquery.Tables.Delete delete = tables.delete(this.tableToExport.getProjectId(), this.tableToExport.getDatasetId(), this.tableToExport.getTableId());
            delete.execute();
        }
        this.delegate.cleanupExport();
    }

    @VisibleForTesting
    static void runQuery(BigQueryHelper bigQueryHelper, String projectId, TableReference tableRef, String query) throws IOException, InterruptedException {
        LOG.debug("runQuery(bigquery, '{}', '{}', '{}')", new Object[]{projectId, BigQueryStrings.toString(tableRef), query});
        JobConfigurationQuery queryConfig = new JobConfigurationQuery();
        queryConfig.setAllowLargeResults(Boolean.valueOf(true));
        queryConfig.setQuery(query);
        queryConfig.setDestinationTable(tableRef);
        queryConfig.setWriteDisposition("WRITE_EMPTY");
        JobConfiguration config = new JobConfiguration();
        config.setQuery(queryConfig);
        JobReference jobReference = bigQueryHelper.createJobReference(projectId, "querybasedexport");
        Job job = new Job();
        job.setConfiguration(config);
        job.setJobReference(jobReference);
        Job response = bigQueryHelper.insertJobOrFetchDuplicate(projectId, job);
        LOG.debug("Got response '{}'", (Object)response);
        Progressable progressable = new Progressable(){

            public void progress() {
            }
        };
        BigQueryUtils.waitForJobCompletion(bigQueryHelper.getRawBigquery(), projectId, jobReference, progressable);
    }
}

