/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery;

import com.google.api.services.bigquery.model.TableReference;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;

public class BigQueryStrings {
    public static final String DATASET_AND_TABLE_REGEX = "[a-zA-Z0-9_]+\\.[a-zA-Z0-9_$]+";

    public static String toString(TableReference tableRef) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tableRef.getDatasetId()) ? 1 : 0) != 0, (Object)"tableRef must contain non-empty DatasetId.");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tableRef.getTableId()) ? 1 : 0) != 0, (Object)"tableRef must contain non-empty TableId.");
        if (Strings.isNullOrEmpty((String)tableRef.getProjectId())) {
            return String.format("%s.%s", tableRef.getDatasetId(), tableRef.getTableId());
        }
        return String.format("%s:%s.%s", tableRef.getProjectId(), tableRef.getDatasetId(), tableRef.getTableId());
    }

    public static TableReference parseTableReference(String tableRefString) {
        TableReference tableRef = new TableReference();
        int projectIdEnd = tableRefString.lastIndexOf(58);
        String datasetAndTableString = tableRefString;
        if (projectIdEnd != -1) {
            tableRef.setProjectId(tableRefString.substring(0, projectIdEnd));
            datasetAndTableString = tableRefString.substring(projectIdEnd + 1);
        }
        Preconditions.checkArgument((boolean)datasetAndTableString.matches(DATASET_AND_TABLE_REGEX), (String)"Invalid datasetAndTableString '%s'; must match regex '%s'.", (Object[])new Object[]{datasetAndTableString, DATASET_AND_TABLE_REGEX});
        String[] idParts = datasetAndTableString.split("\\.");
        tableRef.setDatasetId(idParts[0]);
        tableRef.setTableId(idParts[1]);
        return tableRef;
    }
}

