/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery;

import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.Dataset;
import com.google.api.services.bigquery.model.DatasetReference;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfiguration;
import com.google.api.services.bigquery.model.JobConfigurationTableCopy;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.TableReference;
import com.google.cloud.hadoop.io.bigquery.BigQueryFactory;
import com.google.cloud.hadoop.io.bigquery.BigQueryHelper;
import com.google.cloud.hadoop.io.bigquery.BigQueryStrings;
import com.google.cloud.hadoop.io.bigquery.BigQueryUtils;
import com.google.cloud.hadoop.util.ApiErrorExtractor;
import com.google.cloud.hadoop.util.HadoopToStringUtil;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.security.GeneralSecurityException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigQueryOutputCommitter
extends OutputCommitter {
    protected static final Logger LOG = LoggerFactory.getLogger(BigQueryOutputCommitter.class);
    private ApiErrorExtractor errorExtractor = new ApiErrorExtractor();
    private String projectId;
    private TableReference tempTableRef;
    private TableReference finalTableRef;
    private BigQueryHelper bigQueryHelper;

    public BigQueryOutputCommitter(String projectId, TableReference tempTableRef, TableReference finalTableRef, Configuration configuration) throws IOException {
        this.projectId = projectId;
        this.tempTableRef = tempTableRef;
        this.finalTableRef = finalTableRef;
        try {
            BigQueryFactory bigQueryFactory = new BigQueryFactory();
            this.bigQueryHelper = bigQueryFactory.getBigQueryHelper(configuration);
        }
        catch (GeneralSecurityException e) {
            LOG.error("Could not get Bigquery", (Throwable)e);
            throw new IOException("Could not get Bigquery", e);
        }
    }

    public void setupJob(JobContext context) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("setupJob({})", (Object)HadoopToStringUtil.toString((JobContext)context));
        }
        DatasetReference datasetReference = new DatasetReference();
        datasetReference.setProjectId(this.tempTableRef.getProjectId());
        datasetReference.setDatasetId(this.tempTableRef.getDatasetId());
        Configuration config = context.getConfiguration();
        Dataset tempDataset = new Dataset();
        tempDataset.setDatasetReference(datasetReference);
        tempDataset.setLocation(config.get("mapred.bq.output.location", "US"));
        Bigquery.Datasets datasets = this.bigQueryHelper.getRawBigquery().datasets();
        LOG.debug("Creating temporary dataset '{}' for project '{}'", (Object)this.tempTableRef.getDatasetId(), (Object)this.tempTableRef.getProjectId());
        datasets.insert(this.tempTableRef.getProjectId(), tempDataset).execute();
    }

    public void cleanupJob(JobContext context) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("cleanupJob({})", (Object)HadoopToStringUtil.toString((JobContext)context));
        }
        Bigquery.Datasets datasets = this.bigQueryHelper.getRawBigquery().datasets();
        Configuration config = context.getConfiguration();
        try {
            LOG.debug("cleanupJob: Deleting dataset '{}' from project '{}'", (Object)this.tempTableRef.getDatasetId(), (Object)this.tempTableRef.getProjectId());
            datasets.delete(this.tempTableRef.getProjectId(), this.tempTableRef.getDatasetId()).setDeleteContents(Boolean.valueOf(true)).execute();
        }
        catch (IOException e) {
            LOG.warn("Could not delete dataset. Temporary data not cleaned up.", (Throwable)e);
        }
    }

    public void abortJob(JobContext jobContext, int status) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("abortJob({}, {})", (Object)HadoopToStringUtil.toString((JobContext)jobContext), (Object)status);
        }
        this.cleanupJob(jobContext);
    }

    public void commitJob(JobContext jobContext) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("commitJob({})", (Object)HadoopToStringUtil.toString((JobContext)jobContext));
        }
        this.cleanupJob(jobContext);
    }

    public void setupTask(TaskAttemptContext context) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("setupTask({})", (Object)HadoopToStringUtil.toString((TaskAttemptContext)context));
        }
    }

    public void commitTask(TaskAttemptContext context) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("commitTask({})", (Object)HadoopToStringUtil.toString((TaskAttemptContext)context));
        }
        JobConfigurationTableCopy copyTableConfig = new JobConfigurationTableCopy();
        copyTableConfig.setSourceTable(this.tempTableRef);
        copyTableConfig.setDestinationTable(this.finalTableRef);
        copyTableConfig.setWriteDisposition("WRITE_APPEND");
        JobConfiguration config = new JobConfiguration();
        config.setCopy(copyTableConfig);
        JobReference jobReference = this.bigQueryHelper.createJobReference(this.projectId, context.getTaskAttemptID().toString());
        Job job = new Job();
        job.setConfiguration(config);
        job.setJobReference(jobReference);
        LOG.debug("commitTask: Running table copy from {} to {}", (Object)BigQueryStrings.toString(this.tempTableRef), (Object)BigQueryStrings.toString(this.finalTableRef));
        Job response = this.bigQueryHelper.insertJobOrFetchDuplicate(this.projectId, job);
        LOG.debug("Got response '{}'", (Object)response);
        try {
            BigQueryUtils.waitForJobCompletion(this.bigQueryHelper.getRawBigquery(), this.projectId, jobReference, (Progressable)context);
        }
        catch (InterruptedException e) {
            LOG.error("Could not check if results of task were transfered.", (Throwable)e);
            throw new IOException("Could not check if results of task were transfered.", e);
        }
        LOG.info("Saved output of task to table '{}' using project '{}'", (Object)BigQueryStrings.toString(this.finalTableRef), (Object)this.projectId);
    }

    public void abortTask(TaskAttemptContext context) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("abortTask({})", (Object)HadoopToStringUtil.toString((TaskAttemptContext)context));
        }
    }

    public boolean needsTaskCommit(TaskAttemptContext context) throws IOException {
        return this.needsTaskCommit(context.getTaskAttemptID());
    }

    @VisibleForTesting
    public boolean needsTaskCommit(TaskAttemptID attemptId) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("needsTaskCommit({}) - tempTableRef: '{}'", (Object)attemptId, (Object)BigQueryStrings.toString(this.tempTableRef));
        }
        boolean tableExists = this.bigQueryHelper.tableExists(this.tempTableRef);
        LOG.debug("needsTaskCommit -> {}", (Object)tableExists);
        return tableExists;
    }

    @VisibleForTesting
    void setBigQueryHelper(BigQueryHelper helper) {
        this.bigQueryHelper = helper;
    }

    @VisibleForTesting
    void setErrorExtractor(ApiErrorExtractor errorExtractor) {
        this.errorExtractor = errorExtractor;
    }
}

