/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.bigquery.Bigquery;
import com.google.cloud.hadoop.io.bigquery.BigQueryHelper;
import com.google.cloud.hadoop.util.HadoopCredentialConfiguration;
import com.google.cloud.hadoop.util.PropertyUtil;
import com.google.cloud.hadoop.util.RetryHttpInitializer;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigQueryFactory {
    public static final String BIGQUERY_CONFIG_PREFIX = "mapred.bq";
    public static final List<String> BIGQUERY_OAUTH_SCOPES = Arrays.asList("https://www.googleapis.com/auth/bigquery");
    public static final String BIGQUERY_SERVICE_ACCOUNT = "BIGQUERY_SERVICE_ACCOUNT";
    public static final String BIGQUERY_PRIVATE_KEY_FILE = "BIGQUERY_PRIVATE_KEY_FILE";
    protected static final Logger LOG = LoggerFactory.getLogger(BigQueryFactory.class);
    public static final String PROPERTIES_FILE = "bigquery.properties";
    public static final String VERSION_PROPERTY = "bigquery.connector.version";
    public static final String UNKNOWN_VERSION = "0.0.0";
    public static final String VERSION;
    public static final String BQC_ID;
    public static final BigQueryFactory INSTANCE;
    private static final HttpTransport HTTP_TRANSPORT;
    private static final JsonFactory JSON_FACTORY;

    public Credential createBigQueryCredential(Configuration config) throws GeneralSecurityException, IOException {
        return ((HadoopCredentialConfiguration)((HadoopCredentialConfiguration.Builder)HadoopCredentialConfiguration.newBuilder().withConfiguration(config).withOverridePrefix(BIGQUERY_CONFIG_PREFIX)).build()).getCredential(BIGQUERY_OAUTH_SCOPES);
    }

    public BigQueryHelper getBigQueryHelper(Configuration config) throws GeneralSecurityException, IOException {
        return new BigQueryHelper(this.getBigQuery(config));
    }

    public Bigquery getBigQuery(Configuration config) throws GeneralSecurityException, IOException {
        LOG.info("Creating BigQuery from default credential.");
        Credential credential = this.createBigQueryCredential(config);
        return this.getBigQueryFromCredential(credential, BQC_ID);
    }

    public Bigquery getBigQueryFromCredential(Credential credential, String appName) {
        LOG.info("Creating BigQuery from given credential.");
        if (credential != null) {
            return new Bigquery.Builder(HTTP_TRANSPORT, JSON_FACTORY, (HttpRequestInitializer)new RetryHttpInitializer(credential, appName)).setApplicationName(appName).build();
        }
        return new Bigquery.Builder(HTTP_TRANSPORT, JSON_FACTORY, (HttpRequestInitializer)credential).setApplicationName(appName).build();
    }

    static {
        INSTANCE = new BigQueryFactory();
        VERSION = PropertyUtil.getPropertyOrDefault(BigQueryFactory.class, (String)PROPERTIES_FILE, (String)VERSION_PROPERTY, (String)UNKNOWN_VERSION);
        LOG.info("Bigquery connector version {}", (Object)VERSION);
        BQC_ID = String.format("Hadoop BigQuery Connector/%s", VERSION);
        HTTP_TRANSPORT = new NetHttpTransport();
        JSON_FACTORY = new JacksonFactory();
    }
}

