/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery;

import com.google.api.services.bigquery.model.TableReference;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemBase;
import com.google.cloud.hadoop.io.bigquery.BigQueryStrings;
import com.google.cloud.hadoop.util.ConfigurationUtil;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigQueryConfiguration {
    public static final String PROJECT_ID_KEY = "mapred.bq.project.id";
    public static final String INPUT_PROJECT_ID_KEY = "mapred.bq.input.project.id";
    public static final String INPUT_DATASET_ID_KEY = "mapred.bq.input.dataset.id";
    public static final String INPUT_TABLE_ID_KEY = "mapred.bq.input.table.id";
    @Deprecated
    public static final String INPUT_QUERY_KEY = "mapred.bq.input.query";
    public static final String TEMP_GCS_PATH_KEY = "mapred.bq.temp.gcs.path";
    public static final String GCS_BUCKET_KEY = "mapred.bq.gcs.bucket";
    @Deprecated
    public static final String DELETE_INTERMEDIATE_TABLE_KEY = "mapred.bq.query.results.table.delete";
    public static final boolean DELETE_INTERMEDIATE_TABLE_DEFAULT = false;
    public static final String DELETE_EXPORT_FILES_FROM_GCS_KEY = "mapred.bq.input.export.files.delete";
    public static final boolean DELETE_EXPORT_FILES_FROM_GCS_DEFAULT = true;
    public static final String ENABLE_SHARDED_EXPORT_KEY = "mapred.bq.input.sharded.export.enable";
    public static final boolean ENABLE_SHARDED_EXPORT_DEFAULT = true;
    public static final String DYNAMIC_FILE_LIST_RECORD_READER_POLL_INTERVAL_MS_KEY = "mapred.bq.dynamic.file.list.record.reader.poll.interval";
    public static final int DYNAMIC_FILE_LIST_RECORD_READER_POLL_INTERVAL_MS_DEFAULT = 10000;
    public static final List<String> MANDATORY_CONFIG_PROPERTIES_INPUT = ImmutableList.of((Object)"mapred.bq.project.id", (Object)"mapred.bq.input.project.id", (Object)"mapred.bq.input.dataset.id", (Object)"mapred.bq.input.table.id");
    public static final String OUTPUT_PROJECT_ID_KEY = "mapred.bq.output.project.id";
    public static final String OUTPUT_DATASET_ID_KEY = "mapred.bq.output.dataset.id";
    public static final String OUTPUT_TABLE_ID_KEY = "mapred.bq.output.table.id";
    public static final String OUTPUT_TABLE_SCHEMA_KEY = "mapred.bq.output.table.schema";
    public static final String OUTPUT_TABLE_WRITE_DISPOSITION_KEY = "mapred.bq.output.table.writedisposition";
    public static final String OUTPUT_TABLE_WRITE_DISPOSITION_DEFAULT = "WRITE_APPEND";
    public static final String OUTPUT_FILE_FORMAT_KEY = "mapred.bq.output.gcs.fileformat";
    public static final String OUTPUT_FORMAT_CLASS_KEY = "mapred.bq.output.gcs.outputformatclass";
    public static final String OUTPUT_CLEANUP_TEMP_KEY = "mapred.bq.output.gcs.cleanup";
    public static final String OUTPUT_WRITE_BUFFER_SIZE_KEY = "mapred.bq.output.buffer.size";
    public static final int OUTPUT_WRITE_BUFFER_SIZE_DEFAULT = 0x4000000;
    public static final String DATA_LOCATION_KEY = "mapred.bq.output.location";
    public static final String DATA_LOCATION_DEFAULT = "US";
    public static final List<String> MANDATORY_CONFIG_PROPERTIES_OUTPUT = ImmutableList.of((Object)"mapred.bq.project.id", (Object)"mapred.bq.output.project.id", (Object)"mapred.bq.output.dataset.id", (Object)"mapred.bq.output.table.id", (Object)"mapred.bq.output.table.schema");
    public static final String ENABLE_ASYNC_WRITE = "mapred.bq.output.async.write.enabled";
    public static final boolean ENABLE_ASYNC_WRITE_DEFAULT = true;
    protected static final Logger LOG = LoggerFactory.getLogger(BigQueryConfiguration.class);

    public static void configureBigQueryInput(Configuration config, String projectId, String datasetId, String tableId) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)datasetId) ? 1 : 0) != 0, (Object)"datasetId must not be null or empty.");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tableId) ? 1 : 0) != 0, (Object)"tableId must not be null or empty.");
        if (!Strings.isNullOrEmpty((String)projectId)) {
            LOG.info("Using specified project-id '{}' for input", (Object)projectId);
            config.set(INPUT_PROJECT_ID_KEY, projectId);
            if (Strings.isNullOrEmpty((String)config.get(PROJECT_ID_KEY))) {
                LOG.warn("No job-level projectId specified in '{}', using '{}' for it.", (Object)PROJECT_ID_KEY, (Object)projectId);
                config.set(PROJECT_ID_KEY, projectId);
            }
        } else {
            String defaultProjectId = ConfigurationUtil.getMandatoryConfig((Configuration)config, (String)PROJECT_ID_KEY);
            LOG.info("Using default project-id '{}' since none specified for input.", (Object)defaultProjectId);
            config.set(INPUT_PROJECT_ID_KEY, defaultProjectId);
        }
        config.set(INPUT_DATASET_ID_KEY, datasetId);
        config.set(INPUT_TABLE_ID_KEY, tableId);
    }

    public static void configureBigQueryInput(Configuration config, String fullyQualifiedInputTableId) throws IOException {
        TableReference parsedTable = BigQueryStrings.parseTableReference(fullyQualifiedInputTableId);
        BigQueryConfiguration.configureBigQueryInput(config, parsedTable.getProjectId(), parsedTable.getDatasetId(), parsedTable.getTableId());
    }

    public static void configureBigQueryOutput(Configuration config, String projectId, String datasetId, String tableId, String tableSchema) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)datasetId) ? 1 : 0) != 0, (Object)"datasetId must not be null or empty.");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tableId) ? 1 : 0) != 0, (Object)"tableId must not be null or empty.");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tableSchema) ? 1 : 0) != 0, (Object)"tableSchema must not be null or empty.");
        if (!Strings.isNullOrEmpty((String)projectId)) {
            LOG.info("Using specified project-id '{}' for output", (Object)projectId);
            config.set(OUTPUT_PROJECT_ID_KEY, projectId);
            if (Strings.isNullOrEmpty((String)config.get(PROJECT_ID_KEY))) {
                LOG.warn("No job-level projectId specified in '{}', using '{}' for it.", (Object)PROJECT_ID_KEY, (Object)projectId);
                config.set(PROJECT_ID_KEY, projectId);
            }
        } else {
            String defaultProjectId = ConfigurationUtil.getMandatoryConfig((Configuration)config, (String)PROJECT_ID_KEY);
            LOG.info("Using default project-id '{}' since none specified for output.", (Object)defaultProjectId);
            config.set(OUTPUT_PROJECT_ID_KEY, defaultProjectId);
        }
        config.set(OUTPUT_DATASET_ID_KEY, datasetId);
        config.set(OUTPUT_TABLE_ID_KEY, tableId);
        config.set(OUTPUT_TABLE_SCHEMA_KEY, tableSchema);
    }

    public static void configureBigQueryOutput(Configuration config, String fullyQualifiedOutputTableId, String tableSchema) throws IOException {
        TableReference parsedTable = BigQueryStrings.parseTableReference(fullyQualifiedOutputTableId);
        BigQueryConfiguration.configureBigQueryOutput(config, parsedTable.getProjectId(), parsedTable.getDatasetId(), parsedTable.getTableId(), tableSchema);
    }

    public static String getTemporaryPathRoot(Configuration conf, JobID jobId) throws IOException {
        String pathRoot = conf.get(TEMP_GCS_PATH_KEY);
        if (Strings.isNullOrEmpty((String)pathRoot)) {
            LOG.info("Fetching key '{}' since '{}' isn't set explicitly.", (Object)GCS_BUCKET_KEY, (Object)TEMP_GCS_PATH_KEY);
            String gcsBucket = conf.get(GCS_BUCKET_KEY, "${fs.gs.system.bucket}");
            if (Strings.isNullOrEmpty((String)gcsBucket)) {
                throw new IOException("Must supply a value for configuration setting: mapred.bq.gcs.bucket");
            }
            pathRoot = String.format("gs://%s/hadoop/tmp/bigquery/%s", gcsBucket, jobId);
        }
        LOG.info("Using working path: '{}'", (Object)pathRoot);
        Path workingPath = new Path(pathRoot);
        FileSystem fs = workingPath.getFileSystem(conf);
        Preconditions.checkState((boolean)(fs instanceof GoogleHadoopFileSystemBase), (Object)"Export FS must derive from GoogleHadoopFileSystemBase.");
        return pathRoot;
    }
}

