/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.alloydb;

import com.google.cloud.alloydb.AuthType;
import com.google.cloud.alloydb.ConnectorConfig;
import com.google.cloud.alloydb.IpType;
import com.google.cloud.alloydb.RefreshStrategy;
import com.google.cloud.alloydb.v1alpha.InstanceName;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;

class ConnectionConfig {
    public static final String ALLOYDB_INSTANCE_NAME = "alloydbInstanceName";
    public static final String ALLOYDB_TARGET_PRINCIPAL = "alloydbTargetPrincipal";
    public static final String ALLOYDB_DELEGATES = "alloydbDelegates";
    public static final String ALLOYDB_NAMED_CONNECTOR = "alloydbNamedConnector";
    public static final String ALLOYDB_ADMIN_SERVICE_ENDPOINT = "alloydbAdminServiceEndpoint";
    public static final String ALLOYDB_GOOGLE_CREDENTIALS_PATH = "alloydbGoogleCredentialsPath";
    public static final String ALLOYDB_QUOTA_PROJECT = "alloydbQuotaProject";
    public static final String ENABLE_IAM_AUTH_PROPERTY = "alloydbEnableIAMAuth";
    public static final String ALLOYDB_IP_TYPE = "alloydbIpType";
    public static final String ALLOYDB_REFRESH_STRATEGY = "alloydbRefreshStrategy";
    public static final AuthType DEFAULT_AUTH_TYPE = AuthType.PASSWORD;
    public static final IpType DEFAULT_IP_TYPE = IpType.PRIVATE;
    private final InstanceName instanceName;
    private final String namedConnector;
    private final ConnectorConfig connectorConfig;
    private final AuthType authType;
    private final IpType ipType;

    static ConnectionConfig fromConnectionProperties(Properties props) {
        ConnectionConfig.validateProperties(props);
        String instanceNameStr = props.getProperty(ALLOYDB_INSTANCE_NAME, "");
        InstanceName instanceName = InstanceName.parse((String)instanceNameStr);
        String namedConnector = props.getProperty(ALLOYDB_NAMED_CONNECTOR);
        String adminServiceEndpoint = props.getProperty(ALLOYDB_ADMIN_SERVICE_ENDPOINT);
        String targetPrincipal = props.getProperty(ALLOYDB_TARGET_PRINCIPAL);
        String delegatesStr = props.getProperty(ALLOYDB_DELEGATES);
        List<String> delegates = delegatesStr != null && !delegatesStr.isEmpty() ? Arrays.asList(delegatesStr.split(",")) : Collections.emptyList();
        String googleCredentialsPath = props.getProperty(ALLOYDB_GOOGLE_CREDENTIALS_PATH);
        AuthType authType = Boolean.parseBoolean(props.getProperty(ENABLE_IAM_AUTH_PROPERTY)) ? AuthType.IAM : AuthType.PASSWORD;
        String quotaProject = props.getProperty(ALLOYDB_QUOTA_PROJECT);
        IpType ipType = IpType.PRIVATE;
        if (props.getProperty(ALLOYDB_IP_TYPE) != null) {
            ipType = IpType.valueOf(props.getProperty(ALLOYDB_IP_TYPE).toUpperCase(Locale.getDefault()));
        }
        RefreshStrategy refreshStrategy = RefreshStrategy.REFRESH_AHEAD;
        if (props.getProperty(ALLOYDB_REFRESH_STRATEGY) != null) {
            refreshStrategy = RefreshStrategy.valueOf(props.getProperty(ALLOYDB_REFRESH_STRATEGY).toUpperCase(Locale.getDefault()));
        }
        return new ConnectionConfig(instanceName, namedConnector, authType, ipType, new ConnectorConfig.Builder().withTargetPrincipal(targetPrincipal).withDelegates(delegates).withAdminServiceEndpoint(adminServiceEndpoint).withGoogleCredentialsPath(googleCredentialsPath).withQuotaProject(quotaProject).withRefreshStrategy(refreshStrategy).build());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnectionConfig)) {
            return false;
        }
        ConnectionConfig config = (ConnectionConfig)o;
        return Objects.equals(this.instanceName, config.instanceName) && Objects.equals(this.namedConnector, config.namedConnector) && Objects.equals((Object)this.ipType, (Object)config.ipType) && Objects.equals(this.connectorConfig, config.connectorConfig);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.instanceName, this.namedConnector, this.ipType, this.connectorConfig});
    }

    private static void validateProperties(Properties props) {
        String instanceNameStr = props.getProperty(ALLOYDB_INSTANCE_NAME, "");
        Preconditions.checkArgument((boolean)InstanceName.isParsableFrom((String)instanceNameStr), (Object)String.format("'%s' must have format: projects/<PROJECT>/locations/<REGION>/clusters/<CLUSTER>/instances/<INSTANCE>", ALLOYDB_INSTANCE_NAME));
    }

    private ConnectionConfig(InstanceName instanceName, String namedConnector, AuthType authType, IpType ipType, ConnectorConfig connectorConfig) {
        this.instanceName = instanceName;
        this.namedConnector = namedConnector;
        this.connectorConfig = connectorConfig;
        this.authType = authType;
        this.ipType = ipType;
    }

    ConnectionConfig withConnectorConfig(ConnectorConfig config) {
        return new ConnectionConfig(this.instanceName, this.namedConnector, this.authType, this.ipType, config);
    }

    InstanceName getInstanceName() {
        return this.instanceName;
    }

    String getNamedConnector() {
        return this.namedConnector;
    }

    ConnectorConfig getConnectorConfig() {
        return this.connectorConfig;
    }

    AuthType getAuthType() {
        return this.authType;
    }

    IpType getIpType() {
        return this.ipType;
    }

    static class Builder {
        private InstanceName instanceName;
        private String namedConnector;
        private ConnectorConfig connectorConfig = new ConnectorConfig.Builder().build();
        private AuthType authType = DEFAULT_AUTH_TYPE;
        private IpType ipType = DEFAULT_IP_TYPE;

        Builder() {
        }

        Builder withInstanceName(InstanceName instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        Builder withNamedConnector(String namedConnector) {
            this.namedConnector = namedConnector;
            return this;
        }

        Builder withConnectorConfig(ConnectorConfig connectorConfig) {
            this.connectorConfig = connectorConfig;
            return this;
        }

        public Builder withAuthType(AuthType authType) {
            this.authType = authType;
            return this;
        }

        public Builder withIpType(IpType ipType) {
            this.ipType = ipType;
            return this;
        }

        ConnectionConfig build() {
            return new ConnectionConfig(this.instanceName, this.namedConnector, this.authType, this.ipType, this.connectorConfig);
        }
    }
}

