/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.auth.oauth2.AccessToken;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;

final class StsTokenExchangeResponse {
    private final AccessToken accessToken;
    private final String issuedTokenType;
    private final String tokenType;
    private final Long expiresInSeconds;
    @Nullable
    private final String refreshToken;
    @Nullable
    private final List<String> scopes;

    private StsTokenExchangeResponse(String accessToken, String issuedTokenType, String tokenType, Long expiresInSeconds, @Nullable String refreshToken, @Nullable List<String> scopes) {
        Preconditions.checkNotNull((Object)accessToken);
        this.expiresInSeconds = (Long)Preconditions.checkNotNull((Object)expiresInSeconds);
        long expiresAtMilliseconds = System.currentTimeMillis() + expiresInSeconds * 1000L;
        this.accessToken = new AccessToken(accessToken, new Date(expiresAtMilliseconds));
        this.issuedTokenType = (String)Preconditions.checkNotNull((Object)issuedTokenType);
        this.tokenType = (String)Preconditions.checkNotNull((Object)tokenType);
        this.refreshToken = refreshToken;
        this.scopes = scopes;
    }

    public static Builder newBuilder(String accessToken, String issuedTokenType, String tokenType, Long expiresIn) {
        return new Builder(accessToken, issuedTokenType, tokenType, expiresIn);
    }

    public AccessToken getAccessToken() {
        return this.accessToken;
    }

    public String getIssuedTokenType() {
        return this.issuedTokenType;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public Long getExpiresInSeconds() {
        return this.expiresInSeconds;
    }

    @Nullable
    public String getRefreshToken() {
        return this.refreshToken;
    }

    @Nullable
    public List<String> getScopes() {
        if (this.scopes == null) {
            return null;
        }
        return new ArrayList<String>(this.scopes);
    }

    public static class Builder {
        private final String accessToken;
        private final String issuedTokenType;
        private final String tokenType;
        private final Long expiresInSeconds;
        @Nullable
        private String refreshToken;
        @Nullable
        private List<String> scopes;

        private Builder(String accessToken, String issuedTokenType, String tokenType, Long expiresInSeconds) {
            this.accessToken = accessToken;
            this.issuedTokenType = issuedTokenType;
            this.tokenType = tokenType;
            this.expiresInSeconds = expiresInSeconds;
        }

        public Builder setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public Builder setScopes(List<String> scopes) {
            if (scopes != null) {
                this.scopes = new ArrayList<String>(scopes);
            }
            return this;
        }

        public StsTokenExchangeResponse build() {
            return new StsTokenExchangeResponse(this.accessToken, this.issuedTokenType, this.tokenType, this.expiresInSeconds, this.refreshToken, this.scopes);
        }
    }
}

