/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.exception;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.apphosting.api.DatastorePb;
import com.google.cloud.datastore.core.exception.LegacyProblem;
import com.google.cloud.datastore.core.exception.Problem;
import com.google.cloud.datastore.logs.ProblemCode;
import javax.annotation.Nullable;

public class DatastoreException
extends Exception
implements Cloneable {
    private RetryOptions retryOptions;
    private final DatastorePb.Error.ErrorCode errorCode;
    private final Problem problem;

    public static Builder builder() {
        return new Builder();
    }

    public boolean isNeverRetryable() {
        return this.retryOptions() == RetryOptions.NOT_RETRYABLE || this.errorCode.equals((Object)DatastorePb.Error.ErrorCode.INTERNAL_ERROR);
    }

    public RetryOptions retryOptions() {
        return this.retryOptions;
    }

    public DatastoreException(String message, DatastorePb.Error.ErrorCode errorCode, @Nullable Throwable cause) {
        this(message, errorCode, LegacyProblem.create(message), cause, RetryOptions.DEFAULT);
    }

    public DatastoreException(ProblemCode problemCode, String message, DatastorePb.Error.ErrorCode errorCode) {
        this(message, errorCode, Problem.create((ProblemCode)Preconditions.checkNotNull((Object)problemCode)), null, RetryOptions.DEFAULT);
    }

    public DatastoreException(ProblemCode problemCode, String message, DatastorePb.Error.ErrorCode errorCode, @Nullable Throwable cause) {
        this(message, errorCode, Problem.create((ProblemCode)Preconditions.checkNotNull((Object)problemCode)), cause, RetryOptions.DEFAULT);
    }

    protected DatastoreException(String message, DatastorePb.Error.ErrorCode errorCode, Problem problem, @Nullable Throwable cause, RetryOptions retryOptions) {
        super((String)Preconditions.checkNotNull((Object)message), cause);
        this.errorCode = (DatastorePb.Error.ErrorCode)Preconditions.checkNotNull((Object)errorCode);
        this.problem = problem;
        this.retryOptions = retryOptions;
    }

    public DatastorePb.Error.ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public Problem getProblem() {
        return this.problem;
    }

    public DatastoreException withProblemCode(ProblemCode problemCode) {
        return this.withProblem(Problem.create((ProblemCode)Preconditions.checkNotNull((Object)problemCode)));
    }

    public DatastoreException withProblem(Problem problem) {
        return new DatastoreException(this.getMessage(), this.errorCode, (Problem)Preconditions.checkNotNull((Object)problem), this.getCause(), this.retryOptions);
    }

    public DatastoreException asNonRetryable() {
        try {
            DatastoreException copy = (DatastoreException)this.clone();
            copy.retryOptions = RetryOptions.NOT_RETRYABLE;
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public static boolean sameErrorAndMessage(@Nullable DatastoreException current, @Nullable DatastoreException other) {
        if (current != null && other != null) {
            return current.sameErrorAndProblemCode(other) && current.getMessage().equals(other.getMessage());
        }
        return current == null && other == null;
    }

    public boolean sameErrorAndProblemCode(DatastoreException other) {
        return this.getErrorCode().equals((Object)other.getErrorCode()) && this.getProblem().getProblemCode().equals((Object)other.getProblem().getProblemCode());
    }

    public static class Builder {
        private RetryOptions retryOptions = RetryOptions.DEFAULT;
        private DatastorePb.Error.ErrorCode errorCode;
        private Problem problem;
        private String message;
        @Nullable
        private Throwable cause;

        public Builder forceNonRetryable() {
            Preconditions.checkArgument((this.retryOptions == RetryOptions.DEFAULT ? 1 : 0) != 0, (Object)"RetryOptions already set.");
            this.retryOptions = RetryOptions.NOT_RETRYABLE;
            return this;
        }

        public Builder retryOptions(RetryOptions retryOptions) {
            this.retryOptions = (RetryOptions)((Object)Preconditions.checkNotNull((Object)((Object)retryOptions)));
            return this;
        }

        public Builder errorCode(DatastorePb.Error.ErrorCode errorCode) {
            this.errorCode = (DatastorePb.Error.ErrorCode)Preconditions.checkNotNull((Object)errorCode);
            return this;
        }

        public Builder problemCode(ProblemCode problemCode) {
            this.problem = (Problem)Preconditions.checkNotNull((Object)Problem.create(problemCode));
            return this;
        }

        public Builder problem(Problem problem) {
            this.problem = (Problem)Preconditions.checkNotNull((Object)problem);
            return this;
        }

        public Builder message(String message) {
            this.message = (String)Preconditions.checkNotNull((Object)message);
            return this;
        }

        public Builder cause(@Nullable Throwable cause) {
            this.cause = cause;
            return this;
        }

        public DatastoreException build() {
            if (this.problem == null) {
                this.problem = LegacyProblem.create(this.message);
            }
            return new DatastoreException(this.message, this.errorCode, this.problem, this.cause, this.retryOptions);
        }
    }

    public static enum RetryOptions {
        DEFAULT,
        NOT_RETRYABLE;

    }
}

