/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.util;

public final class UnicodeUtil {
    public static final int UNI_SUR_HIGH_START = 55296;
    public static final int UNI_SUR_HIGH_END = 56319;
    public static final int UNI_SUR_LOW_START = 56320;
    public static final int UNI_SUR_LOW_END = 57343;
    public static final int UNI_REPLACEMENT_CHAR = 65533;
    private static final long UNI_MAX_BMP = 65535L;
    private static final int HALF_BASE = 65536;
    private static final long HALF_SHIFT = 10L;
    private static final long HALF_MASK = 1023L;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void UTF16toUTF8(char[] source, int offset, UTF8Result result) {
        int upto = 0;
        int i = offset;
        byte[] out = result.result;
        while (true) {
            int utf32;
            char code = source[i++];
            if (upto + 4 > out.length) {
                byte[] newOut = new byte[2 * out.length];
                if (!$assertionsDisabled && newOut.length < upto + 4) {
                    throw new AssertionError();
                }
                System.arraycopy(out, 0, newOut, 0, upto);
                out = newOut;
                result.result = newOut;
            }
            if (code < '\u0080') {
                out[upto++] = (byte)code;
                continue;
            }
            if (code < '\u0800') {
                out[upto++] = (byte)(0xC0 | code >> 6);
                out[upto++] = (byte)(0x80 | code & 0x3F);
                continue;
            }
            if (code < '\ud800' || code > '\udfff') {
                if (code == '\uffff') break;
                out[upto++] = (byte)(0xE0 | code >> 12);
                out[upto++] = (byte)(0x80 | code >> 6 & 0x3F);
                out[upto++] = (byte)(0x80 | code & 0x3F);
                continue;
            }
            if (code < '\udc00' && source[i] != '\uffff' && (utf32 = source[i]) >= 56320 && utf32 <= 57343) {
                utf32 = (code - 55232 << 10) + (utf32 & 0x3FF);
                ++i;
                out[upto++] = (byte)(0xF0 | utf32 >> 18);
                out[upto++] = (byte)(0x80 | utf32 >> 12 & 0x3F);
                out[upto++] = (byte)(0x80 | utf32 >> 6 & 0x3F);
                out[upto++] = (byte)(0x80 | utf32 & 0x3F);
                continue;
            }
            out[upto++] = -17;
            out[upto++] = -65;
            out[upto++] = -67;
        }
        result.length = upto;
    }

    public static void UTF16toUTF8(char[] source, int offset, int length, UTF8Result result) {
        int upto = 0;
        int i = offset;
        int end = offset + length;
        byte[] out = result.result;
        while (i < end) {
            int utf32;
            char code = source[i++];
            if (upto + 4 > out.length) {
                byte[] newOut = new byte[2 * out.length];
                if (!$assertionsDisabled && newOut.length < upto + 4) {
                    throw new AssertionError();
                }
                System.arraycopy(out, 0, newOut, 0, upto);
                out = newOut;
                result.result = newOut;
            }
            if (code < '\u0080') {
                out[upto++] = (byte)code;
                continue;
            }
            if (code < '\u0800') {
                out[upto++] = (byte)(0xC0 | code >> 6);
                out[upto++] = (byte)(0x80 | code & 0x3F);
                continue;
            }
            if (code < '\ud800' || code > '\udfff') {
                out[upto++] = (byte)(0xE0 | code >> 12);
                out[upto++] = (byte)(0x80 | code >> 6 & 0x3F);
                out[upto++] = (byte)(0x80 | code & 0x3F);
                continue;
            }
            if (code < '\udc00' && i < end && source[i] != '\uffff' && (utf32 = source[i]) >= 56320 && utf32 <= 57343) {
                utf32 = (code - 55232 << 10) + (utf32 & 0x3FF);
                ++i;
                out[upto++] = (byte)(0xF0 | utf32 >> 18);
                out[upto++] = (byte)(0x80 | utf32 >> 12 & 0x3F);
                out[upto++] = (byte)(0x80 | utf32 >> 6 & 0x3F);
                out[upto++] = (byte)(0x80 | utf32 & 0x3F);
                continue;
            }
            out[upto++] = -17;
            out[upto++] = -65;
            out[upto++] = -67;
        }
        result.length = upto;
    }

    public static void UTF16toUTF8(String s, int offset, int length, UTF8Result result) {
        int end = offset + length;
        byte[] out = result.result;
        int upto = 0;
        for (int i = offset; i < end; ++i) {
            int utf32;
            char code = s.charAt(i);
            if (upto + 4 > out.length) {
                byte[] newOut = new byte[2 * out.length];
                if (!$assertionsDisabled && newOut.length < upto + 4) {
                    throw new AssertionError();
                }
                System.arraycopy(out, 0, newOut, 0, upto);
                out = newOut;
                result.result = newOut;
            }
            if (code < '\u0080') {
                out[upto++] = (byte)code;
                continue;
            }
            if (code < '\u0800') {
                out[upto++] = (byte)(0xC0 | code >> 6);
                out[upto++] = (byte)(0x80 | code & 0x3F);
                continue;
            }
            if (code < '\ud800' || code > '\udfff') {
                out[upto++] = (byte)(0xE0 | code >> 12);
                out[upto++] = (byte)(0x80 | code >> 6 & 0x3F);
                out[upto++] = (byte)(0x80 | code & 0x3F);
                continue;
            }
            if (code < '\udc00' && i < end - 1 && (utf32 = s.charAt(i + 1)) >= 56320 && utf32 <= 57343) {
                utf32 = (code - 55232 << 10) + (utf32 & 0x3FF);
                ++i;
                out[upto++] = (byte)(0xF0 | utf32 >> 18);
                out[upto++] = (byte)(0x80 | utf32 >> 12 & 0x3F);
                out[upto++] = (byte)(0x80 | utf32 >> 6 & 0x3F);
                out[upto++] = (byte)(0x80 | utf32 & 0x3F);
                continue;
            }
            out[upto++] = -17;
            out[upto++] = -65;
            out[upto++] = -67;
        }
        result.length = upto;
    }

    public static void UTF8toUTF16(byte[] utf8, int offset, int length, UTF16Result result) {
        int end = offset + length;
        char[] out = result.result;
        if (result.offsets.length <= end) {
            int[] newOffsets = new int[2 * end];
            System.arraycopy(result.offsets, 0, newOffsets, 0, result.offsets.length);
            result.offsets = newOffsets;
        }
        int[] offsets = result.offsets;
        int upto = offset;
        while (offsets[upto] == -1) {
            --upto;
        }
        int outUpto = offsets[upto];
        if (outUpto + length >= out.length) {
            char[] newOut = new char[2 * (outUpto + length)];
            System.arraycopy(out, 0, newOut, 0, outUpto);
            out = newOut;
            result.result = newOut;
        }
        while (upto < end) {
            int ch;
            int b = utf8[upto] & 0xFF;
            offsets[upto++] = outUpto;
            if (b < 192) {
                if (!$assertionsDisabled && b >= 128) {
                    throw new AssertionError();
                }
                ch = b;
            } else if (b < 224) {
                ch = ((b & 0x1F) << 6) + (utf8[upto] & 0x3F);
                offsets[upto++] = -1;
            } else if (b < 240) {
                ch = ((b & 0xF) << 12) + ((utf8[upto] & 0x3F) << 6) + (utf8[upto + 1] & 0x3F);
                offsets[upto++] = -1;
                offsets[upto++] = -1;
            } else {
                if (!$assertionsDisabled && b >= 248) {
                    throw new AssertionError();
                }
                ch = ((b & 7) << 18) + ((utf8[upto] & 0x3F) << 12) + ((utf8[upto + 1] & 0x3F) << 6) + (utf8[upto + 2] & 0x3F);
                offsets[upto++] = -1;
                offsets[upto++] = -1;
                offsets[upto++] = -1;
            }
            if ((long)ch <= 65535L) {
                out[outUpto++] = (char)ch;
                continue;
            }
            int chHalf = ch - 65536;
            out[outUpto++] = (char)((chHalf >> 10) + 55296);
            out[outUpto++] = (char)(((long)chHalf & 0x3FFL) + 56320L);
        }
        offsets[upto] = outUpto;
        result.length = outUpto;
    }

    static {
        $assertionsDisabled = !UnicodeUtil.class.desiredAssertionStatus();
    }

    public static final class UTF16Result {
        public char[] result = new char[10];
        public int[] offsets = new int[10];
        public int length;

        public void setLength(int newLength) {
            if (this.result.length < newLength) {
                char[] newArray = new char[(int)(1.5 * (double)newLength)];
                System.arraycopy(this.result, 0, newArray, 0, this.length);
                this.result = newArray;
            }
            this.length = newLength;
        }

        public void copyText(UTF16Result other) {
            this.setLength(other.length);
            System.arraycopy(other.result, 0, this.result, 0, this.length);
        }
    }

    public static final class UTF8Result {
        public byte[] result = new byte[10];
        public int length;

        public void setLength(int newLength) {
            if (this.result.length < newLength) {
                byte[] newArray = new byte[(int)(1.5 * (double)newLength)];
                System.arraycopy(this.result, 0, newArray, 0, this.length);
                this.result = newArray;
            }
            this.length = newLength;
        }
    }
}

