/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.datastore.v1.CompositeFilter;
import com.google.appengine.repackaged.com.google.datastore.v1.Filter;
import com.google.appengine.repackaged.com.google.datastore.v1.FilterOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Key;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyFilter;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyFilterOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.QueryOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Value;
import com.google.apphosting.api.DatastorePb;
import com.google.apphosting.datastore.DatastoreV4;

public final class QueryHelper {
    private static Key getFirstAncestorOrParentKey(FilterOrBuilder filter) {
        switch (filter.getFilterTypeCase()) {
            case PROPERTY_FILTER: {
                PropertyFilterOrBuilder propFilter = filter.getPropertyFilterOrBuilder();
                if (propFilter.getPropertyOrBuilder().getName().equals("__key__") && propFilter.getValue().getValueTypeCase() == Value.ValueTypeCase.KEY_VALUE && (propFilter.getOp() == PropertyFilter.Operator.HAS_ANCESTOR || propFilter.getOp() == PropertyFilter.Operator.HAS_PARENT)) {
                    return propFilter.getValue().getKeyValue();
                }
                return null;
            }
            case COMPOSITE_FILTER: {
                if (filter.getCompositeFilter().getOp() == CompositeFilter.Operator.AND) {
                    for (Filter subFilter : filter.getCompositeFilter().getFiltersList()) {
                        Key ancestor = QueryHelper.getFirstAncestorOrParentKey((FilterOrBuilder)subFilter);
                        if (ancestor == null) continue;
                        return ancestor;
                    }
                }
                return null;
            }
            case FILTERTYPE_NOT_SET: {
                return null;
            }
        }
        String string = String.valueOf(filter.getFilterTypeCase());
        throw new IllegalArgumentException(new StringBuilder(26 + String.valueOf(string).length()).append("Unrecognized filter_type: ").append(string).toString());
    }

    public static boolean hasAncestorOrParent(QueryOrBuilder query) {
        return QueryHelper.getFirstAncestorOrParentKey(query) != null;
    }

    public static Key getFirstAncestorOrParentKey(QueryOrBuilder query) {
        return QueryHelper.getFirstAncestorOrParentKey((FilterOrBuilder)query.getFilter());
    }

    public static boolean isSearchQuery(QueryOrBuilder query) {
        return QueryHelper.containsGeoFilter(query.getFilterOrBuilder());
    }

    private static boolean containsGeoFilter(FilterOrBuilder filter) {
        if (filter.getFilterTypeCase() == Filter.FilterTypeCase.COMPOSITE_FILTER) {
            for (FilterOrBuilder sub : filter.getCompositeFilterOrBuilder().getFiltersOrBuilderList()) {
                if (!QueryHelper.containsGeoFilter(sub)) continue;
                return true;
            }
            return false;
        }
        return filter.getFilterTypeCase() == Filter.FilterTypeCase.ST_CONTAINS_FILTER;
    }

    public static boolean isSearchQuery(DatastorePb.Query query) {
        for (DatastorePb.Query.Filter filter : query.filters()) {
            if (filter.getOpEnum() != DatastorePb.Query.Filter.Operator.CONTAINED_IN_REGION) continue;
            return true;
        }
        return false;
    }

    public static boolean isKeysOnlyQuery(DatastoreV4.QueryOrBuilder query) {
        return query.getProjectionCount() == 1 && query.getProjection(0).getProperty().getName().equals("__key__");
    }

    private QueryHelper() {
    }
}

