/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.apphosting.api.DatastorePb;
import com.google.apphosting.datastore.rep.DatabaseRef;
import com.google.apphosting.datastore.shared.DatabaseRefValidator;
import com.google.apphosting.datastore.shared.ValidationException;
import com.google.storage.onestore.v3.OnestoreEntity;

public class AppEngV3DatabaseRefAccessor {
    private static final DatabaseRef EMPTY_INTERNAL_DATABASE = DatabaseRef.createForApp("", "");

    private AppEngV3DatabaseRefAccessor() {
    }

    private static DatabaseRef handleMissingKey() {
        return EMPTY_INTERNAL_DATABASE;
    }

    public static DatabaseRef extract(DatastorePb.GetRequest request) throws ValidationException {
        if (request.keySize() == 0) {
            return AppEngV3DatabaseRefAccessor.handleMissingKey();
        }
        return AppEngV3DatabaseRefAccessor.extract(request.getKey(0));
    }

    public static DatabaseRef extract(DatastorePb.AllocateIdsRequest request) throws ValidationException {
        OnestoreEntity.Reference key;
        if (request.hasModelKey()) {
            key = request.getModelKey();
        } else if (request.reserveSize() > 0) {
            key = request.getReserve(0);
        } else {
            return AppEngV3DatabaseRefAccessor.handleMissingKey();
        }
        return AppEngV3DatabaseRefAccessor.extract(key);
    }

    public static DatabaseRef extract(OnestoreEntity.Reference key) throws ValidationException {
        return DatabaseRefValidator.INSTANCE.createAndValidateDatabaseRef(key.getAppAsBytes(), key.getDatabaseIdAsBytes());
    }

    public static DatabaseRef extract(OnestoreEntity.PropertyValue.ReferenceValue referenceValue) throws ValidationException {
        return DatabaseRefValidator.INSTANCE.createAndValidateDatabaseRef(referenceValue.getAppAsBytes(), referenceValue.getDatabaseIdAsBytes());
    }

    public static DatabaseRef extract(DatastorePb.Transaction request) throws ValidationException {
        return DatabaseRefValidator.INSTANCE.createAndValidateDatabaseRef(request.getAppAsBytes(), request.getDatabaseIdAsBytes());
    }

    public static DatabaseRef extract(DatastorePb.BeginTransactionRequest request) throws ValidationException {
        return DatabaseRefValidator.INSTANCE.createAndValidateDatabaseRef(request.getAppAsBytes(), request.getDatabaseIdAsBytes());
    }

    public static DatabaseRef extract(DatastorePb.Cursor request) throws ValidationException {
        return DatabaseRefValidator.INSTANCE.createAndValidateDatabaseRef(request.getAppAsBytes(), request.getDatabaseIdAsBytes());
    }

    public static DatabaseRef extract(DatastorePb.NextRequest request) throws ValidationException {
        return AppEngV3DatabaseRefAccessor.extract(request.getCursor());
    }

    public static DatabaseRef extract(DatastorePb.Query request) throws ValidationException {
        return DatabaseRefValidator.INSTANCE.createAndValidateDatabaseRef(request.getAppAsBytes(), request.getDatabaseIdAsBytes());
    }

    public static DatabaseRef extract(DatastorePb.AddActionsRequest request) throws ValidationException {
        return AppEngV3DatabaseRefAccessor.extract(request.getTransaction());
    }

    public static DatabaseRef extract(DatastorePb.DeleteRequest request) throws ValidationException {
        if (request.keySize() == 0) {
            return AppEngV3DatabaseRefAccessor.handleMissingKey();
        }
        return AppEngV3DatabaseRefAccessor.extract(request.getKey(0));
    }

    public static DatabaseRef extract(DatastorePb.TouchRequest request) throws ValidationException {
        if (request.keySize() == 0) {
            return EMPTY_INTERNAL_DATABASE;
        }
        return AppEngV3DatabaseRefAccessor.extract(request.getKey(0));
    }

    public static DatabaseRef extract(DatastorePb.PutRequest request) throws ValidationException {
        if (request.entitySize() == 0) {
            return AppEngV3DatabaseRefAccessor.handleMissingKey();
        }
        return AppEngV3DatabaseRefAccessor.extract(request.getEntity(0).getKey());
    }

    public static DatabaseRef extract(OnestoreEntity.EntityProto entityProto) throws ValidationException {
        return AppEngV3DatabaseRefAccessor.extract(entityProto.getKey());
    }

    public static DatabaseRef extract(OnestoreEntity.CompositeIndex request) throws ValidationException {
        return DatabaseRefValidator.INSTANCE.createAndValidateDatabaseRef(request.getAppIdAsBytes(), request.getDatabaseIdAsBytes());
    }

    public static DatabaseRef extract(DatastorePb.GetIndicesRequest request) throws ValidationException {
        return DatabaseRefValidator.INSTANCE.createAndValidateDatabaseRef(request.getAppIdAsBytes(), request.getDatabaseIdAsBytes());
    }

    public static DatabaseRef extractValidated(DatabaseRef unvalidatedName) {
        return unvalidatedName;
    }

    public static DatabaseRef extractValidated(OnestoreEntity.CompositeIndex index) {
        try {
            return AppEngV3DatabaseRefAccessor.extractValidated(AppEngV3DatabaseRefAccessor.extract(index));
        }
        catch (ValidationException e) {
            throw new RuntimeException(e);
        }
    }

    public static DatabaseRef extractValidated(DatastorePb.Transaction transaction) {
        try {
            return AppEngV3DatabaseRefAccessor.extractValidated(AppEngV3DatabaseRefAccessor.extract(transaction));
        }
        catch (ValidationException e) {
            throw new RuntimeException(e);
        }
    }

    public static DatabaseRef extractValidated(OnestoreEntity.Reference key) {
        try {
            return AppEngV3DatabaseRefAccessor.extractValidated(AppEngV3DatabaseRefAccessor.extract(key));
        }
        catch (ValidationException e) {
            throw new RuntimeException(e);
        }
    }

    public static DatabaseRef extractValidated(DatastorePb.PutRequest req) {
        try {
            return AppEngV3DatabaseRefAccessor.extractValidated(AppEngV3DatabaseRefAccessor.extract(req));
        }
        catch (ValidationException e) {
            throw new RuntimeException(e);
        }
    }

    public static DatabaseRef extractValidated(DatastorePb.GetRequest req) {
        try {
            return AppEngV3DatabaseRefAccessor.extractValidated(AppEngV3DatabaseRefAccessor.extract(req));
        }
        catch (ValidationException e) {
            throw new RuntimeException(e);
        }
    }

    public static DatabaseRef extractValidated(DatastorePb.Query req) {
        try {
            return AppEngV3DatabaseRefAccessor.extractValidated(AppEngV3DatabaseRefAccessor.extract(req));
        }
        catch (ValidationException e) {
            throw new RuntimeException(e);
        }
    }

    public static OnestoreEntity.CompositeIndex set(OnestoreEntity.CompositeIndex compositeIndex, DatabaseRef internalDatabase) {
        compositeIndex.setAppId(internalDatabase.appId());
        if (!internalDatabase.databaseId().isEmpty()) {
            compositeIndex.setDatabaseId(internalDatabase.databaseId());
        }
        return compositeIndex;
    }

    public static DatastorePb.Query set(DatastorePb.Query query, DatabaseRef internalDatabase) {
        query.setApp(internalDatabase.appId());
        if (!internalDatabase.databaseId().isEmpty()) {
            query.setDatabaseId(internalDatabase.databaseId());
        }
        return query;
    }

    public static OnestoreEntity.PropertyValue.ReferenceValue set(OnestoreEntity.PropertyValue.ReferenceValue key, DatabaseRef internalDatabase) {
        key.setApp(internalDatabase.appId());
        if (!internalDatabase.databaseId().isEmpty()) {
            key.setDatabaseId(internalDatabase.databaseId());
        }
        return key;
    }

    public static OnestoreEntity.Reference set(OnestoreEntity.Reference key, DatabaseRef internalDatabase) {
        key.setApp(internalDatabase.appId());
        if (!internalDatabase.databaseId().isEmpty()) {
            key.setDatabaseId(internalDatabase.databaseId());
        }
        return key;
    }

    public static DatastorePb.Transaction set(DatastorePb.Transaction transaction, DatabaseRef internalDatabase) {
        transaction.setApp(internalDatabase.appId());
        if (!internalDatabase.databaseId().isEmpty()) {
            transaction.setDatabaseId(internalDatabase.databaseId());
        }
        return transaction;
    }

    public static DatastorePb.BeginTransactionRequest set(DatastorePb.BeginTransactionRequest beginTransactionRequest, DatabaseRef internalDatabase) {
        beginTransactionRequest.setApp(internalDatabase.appId());
        if (!internalDatabase.databaseId().isEmpty()) {
            beginTransactionRequest.setDatabaseId(internalDatabase.databaseId());
        }
        return beginTransactionRequest;
    }

    public static DatastorePb.Cursor set(DatastorePb.Cursor cursor, DatabaseRef internalDatabase) {
        cursor.setApp(internalDatabase.appId());
        if (!internalDatabase.databaseId().isEmpty()) {
            cursor.setDatabaseId(internalDatabase.databaseId());
        }
        return cursor;
    }

    public static DatastorePb.AllocateIdsRequest set(DatastorePb.AllocateIdsRequest request, DatabaseRef internalDatabase) {
        Preconditions.checkArgument((boolean)request.equals(DatastorePb.AllocateIdsRequest.getDefaultInstance()), (Object)"Because there are two places to set keys, and you sent an AllocateIdsRequest that already had something in it, you need to directly set the database where you want.");
        AppEngV3DatabaseRefAccessor.set(request.addReserve(), internalDatabase);
        return request;
    }

    public static DatastorePb.GetIndicesRequest set(DatastorePb.GetIndicesRequest getIndicesRequest, DatabaseRef internalDatabase) {
        getIndicesRequest.setAppId(internalDatabase.appId());
        if (!internalDatabase.databaseId().isEmpty()) {
            getIndicesRequest.setDatabaseId(internalDatabase.databaseId());
        }
        return getIndicesRequest;
    }
}

