/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.search;

import com.google.appengine.repackaged.org.apache.lucene.index.IndexReader;
import com.google.appengine.repackaged.org.apache.lucene.search.DocIdSet;
import com.google.appengine.repackaged.org.apache.lucene.search.DocIdSetIterator;
import com.google.appengine.repackaged.org.apache.lucene.search.FieldCache;
import com.google.appengine.repackaged.org.apache.lucene.search.Filter;
import com.google.appengine.repackaged.org.apache.lucene.util.OpenBitSet;
import java.io.IOException;

public class FieldCacheTermsFilter
extends Filter {
    private String field;
    private String[] terms;

    public FieldCacheTermsFilter(String field, String[] terms) {
        this.field = field;
        this.terms = terms;
    }

    public FieldCache getFieldCache() {
        return FieldCache.DEFAULT;
    }

    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        return new FieldCacheTermsFilterDocIdSet(this.getFieldCache().getStringIndex(reader, this.field));
    }

    protected class FieldCacheTermsFilterDocIdSet
    extends DocIdSet {
        private FieldCache.StringIndex fcsi;
        private OpenBitSet openBitSet;

        public FieldCacheTermsFilterDocIdSet(FieldCache.StringIndex fcsi) {
            this.fcsi = fcsi;
            this.openBitSet = new OpenBitSet(this.fcsi.lookup.length);
            for (int i = 0; i < FieldCacheTermsFilter.this.terms.length; ++i) {
                int termNumber = this.fcsi.binarySearchLookup(FieldCacheTermsFilter.this.terms[i]);
                if (termNumber <= 0) continue;
                this.openBitSet.fastSet(termNumber);
            }
        }

        public DocIdSetIterator iterator() {
            return new FieldCacheTermsFilterDocIdSetIterator();
        }

        public boolean isCacheable() {
            return true;
        }

        protected class FieldCacheTermsFilterDocIdSetIterator
        extends DocIdSetIterator {
            private int doc = -1;

            protected FieldCacheTermsFilterDocIdSetIterator() {
            }

            public int doc() {
                return this.doc;
            }

            public int docID() {
                return this.doc;
            }

            public boolean next() {
                return this.nextDoc() != Integer.MAX_VALUE;
            }

            public int nextDoc() {
                try {
                    while (!FieldCacheTermsFilterDocIdSet.this.openBitSet.fastGet(((FieldCacheTermsFilterDocIdSet)FieldCacheTermsFilterDocIdSet.this).fcsi.order[++this.doc])) {
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    this.doc = Integer.MAX_VALUE;
                }
                return this.doc;
            }

            public boolean skipTo(int target) {
                return this.advance(target) != Integer.MAX_VALUE;
            }

            public int advance(int target) {
                try {
                    this.doc = target;
                    while (!FieldCacheTermsFilterDocIdSet.this.openBitSet.fastGet(((FieldCacheTermsFilterDocIdSet)FieldCacheTermsFilterDocIdSet.this).fcsi.order[this.doc])) {
                        ++this.doc;
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    this.doc = Integer.MAX_VALUE;
                }
                return this.doc;
            }
        }
    }
}

