/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.dev;

import com.google.appengine.api.search.RequestStatusUtil;
import com.google.appengine.api.search.SearchQueryException;
import com.google.appengine.api.search.checkers.DocumentChecker;
import com.google.appengine.api.search.dev.EvaluationException;
import com.google.appengine.api.search.dev.Expression;
import com.google.appengine.api.search.dev.ExpressionBuilder;
import com.google.appengine.api.search.dev.FieldGenerator;
import com.google.appengine.api.search.dev.LuceneDirectoryMap;
import com.google.appengine.api.search.dev.LuceneQueryBuilder;
import com.google.appengine.api.search.dev.LuceneUtils;
import com.google.appengine.api.search.dev.Scorer;
import com.google.appengine.api.search.dev.SearchException;
import com.google.appengine.api.search.dev.WordSeparatorAnalyzer;
import com.google.appengine.repackaged.com.google.appengine.api.search.SearchServicePb;
import com.google.appengine.repackaged.com.google.common.base.Strings;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.org.apache.lucene.analysis.Analyzer;
import com.google.appengine.repackaged.org.apache.lucene.document.Document;
import com.google.appengine.repackaged.org.apache.lucene.index.IndexReader;
import com.google.appengine.repackaged.org.apache.lucene.index.IndexWriter;
import com.google.appengine.repackaged.org.apache.lucene.index.Term;
import com.google.appengine.repackaged.org.apache.lucene.search.IndexSearcher;
import com.google.appengine.repackaged.org.apache.lucene.search.Query;
import com.google.appengine.repackaged.org.apache.lucene.search.ScoreDoc;
import com.google.appengine.repackaged.org.apache.lucene.search.Sort;
import com.google.appengine.repackaged.org.apache.lucene.search.SortField;
import com.google.appengine.repackaged.org.apache.lucene.search.TermRangeQuery;
import com.google.appengine.repackaged.org.apache.lucene.search.TopFieldDocs;
import com.google.appengine.repackaged.org.apache.lucene.store.Directory;
import com.google.appengine.tools.development.AbstractLocalRpcService;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.search.DocumentPb;
import com.google.apphosting.utils.config.GenerationDirectory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocalSearchService
extends AbstractLocalRpcService {
    public static final String PACKAGE = "search";
    public static final String USE_RAM_DIRECTORY = "LocalSearchService.useRamDirectory";
    public static final String USE_DIRECTORY = "LocalSearchService.useDirectory";
    static final Logger LOG = Logger.getLogger(LocalSearchService.class.getCanonicalName());
    public static final String SEARCH_LOG_LEVEL_PROPERTY = "LocalSearchService.LogLevel";
    private static final Level DEFAULT_LOG_LEVEL = Level.INFO;
    private static final int PERSIST_VERSION = 0;
    private static final IndexWriter.MaxFieldLength MAX_FIELD_LENGTH = IndexWriter.MaxFieldLength.LIMITED;
    private LuceneDirectoryMap dirMap;
    private final Analyzer analyzer = new WordSeparatorAnalyzer();
    private Map<String, DocumentPb.Document> documentsById;
    private String documentsFile;
    private static Map<Directory, IndexWriter> indexWriters = new HashMap<Directory, IndexWriter>();

    public LocalSearchService() {
        LOG.info("Local search service created");
    }

    public String getPackage() {
        return PACKAGE;
    }

    public void init(LocalServiceContext context, Map<String, String> properties) {
        String logLevelStr = properties.get(SEARCH_LOG_LEVEL_PROPERTY);
        if (logLevelStr != null) {
            LOG.setLevel(Level.parse(logLevelStr));
        } else {
            LOG.setLevel(DEFAULT_LOG_LEVEL);
        }
        this.documentsById = new LinkedHashMap<String, DocumentPb.Document>();
        if ("true".equals(properties.get(USE_RAM_DIRECTORY))) {
            LOG.warning("Using RAM directory; results are not preserved");
            this.dirMap = new LuceneDirectoryMap.RamBased();
            this.documentsFile = null;
        } else {
            String dirName = properties.get(USE_DIRECTORY);
            File dir = dirName == null ? GenerationDirectory.getGenerationDirectory((File)context.getLocalServerEnvironment().getAppDir()) : new File(dirName);
            File indexDirectory = null;
            dir.mkdirs();
            if (dir.exists()) {
                indexDirectory = new File(dir.getAbsolutePath(), "indexes");
                String string = String.valueOf(dir.getAbsolutePath());
                String string2 = String.valueOf(File.separator);
                this.documentsFile = new StringBuilder(16 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(string2).append("local_search.bin").toString();
                File documentsFileHandle = new File(this.documentsFile);
                if (documentsFileHandle.exists()) {
                    this.loadDocumentMap(indexDirectory, documentsFileHandle);
                }
                this.dirMap = new LuceneDirectoryMap.FileBased(indexDirectory);
            } else {
                if (LOG.isLoggable(Level.WARNING)) {
                    String message = String.format("Failed to create data directory %s, using RAM directory instead; results are not preserved", dir.getAbsolutePath());
                    LOG.warning(message);
                }
                this.dirMap = new LuceneDirectoryMap.RamBased();
                this.documentsFile = null;
            }
        }
        LOG.info(String.valueOf(this.getPackage()).concat(" initialized"));
    }

    private void loadDocumentMap(File indexDirectory, File documentsFile) {
        String path = documentsFile.getAbsolutePath();
        try {
            ObjectInputStream objectIn = new ObjectInputStream(new BufferedInputStream(new FileInputStream(path)));
            int readVersion = objectIn.readInt();
            if (readVersion != 0) {
                this.clearIndexes(indexDirectory);
            } else {
                Map documentsOnDisk;
                this.documentsById = documentsOnDisk = (Map)objectIn.readObject();
            }
            objectIn.close();
        }
        catch (FileNotFoundException e) {
            String string = String.valueOf(path);
            LOG.severe(string.length() != 0 ? "Failed to find search document storage, ".concat(string) : new String("Failed to find search document storage, "));
        }
        catch (IOException e) {
            String string = String.valueOf(path);
            LOG.log(Level.INFO, string.length() != 0 ? "Failed to load from search document storage, ".concat(string) : new String("Failed to load from search document storage, "), e);
            this.clearIndexes(indexDirectory);
        }
        catch (ClassNotFoundException e) {
            String string = String.valueOf(path);
            LOG.log(Level.INFO, string.length() != 0 ? "Failed to load from search document storage, ".concat(string) : new String("Failed to load from search document storage, "), e);
            this.clearIndexes(indexDirectory);
        }
    }

    public void start() {
        LOG.info(String.valueOf(this.getPackage()).concat(" started"));
    }

    private void closeIndexWriters() {
        for (IndexWriter writer : indexWriters.values()) {
            try {
                writer.close();
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Failed to close index writer", e);
            }
        }
        if (this.dirMap != null) {
            try {
                this.dirMap.close();
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Failed to close local directory", e);
            }
        }
    }

    public void stop() {
        this.closeIndexWriters();
        LOG.info(String.valueOf(this.getPackage()).concat(" stopped"));
    }

    public SearchServicePb.IndexDocumentResponse indexDocument(LocalRpcService.Status status, SearchServicePb.IndexDocumentRequest req) {
        return this.indexDocumentForApp(LocalSearchService.getAppId(), req.getParams().getIndexSpec(), req.getParams().getDocumentList());
    }

    public SearchServicePb.IndexDocumentResponse indexDocumentForApp(String appId, String indexId, DocumentPb.Document doc) {
        return this.indexDocumentForApp(appId, SearchServicePb.IndexSpec.newBuilder().setName(indexId).build(), Lists.newArrayList((Object[])new DocumentPb.Document[]{doc}));
    }

    private SearchServicePb.IndexDocumentResponse indexDocumentForApp(String appId, SearchServicePb.IndexSpec indexSpec, List<DocumentPb.Document> docList) {
        IndexWriter indexWriter;
        SearchServicePb.IndexDocumentResponse.Builder respBuilder = SearchServicePb.IndexDocumentResponse.newBuilder();
        int docsToIndex = docList.size();
        if (this.dirMap == null) {
            LOG.severe("Index documents called before local search service was initialized");
            return respBuilder.addAllStatus(LocalSearchService.newRepeatedStatus(docsToIndex, SearchServicePb.SearchServiceError.ErrorCode.INVALID_REQUEST)).build();
        }
        try {
            indexWriter = this.getIndexWriter(this.dirMap.getDirectory(appId, indexSpec), true);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Unable to access index", e);
            return respBuilder.addAllStatus(LocalSearchService.newRepeatedStatus(docsToIndex, SearchServicePb.SearchServiceError.ErrorCode.INTERNAL_ERROR)).build();
        }
        for (DocumentPb.Document d : docList) {
            try {
                DocumentChecker.checkValid((DocumentPb.Document)d);
            }
            catch (IllegalArgumentException e) {
                respBuilder.addStatus(RequestStatusUtil.newStatus((SearchServicePb.SearchServiceError.ErrorCode)SearchServicePb.SearchServiceError.ErrorCode.INVALID_REQUEST, (String)e.getMessage()));
                continue;
            }
            String id = d.getId();
            if (Strings.isNullOrEmpty((String)d.getId())) {
                id = UUID.randomUUID().toString();
                d = d.toBuilder().setId(id).build();
                respBuilder.addDocId(id);
            } else {
                respBuilder.addDocId(d.getId());
            }
            Document doc = LuceneUtils.toLuceneDocument(id, d);
            try {
                indexWriter.updateDocument(new Term("_DOCID", id), doc);
            }
            catch (IOException e) {
                respBuilder.addStatus(RequestStatusUtil.newStatus((SearchServicePb.SearchServiceError.ErrorCode)SearchServicePb.SearchServiceError.ErrorCode.INTERNAL_ERROR));
                continue;
            }
            respBuilder.addStatus(RequestStatusUtil.newStatus((SearchServicePb.SearchServiceError.ErrorCode)SearchServicePb.SearchServiceError.ErrorCode.OK));
        }
        if (LOG.isLoggable(Level.FINE)) {
            try {
                LOG.fine(String.format("Added %d documents. Index %s holds %d documents", docList.size(), indexSpec.getName(), indexWriter.numDocs()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.commitChangesToIndexWriter(indexWriter);
        return respBuilder.build();
    }

    public SearchServicePb.DeleteDocumentResponse deleteDocument(LocalRpcService.Status status, SearchServicePb.DeleteDocumentRequest req) {
        return this.deleteDocumentForApp(LocalSearchService.getAppId(), req.getParams().getIndexSpec(), (List<String>)req.getParams().getDocIdList());
    }

    public SearchServicePb.DeleteDocumentResponse deleteDocumentForApp(String appId, String indexId, String docId) {
        return this.deleteDocumentForApp(appId, SearchServicePb.IndexSpec.newBuilder().setName(indexId).build(), Lists.newArrayList((Object[])new String[]{docId}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SearchServicePb.DeleteDocumentResponse deleteDocumentForApp(String appId, SearchServicePb.IndexSpec indexSpec, List<String> docIdList) {
        SearchServicePb.DeleteDocumentResponse.Builder respBuilder = SearchServicePb.DeleteDocumentResponse.newBuilder();
        int docsToDelete = docIdList.size();
        if (this.dirMap == null) {
            LOG.severe("Delete documents called before local search service was initialized");
            return respBuilder.addAllStatus(LocalSearchService.newRepeatedStatus(docsToDelete, SearchServicePb.SearchServiceError.ErrorCode.INVALID_REQUEST)).build();
        }
        if (docsToDelete <= 0) {
            LOG.info("Request to delete 0 documents; ignoring");
            return respBuilder.build();
        }
        IndexWriter indexWriter = null;
        try {
            indexWriter = this.getIndexWriter(this.dirMap.getDirectory(appId, indexSpec), false);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to access index directory", e);
            return respBuilder.addAllStatus(LocalSearchService.newRepeatedStatus(docsToDelete, SearchServicePb.SearchServiceError.ErrorCode.INTERNAL_ERROR)).build();
        }
        if (indexWriter == null) {
            LOG.info("Request to delete documents from non-existing index; ignoring");
            return respBuilder.addAllStatus(LocalSearchService.newRepeatedStatus(docsToDelete, SearchServicePb.SearchServiceError.ErrorCode.OK, "Not found")).build();
        }
        Term[] deleteTerms = new Term[docsToDelete];
        ArrayList<SearchServicePb.RequestStatus> docStatusList = new ArrayList<SearchServicePb.RequestStatus>();
        for (int i = 0; i < docsToDelete; ++i) {
            boolean docExists;
            String docId = docIdList.get(i);
            deleteTerms[i] = LuceneUtils.newDeleteTerm(docId);
            try {
                docExists = this.getDocuments(appId, indexSpec, docId, true, 1).iterator().hasNext();
            }
            catch (IOException e) {
                String string = String.valueOf(docId);
                LOG.log(Level.SEVERE, string.length() != 0 ? "Failed to check existance of document ".concat(string) : new String("Failed to check existance of document "), e);
                docExists = false;
            }
            docStatusList.add(RequestStatusUtil.newStatus((SearchServicePb.SearchServiceError.ErrorCode)SearchServicePb.SearchServiceError.ErrorCode.OK, (String)(docExists ? null : "Not found")));
        }
        try {
            indexWriter.deleteDocuments(deleteTerms);
            SearchServicePb.DeleteDocumentResponse i = respBuilder.addAllStatus(docStatusList).build();
            return i;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to delete documents", e);
            SearchServicePb.DeleteDocumentResponse deleteDocumentResponse = respBuilder.addAllStatus(LocalSearchService.newRepeatedStatus(docsToDelete, SearchServicePb.SearchServiceError.ErrorCode.INTERNAL_ERROR)).build();
            return deleteDocumentResponse;
        }
        finally {
            this.commitChangesToIndexWriter(indexWriter);
        }
    }

    public SearchServicePb.ListIndexesResponse listIndexes(LocalRpcService.Status status, SearchServicePb.ListIndexesRequest req) throws IOException {
        return this.listIndexesForApp(LocalSearchService.getAppId(), req);
    }

    public SearchServicePb.ListIndexesResponse listIndexesForApp(String appId, SearchServicePb.ListIndexesRequest req) throws IOException {
        SearchServicePb.ListIndexesResponse.Builder respBuilder = SearchServicePb.ListIndexesResponse.newBuilder();
        SearchServicePb.RequestStatus requestStatus = RequestStatusUtil.newStatus((SearchServicePb.SearchServiceError.ErrorCode)SearchServicePb.SearchServiceError.ErrorCode.OK);
        if (this.dirMap == null) {
            LOG.severe("List indexes called before local search service was initialized");
            return respBuilder.setStatus(RequestStatusUtil.newStatus((SearchServicePb.SearchServiceError.ErrorCode)SearchServicePb.SearchServiceError.ErrorCode.INVALID_REQUEST)).build();
        }
        List<SearchServicePb.IndexMetadata.Builder> indexMetadatas = this.dirMap.listIndexes(appId, req.getParams());
        long MAX_STORAGE = 0x40000000L;
        for (SearchServicePb.IndexMetadata.Builder builder : indexMetadatas) {
            if (!IndexReader.indexExists(this.dirMap.getDirectory(appId, builder.getIndexSpec()))) continue;
            if (req.getParams().getFetchSchema()) {
                Map<String, Set<DocumentPb.FieldValue.ContentType>> schema = this.getFieldTypes(appId, builder.getIndexSpec());
                for (String fieldName : schema.keySet()) {
                    builder.addField(DocumentPb.FieldTypes.newBuilder().setName(fieldName).addAllType((Iterable)schema.get(fieldName)));
                }
            }
            try {
                long amountUsed = this.addUpStorageUsed(appId, builder.getIndexSpec());
                builder.setStorage(SearchServicePb.IndexMetadata.Storage.newBuilder().setAmountUsed(amountUsed).setLimit(0x40000000L));
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Failed to list indexes", e);
                requestStatus = RequestStatusUtil.newStatus((SearchServicePb.SearchServiceError.ErrorCode)SearchServicePb.SearchServiceError.ErrorCode.INTERNAL_ERROR, (String)e.getMessage());
            }
            respBuilder.addIndexMetadata(builder);
        }
        return respBuilder.setStatus(requestStatus).build();
    }

    private long addUpStorageUsed(String appId, SearchServicePb.IndexSpec indexSpec) throws IOException {
        long amount = 0L;
        for (Document luceneDoc : this.getDocuments(appId, indexSpec, "", true, Integer.MAX_VALUE)) {
            DocumentPb.Document doc = this.getFullDoc(luceneDoc);
            for (DocumentPb.Field field : doc.getFieldList()) {
                amount += (long)field.getSerializedSize();
            }
            amount += (long)LuceneUtils.toAppengineDocumentId(luceneDoc).getId().getBytes(StandardCharsets.UTF_8).length;
        }
        return amount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Document> getDocuments(String appId, SearchServicePb.IndexSpec indexSpec, String start, boolean includeStart, int limit) throws IOException {
        Directory directory = this.dirMap.getDirectory(appId, indexSpec);
        if (!IndexReader.indexExists(directory)) {
            return Collections.emptyList();
        }
        IndexSearcher indexSearcher = new IndexSearcher(directory, true);
        ArrayList<Document> docs = new ArrayList<Document>();
        try {
            ScoreDoc[] scoreDocs;
            TopFieldDocs topDocs = indexSearcher.search(new TermRangeQuery("_DOCID", start, Character.toString('\u007f'), includeStart, true), null, limit, new Sort(new SortField("_DOCID", 11)));
            for (ScoreDoc scoreDoc : scoreDocs = topDocs.scoreDocs) {
                try {
                    docs.add(indexSearcher.doc(scoreDoc.doc));
                }
                catch (IOException e) {
                    LOG.log(Level.SEVERE, e.getMessage(), e);
                    throw new SearchException(e.toString());
                }
            }
        }
        finally {
            LocalSearchService.closeIndexSearcher(indexSearcher);
        }
        return docs;
    }

    private DocumentPb.Document getFullDoc(Document luceneDoc) throws InvalidProtocolBufferException {
        DocumentPb.Document gaeDoc = LuceneUtils.toAppengineDocument(luceneDoc);
        if (gaeDoc == null) {
            String docId = LuceneUtils.toAppengineDocumentId(luceneDoc).getId();
            gaeDoc = this.documentsById.get(docId);
        }
        return gaeDoc;
    }

    public SearchServicePb.ListDocumentsResponse listDocuments(LocalRpcService.Status status, SearchServicePb.ListDocumentsRequest req) {
        return this.listDocumentsForApp(LocalSearchService.getAppId(), req);
    }

    public SearchServicePb.ListDocumentsResponse listDocumentsForApp(String appId, SearchServicePb.ListDocumentsRequest req) {
        SearchServicePb.ListDocumentsResponse.Builder respBuilder = SearchServicePb.ListDocumentsResponse.newBuilder();
        if (this.dirMap == null) {
            LOG.severe("listDocuments called before local search service was initialized");
            return respBuilder.setStatus(RequestStatusUtil.newStatus((SearchServicePb.SearchServiceError.ErrorCode)SearchServicePb.SearchServiceError.ErrorCode.INVALID_REQUEST)).build();
        }
        SearchServicePb.ListDocumentsParams params = req.getParams();
        try {
            List<Document> docs = this.getDocuments(appId, params.getIndexSpec(), params.getStartDocId(), params.getIncludeStartDoc(), params.getLimit());
            for (Document doc : docs) {
                if (params.getKeysOnly()) {
                    respBuilder.addDocument(LuceneUtils.toAppengineDocumentId(doc));
                    continue;
                }
                respBuilder.addDocument(this.getFullDoc(doc));
            }
            respBuilder.setStatus(RequestStatusUtil.newStatus((SearchServicePb.SearchServiceError.ErrorCode)SearchServicePb.SearchServiceError.ErrorCode.OK));
            return respBuilder.build();
        }
        catch (FileNotFoundException e) {
            LOG.info("List request for empty or non-existing index; ignoring");
            return respBuilder.setStatus(RequestStatusUtil.newStatus((SearchServicePb.SearchServiceError.ErrorCode)SearchServicePb.SearchServiceError.ErrorCode.OK)).build();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to list documents", e);
            return respBuilder.setStatus(RequestStatusUtil.newStatus((SearchServicePb.SearchServiceError.ErrorCode)SearchServicePb.SearchServiceError.ErrorCode.INTERNAL_ERROR)).build();
        }
    }

    public SearchServicePb.SearchResponse search(LocalRpcService.Status status, SearchServicePb.SearchRequest req) {
        return this.searchForApp(LocalSearchService.getAppId(), req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchServicePb.SearchResponse searchForApp(String appId, SearchServicePb.SearchRequest req) {
        SearchServicePb.SearchResponse.Builder respBuilder = SearchServicePb.SearchResponse.newBuilder();
        if (this.dirMap == null) {
            LOG.severe("Search called before local search service was initialized");
            return this.replyWith(SearchServicePb.SearchServiceError.ErrorCode.INVALID_REQUEST, respBuilder);
        }
        SearchServicePb.SearchParams searchParams = req.getParams();
        IndexSearcher indexSearcher = null;
        Map<String, Set<DocumentPb.FieldValue.ContentType>> fieldTypes = null;
        try {
            Directory directory = this.dirMap.getDirectory(appId, searchParams.getIndexSpec());
            if (IndexReader.indexExists(directory)) {
                fieldTypes = this.getFieldTypes(appId, searchParams.getIndexSpec());
                indexSearcher = new IndexSearcher(directory, true);
                indexSearcher.setDefaultFieldSortScoring(true, false);
            }
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to access index", e);
            return this.replyWith(SearchServicePb.SearchServiceError.ErrorCode.INTERNAL_ERROR, respBuilder);
        }
        if (indexSearcher == null) {
            LOG.info("Search on an empty or non-existing index; ignoring");
            String message = String.format("Index '%s' in namespace '%s' does not exist", searchParams.getIndexSpec().getName(), searchParams.getIndexSpec().getNamespace());
            return this.replyWith(SearchServicePb.SearchServiceError.ErrorCode.OK, message, respBuilder);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(String.format("Index %s holds %d documents", searchParams.getIndexSpec().getName(), indexSearcher.getIndexReader().numDocs()));
        }
        try {
            int offset;
            String string;
            Query q = new LuceneQueryBuilder(fieldTypes).parse(searchParams);
            if (LOG.isLoggable(Level.FINE)) {
                String string2 = String.valueOf(searchParams.getQuery());
                string = String.valueOf(q);
                LOG.fine(new StringBuilder(21 + String.valueOf(string2).length() + String.valueOf(string).length()).append("Query ").append(string2).append(" translated to ").append(string).toString());
            }
            if ((offset = LocalSearchService.getOffset(searchParams)) == -1) {
                string = this.replyWith(SearchServicePb.SearchServiceError.ErrorCode.INVALID_REQUEST, respBuilder);
                return string;
            }
            List<FieldGenerator> fieldGenerators = LocalSearchService.createFieldGenerators(searchParams, fieldTypes);
            Scorer scorer = Scorer.newInstance(searchParams, fieldTypes);
            Set<String> fieldFilter = LocalSearchService.createFilter(searchParams);
            int limit = searchParams.getLimit();
            Scorer.SearchResults results = scorer.search(indexSearcher, q, offset, limit);
            DocumentPb.FieldValue defaultExpressionValue = Expression.makeValue(DocumentPb.FieldValue.ContentType.HTML, "");
            int docIndex = offset;
            for (Scorer.Result result : results.results) {
                SearchServicePb.SearchResult.Builder resultBuilder = SearchServicePb.SearchResult.newBuilder();
                DocumentPb.Document fullDoc = this.getFullDoc(result.doc);
                for (FieldGenerator fieldGenerator : fieldGenerators) {
                    DocumentPb.FieldValue fieldValue = defaultExpressionValue;
                    try {
                        fieldValue = fieldGenerator.getExpression().eval(result.doc);
                    }
                    catch (EvaluationException evaluationException) {
                        // empty catch block
                    }
                    resultBuilder.addExpression(DocumentPb.Field.newBuilder().setName(fieldGenerator.getName()).setValue(fieldValue));
                }
                if (req.getParams().hasScorerSpec()) {
                    result.addScores(resultBuilder);
                }
                resultBuilder.setDocument(LocalSearchService.filterDocument(fullDoc, searchParams.getKeysOnly(), fieldFilter));
                if (SearchServicePb.SearchParams.CursorType.PER_RESULT.equals((Object)searchParams.getCursorType())) {
                    resultBuilder.setCursor(Integer.toString(docIndex + 1));
                }
                respBuilder.addResult(resultBuilder);
                ++docIndex;
            }
            respBuilder.setStatus(RequestStatusUtil.newStatus((SearchServicePb.SearchServiceError.ErrorCode)SearchServicePb.SearchServiceError.ErrorCode.OK)).setMatchedCount((long)results.totalHits);
            if (SearchServicePb.SearchParams.CursorType.SINGLE.equals((Object)searchParams.getCursorType()) && results.totalHits - offset > limit) {
                respBuilder.setCursor(Integer.toString(offset + limit));
            }
            respBuilder.addAllFacetResult(Arrays.asList(results.facetResults));
            SearchServicePb.SearchResponse searchResponse = respBuilder.build();
            return searchResponse;
        }
        catch (SearchException e) {
            LOG.log(Level.SEVERE, "Failed to execute search", e);
            SearchServicePb.SearchResponse searchResponse = this.replyWith(SearchServicePb.SearchServiceError.ErrorCode.INVALID_REQUEST, e.getMessage(), respBuilder);
            return searchResponse;
        }
        catch (SearchQueryException e) {
            LOG.log(Level.SEVERE, "Failed to parse query", e);
            SearchServicePb.SearchResponse searchResponse = this.replyWith(SearchServicePb.SearchServiceError.ErrorCode.INVALID_REQUEST, String.format("%s in query '%s'", e.getMessage(), searchParams.getQuery()), respBuilder);
            return searchResponse;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to execute search", e);
            SearchServicePb.SearchResponse searchResponse = this.replyWith(SearchServicePb.SearchServiceError.ErrorCode.INTERNAL_ERROR, respBuilder);
            return searchResponse;
        }
        finally {
            LocalSearchService.closeIndexSearcher(indexSearcher);
        }
    }

    private SearchServicePb.SearchResponse replyWith(SearchServicePb.SearchServiceError.ErrorCode code, SearchServicePb.SearchResponse.Builder respBuilder) {
        return respBuilder.setStatus(RequestStatusUtil.newStatus((SearchServicePb.SearchServiceError.ErrorCode)code)).setMatchedCount(0L).build();
    }

    private SearchServicePb.SearchResponse replyWith(SearchServicePb.SearchServiceError.ErrorCode code, String message, SearchServicePb.SearchResponse.Builder respBuilder) {
        return respBuilder.setStatus(RequestStatusUtil.newStatus((SearchServicePb.SearchServiceError.ErrorCode)code, (String)message)).setMatchedCount(0L).build();
    }

    private static void closeIndexSearcher(IndexSearcher indexSearcher) {
        if (indexSearcher != null) {
            try {
                indexSearcher.close();
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Failed to close index searcher", e);
            }
        }
    }

    private Map<String, Set<DocumentPb.FieldValue.ContentType>> getFieldTypes(String appId, SearchServicePb.IndexSpec indexSpec) {
        TreeMap<String, Set<DocumentPb.FieldValue.ContentType>> fieldTypes = new TreeMap<String, Set<DocumentPb.FieldValue.ContentType>>();
        SearchServicePb.ListDocumentsRequest.Builder req = SearchServicePb.ListDocumentsRequest.newBuilder();
        req.getParamsBuilder().setIndexSpec(indexSpec);
        SearchServicePb.ListDocumentsResponse resp = this.listDocumentsForApp(appId, req.build());
        String lastDoc = this.addFieldTypesToMap(fieldTypes, resp.getDocumentList());
        while (resp.getDocumentCount() == req.getParams().getLimit()) {
            req.getParamsBuilder().setStartDocId(lastDoc).setIncludeStartDoc(false);
            resp = this.listDocumentsForApp(appId, req.build());
            lastDoc = this.addFieldTypesToMap(fieldTypes, resp.getDocumentList());
        }
        return fieldTypes;
    }

    private String addFieldTypesToMap(Map<String, Set<DocumentPb.FieldValue.ContentType>> fieldTypes, List<DocumentPb.Document> docList) {
        String lastDoc = "";
        for (DocumentPb.Document document : docList) {
            for (DocumentPb.Field field : document.getFieldList()) {
                Set<DocumentPb.FieldValue.ContentType> types = fieldTypes.get(field.getName());
                if (types == null) {
                    types = new LinkedHashSet<DocumentPb.FieldValue.ContentType>();
                    fieldTypes.put(field.getName(), types);
                }
                types.add(field.getValue().getType());
            }
            lastDoc = document.getId();
        }
        return lastDoc;
    }

    private static List<SearchServicePb.RequestStatus> newRepeatedStatus(int count, SearchServicePb.SearchServiceError.ErrorCode errorCode) {
        ArrayList<SearchServicePb.RequestStatus> statusList = new ArrayList<SearchServicePb.RequestStatus>();
        for (int i = 0; i < count; ++i) {
            statusList.add(RequestStatusUtil.newStatus((SearchServicePb.SearchServiceError.ErrorCode)errorCode));
        }
        return statusList;
    }

    private static List<SearchServicePb.RequestStatus> newRepeatedStatus(int count, SearchServicePb.SearchServiceError.ErrorCode errorCode, String errorDetail) {
        ArrayList<SearchServicePb.RequestStatus> statusList = new ArrayList<SearchServicePb.RequestStatus>();
        for (int i = 0; i < count; ++i) {
            statusList.add(RequestStatusUtil.newStatus((SearchServicePb.SearchServiceError.ErrorCode)errorCode, (String)errorDetail));
        }
        return statusList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexWriter getIndexWriter(Directory directory, boolean createIfNotPresent) throws IOException {
        Map<Directory, IndexWriter> map = indexWriters;
        synchronized (map) {
            IndexWriter writer = indexWriters.get(directory);
            if (writer != null) {
                return writer;
            }
            if (IndexReader.indexExists(directory)) {
                writer = new IndexWriter(directory, this.analyzer, false, MAX_FIELD_LENGTH);
            } else {
                if (!createIfNotPresent) {
                    return null;
                }
                writer = new IndexWriter(directory, this.analyzer, true, MAX_FIELD_LENGTH);
            }
            indexWriters.put(directory, writer);
            return writer;
        }
    }

    private void recursiveDelete(File file) throws IOException {
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                this.recursiveDelete(f);
            }
        }
        if (!file.delete()) {
            String string = String.valueOf(file);
            throw new IOException(new StringBuilder(22 + String.valueOf(string).length()).append("Failed to delete file ").append(string).toString());
        }
    }

    private void clearIndexes(final File indexDirectory) {
        if (indexDirectory == null) {
            this.dirMap = new LuceneDirectoryMap.RamBased();
        } else {
            this.closeIndexWriters();
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws IOException {
                        if (indexDirectory.exists()) {
                            LocalSearchService.this.recursiveDelete(indexDirectory);
                        }
                        indexDirectory.mkdirs();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException(e);
            }
            this.dirMap = new LuceneDirectoryMap.FileBased(indexDirectory);
        }
    }

    private void commitChangesToIndexWriter(IndexWriter indexWriter) {
        if (indexWriter != null) {
            try {
                indexWriter.commit();
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Failed to commit changes to an index", e);
            }
        }
    }

    private static int getOffset(SearchServicePb.SearchParams searchParams) {
        if (searchParams.hasOffset() && searchParams.hasCursor()) {
            LOG.severe("Both offset and cursor are set");
            return -1;
        }
        if (searchParams.hasOffset()) {
            return searchParams.getOffset();
        }
        if (!searchParams.hasCursor()) {
            return 0;
        }
        try {
            return Integer.parseInt(searchParams.getCursor());
        }
        catch (NumberFormatException e) {
            String string = String.valueOf(searchParams.getCursor());
            LOG.log(Level.SEVERE, string.length() != 0 ? "Invalid cursor value: ".concat(string) : new String("Invalid cursor value: "), e);
            return -1;
        }
    }

    private static Set<String> createFilter(SearchServicePb.SearchParams searchParams) {
        if (searchParams.getKeysOnly()) {
            return new HashSet<String>();
        }
        if (searchParams.getFieldSpec().getNameList().isEmpty()) {
            return null;
        }
        return new HashSet<String>((Collection<String>)searchParams.getFieldSpec().getNameList());
    }

    private static DocumentPb.Document filterDocument(DocumentPb.Document fullDoc, boolean keysOnly, Set<String> fieldFilter) {
        DocumentPb.Document.Builder docBuilder = DocumentPb.Document.newBuilder();
        docBuilder.setId(fullDoc.getId());
        if (!keysOnly) {
            for (DocumentPb.Field field : fullDoc.getFieldList()) {
                if (fieldFilter != null && !fieldFilter.contains(field.getName())) continue;
                docBuilder.addField(field);
            }
            docBuilder.setOrderId(fullDoc.getOrderId());
            if (fullDoc.hasLanguage()) {
                docBuilder.setLanguage(fullDoc.getLanguage());
            }
        }
        return docBuilder.build();
    }

    private static List<FieldGenerator> createFieldGenerators(SearchServicePb.SearchParams searchParams, Map<String, Set<DocumentPb.FieldValue.ContentType>> fieldTypes) {
        ExpressionBuilder exprBuilder = new ExpressionBuilder(fieldTypes);
        ArrayList<FieldGenerator> fieldGenerators = new ArrayList<FieldGenerator>();
        for (SearchServicePb.FieldSpec.Expression exprSpec : searchParams.getFieldSpec().getExpressionList()) {
            Expression expr = null;
            try {
                expr = exprBuilder.parse(exprSpec.getExpression());
            }
            catch (IllegalArgumentException e) {
                String errorMessage = String.format("Failed to parse field '%s': %s", exprSpec.getExpression(), e.getMessage());
                throw new SearchException(errorMessage);
            }
            fieldGenerators.add(new FieldGenerator(exprSpec.getName(), expr));
        }
        return fieldGenerators;
    }

    private static String getAppId() {
        ApiProxy.Environment environment = ApiProxy.getCurrentEnvironment();
        if (environment == null) {
            LOG.severe("Unable to retrieve information about the calling application. Aborting!");
            throw new ApiProxy.ApiProxyException("Failed to access application environment");
        }
        String appId = environment.getAppId();
        if (appId == null) {
            LOG.severe("Unable to read application ID. Aborting!");
            throw new ApiProxy.ApplicationException(3, "Failed to retrieve application ID");
        }
        return appId;
    }

    public SearchServicePb.DeleteSchemaResponse deleteSchema(Object object, SearchServicePb.DeleteSchemaRequest request) {
        SearchServicePb.DeleteSchemaParams params = request.getParams();
        SearchServicePb.DeleteSchemaResponse.Builder builder = SearchServicePb.DeleteSchemaResponse.newBuilder();
        for (int i = 0; i < params.getIndexSpecCount(); ++i) {
            builder.addStatus(RequestStatusUtil.newStatus((SearchServicePb.SearchServiceError.ErrorCode)SearchServicePb.SearchServiceError.ErrorCode.OK));
        }
        return builder.build();
    }
}

