/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore.dev;

import com.google.appengine.api.datastore.dev.LocalDatastoreService;
import com.google.appengine.api.datastore.dev.PseudoKind;
import com.google.appengine.api.datastore.dev.Utils;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.apphosting.api.DatastorePb;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class PseudoKinds {
    static final OnestoreEntity.EntityProto NOT_A_PSEUDO_KIND = new OnestoreEntity.EntityProto();
    private final Map<String, PseudoKind> pseudoKinds = new ConcurrentHashMap<String, PseudoKind>();

    PseudoKinds() {
    }

    void register(PseudoKind implementation) {
        Preconditions.checkNotNull((Object)implementation);
        PseudoKind previous = this.pseudoKinds.put(implementation.getKindName(), implementation);
        String string = String.valueOf(implementation.getKindName());
        Preconditions.checkState((previous == null ? 1 : 0) != 0, (Object)(string.length() != 0 ? "duplicate registration for pseudo-kind ".concat(string) : new String("duplicate registration for pseudo-kind ")));
    }

    List<OnestoreEntity.EntityProto> runQuery(DatastorePb.Query query) {
        Preconditions.checkNotNull((Object)query);
        PseudoKind pseudoKind = this.pseudoKinds.get(query.getKind());
        if (pseudoKind == null) {
            return null;
        }
        query.clearKind();
        List<OnestoreEntity.EntityProto> results = pseudoKind.runQuery(query);
        String string = String.valueOf(pseudoKind.getKindName());
        Preconditions.checkNotNull(results, (Object)new StringBuilder(36 + String.valueOf(string).length()).append("pseudo-kind ").append(string).append(" returned invalid result").toString());
        return results;
    }

    OnestoreEntity.EntityProto get(LocalDatastoreService.LiveTxn txn, LocalDatastoreService.Profile.EntityGroup eg, OnestoreEntity.Reference key, boolean eventualConsistency) {
        PseudoKind pseudoKind = this.pseudoKinds.get(Utils.getKind(key));
        if (pseudoKind == null) {
            return NOT_A_PSEUDO_KIND;
        }
        return pseudoKind.get(txn, eg, key, eventualConsistency);
    }
}

