/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.UnknownFieldSet;
import com.google.apphosting.datastore.EntityV4;
import com.google.apphosting.datastore.shared.EntityV4Helper;
import com.google.apphosting.datastore.shared.Paths;
import com.google.apphosting.datastore.shared.ValidationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class EntityV4Validator {
    private final boolean isInput;
    private final boolean requireCompletePartitionIds;
    private final boolean validateSubObjects;
    private final boolean validateStringsAsUtf8;

    public EntityV4Validator(boolean isInput, boolean requireCompletePartitionIds, boolean validateSubObjects, boolean validateStringsAsUtf8) {
        this.isInput = isInput;
        this.requireCompletePartitionIds = requireCompletePartitionIds;
        this.validateSubObjects = validateSubObjects;
        this.validateStringsAsUtf8 = validateStringsAsUtf8;
    }

    public void validateEntity(KeyConstraint keyConstraint, EntityV4.EntityOrBuilder entity) throws ValidationException {
        if (entity.hasKey()) {
            this.validateKey(keyConstraint, (EntityV4.KeyOrBuilder)entity.getKey());
        } else {
            ValidationException.validateAssertion(keyConstraint == KeyConstraint.ANY, "Missing key.", new Object[0]);
        }
        HashSet propertyNameSet = Sets.newHashSet();
        for (EntityV4.Property property : entity.getPropertyList()) {
            String propertyName = property.getName();
            ValidationException.validateAssertion(propertyNameSet.add(propertyName), "Duplicate property name \"%s\".", propertyName);
            if (!this.validateSubObjects) continue;
            this.validateProperty((EntityV4.PropertyOrBuilder)property);
        }
    }

    public void validateKey(KeyConstraint keyConstraint, EntityV4.KeyOrBuilder key) throws ValidationException {
        int numKeyPathElements;
        if (key.hasPartitionId() && this.validateSubObjects) {
            this.validatePartitionId(key.getPartitionId());
        }
        ValidationException.validateAssertion((numKeyPathElements = key.getPathElementCount()) != 0, "Empty key path.", new Object[0]);
        int numIncompleteElements = 0;
        for (EntityV4.Key.PathElement element : key.getPathElementList()) {
            this.validateStringUtf8("key path kind", element.getKindBytes());
            String kind = element.getKind();
            this.validateStringNotEmpty("key path kind", kind);
            this.validateStringNotReserved("Key path kind", kind);
            boolean elementHasName = element.hasName();
            if (element.hasId()) {
                ValidationException.validateAssertion(!elementHasName, "Key path element has both id (%d) and name (\"%s\").", element.getId(), element.getName());
                ValidationException.validateAssertion(element.getId() != 0L, "Invalid key path id 0.", new Object[0]);
                continue;
            }
            if (elementHasName) {
                this.validateStringUtf8("key path name", element.getNameBytes());
                String name = element.getName();
                this.validateStringNotEmpty("key path name", name);
                this.validateStringNotReserved("Key path name", name);
                continue;
            }
            ++numIncompleteElements;
        }
        EntityV4.Key.PathElementOrBuilder finalElement = key.getPathElementOrBuilder(numKeyPathElements - 1);
        boolean finalElementComplete = finalElement.hasId() || finalElement.hasName();
        switch (keyConstraint) {
            case PATH_INCOMPLETE: {
                ValidationException.validateAssertion(!finalElementComplete, "Key path is complete: %s", Paths.toPathString(key));
                ValidationException.validateAssertion(numIncompleteElements == 1, "Key path element is incomplete: %s", Paths.toPathString(key));
                break;
            }
            case PATH_COMPLETE_WITH_ID: {
                ValidationException.validateAssertion(finalElement.hasId(), "Key does not have numeric id: %s", Paths.toPathString(key));
                ValidationException.validateAssertion(numIncompleteElements == 0, "Key path element is incomplete: %s", Paths.toPathString(key));
                break;
            }
            case PATH_COMPLETE: {
                ValidationException.validateAssertion(finalElementComplete, "Key path is incomplete: %s", Paths.toPathString(key));
                ValidationException.validateAssertion(numIncompleteElements == 0, "Key path element is incomplete: %s", Paths.toPathString(key));
                break;
            }
            case ANY: {
                ValidationException.validateAssertion(numIncompleteElements == (finalElementComplete ? 0 : 1), "Key path element is incomplete: %s", Paths.toPathString(key));
            }
        }
    }

    private void validatePartitionIdField(String name, ByteString byteStringValue) throws ValidationException {
        this.validateStringUtf8(name, byteStringValue);
        String stringValue = byteStringValue.toStringUtf8();
        this.validateStringNotEmpty(name, stringValue);
        this.validateStringNotReserved(name, stringValue);
        ValidationException.validateAssertion(!stringValue.contains("!"), name + " must not contain '!'.", new Object[0]);
    }

    public void validatePartitionId(EntityV4.PartitionId partitionId) throws ValidationException {
        if (this.requireCompletePartitionIds) {
            ValidationException.validateAssertion(partitionId.hasDatasetId(), "Partition id is missing dataset id.", new Object[0]);
        }
        if (partitionId.hasDatasetId()) {
            this.validatePartitionIdField("dataset_id", partitionId.getDatasetIdBytes());
        }
        if (partitionId.hasNamespace()) {
            this.validatePartitionIdField("namespace", partitionId.getNamespaceBytes());
        }
        for (Map.Entry unknownField : partitionId.getUnknownFields().asMap().entrySet()) {
            if ((Integer)unknownField.getKey() < 1 || (Integer)unknownField.getKey() > 100) {
                return;
            }
            String name = "<unknown_field>@" + unknownField.getKey();
            ValidationException.validateAssertion(((UnknownFieldSet.Field)unknownField.getValue()).getFixed32List().isEmpty() && ((UnknownFieldSet.Field)unknownField.getValue()).getFixed64List().isEmpty() && ((UnknownFieldSet.Field)unknownField.getValue()).getGroupList().isEmpty() && ((UnknownFieldSet.Field)unknownField.getValue()).getVarintList().isEmpty() && ((UnknownFieldSet.Field)unknownField.getValue()).getLengthDelimitedList().size() == 1, "unexpected value in " + name, new Object[0]);
            this.validatePartitionIdField(name, (ByteString)((UnknownFieldSet.Field)unknownField.getValue()).getLengthDelimitedList().get(0));
        }
    }

    void validateValue(EntityV4.ValueOrBuilder value) throws ValidationException {
        this.validateValueUnion(value);
        if (value.hasStringValue()) {
            this.validateStringUtf8("string value", value.getStringValueBytes());
        } else if (value.hasKeyValue()) {
            if (this.validateSubObjects) {
                this.validateKey(KeyConstraint.PATH_COMPLETE, (EntityV4.KeyOrBuilder)value.getKeyValue());
            }
        } else if (value.hasEntityValue() && this.validateSubObjects) {
            this.validateEntity(KeyConstraint.ANY, (EntityV4.EntityOrBuilder)value.getEntityValue());
        }
        this.validateValueMeaningMatchesUnion(value);
        this.validateValueMeaningConstraints(value);
        this.validateValueIndexConstraints(value);
    }

    void validateProperty(EntityV4.PropertyOrBuilder property) throws ValidationException {
        this.validateStringUtf8("property name", property.getNameBytes());
        String propertyName = property.getName();
        this.validateStringNotEmpty("property name", propertyName);
        this.validateStringNotReserved("Property name", propertyName);
        int numValues = property.getValueCount();
        ValidationException.validateAssertion(numValues > 0, "Property \"%s\" has no value.", propertyName);
        ValidationException.validateAssertion(property.getMulti() || numValues == 1, "Single-valued property \"%s\" has many values.", propertyName);
        if (this.validateSubObjects) {
            for (EntityV4.Value value : property.getValueList()) {
                this.validateValue((EntityV4.ValueOrBuilder)value);
            }
        }
    }

    private void validateValueUnion(EntityV4.ValueOrBuilder value) throws ValidationException {
        int numSubValues = 0;
        if (value.hasBooleanValue()) {
            ++numSubValues;
        }
        if (value.hasIntegerValue()) {
            ++numSubValues;
        }
        if (value.hasDoubleValue()) {
            ++numSubValues;
        }
        if (value.hasTimestampMicrosecondsValue()) {
            ++numSubValues;
        }
        if (value.hasKeyValue()) {
            ++numSubValues;
        }
        if (value.hasBlobKeyValue()) {
            ++numSubValues;
        }
        if (value.hasStringValue()) {
            ++numSubValues;
        }
        if (value.hasBlobValue()) {
            ++numSubValues;
        }
        if (value.hasEntityValue()) {
            ++numSubValues;
        }
        ValidationException.validateAssertion(numSubValues <= 1, "Value has multiple <type>_value fields set.", new Object[0]);
    }

    private void validateValueMeaningMatchesUnion(EntityV4.ValueOrBuilder value) throws ValidationException {
        if (!value.hasMeaning()) {
            return;
        }
        String message = "Value meaning %d does not match %s fields.";
        int meaning = value.getMeaning();
        switch (meaning) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                ValidationException.validateAssertion(value.hasStringValue(), message, meaning, "string_value");
                break;
            }
            case 16: 
            case 22: {
                ValidationException.validateAssertion(value.hasBlobValue(), message, meaning, "blob_value");
                break;
            }
            case 13: {
                ValidationException.validateAssertion(value.hasIntegerValue(), message, meaning, "integer_value");
                break;
            }
            case 9: 
            case 20: 
            case 21: {
                ValidationException.validateAssertion(value.hasEntityValue(), message, meaning, "entity_value");
                break;
            }
            default: {
                throw new ValidationException("Unknown meaning: " + meaning);
            }
        }
    }

    private void validateValueMeaningConstraints(EntityV4.ValueOrBuilder value) throws ValidationException {
        if (!value.hasMeaning()) {
            return;
        }
        switch (value.getMeaning()) {
            case 16: {
                ValidationException.validateAssertion(value.getBlobValue().size() <= 500, "A blob value with meaning %d cannot have more than %d bytes.", value.getMeaning(), 500);
                if (this.isInput) break;
                ValidationException.validateAssertion(!value.getIndexed(), "Indexed blob value has meaning %d.", value.getMeaning());
                break;
            }
            case 15: 
            case 22: {
                ValidationException.validateAssertion(!value.getIndexed(), "Meaning %d cannot be indexed", value.getMeaning());
                break;
            }
            case 2: {
                ValidationException.validateAssertion(value.getStringValue().length() <= 2038, "Url value has too many characters.", new Object[0]);
                break;
            }
            case 13: {
                ValidationException.validateAssertion(value.getIntegerValue() >= 0L && value.getIntegerValue() <= 100L, "Percent value outside range [0, 100].", new Object[0]);
                break;
            }
            case 9: {
                Map<String, EntityV4.ValueOrBuilder> propertyMap = this.validatePredefinedValueEntity("Geo Point", (Map<String, Integer>)EntityV4Helper.PredefinedEntityPointConstants.PROPERTY_MAP, (Set<String>)EntityV4Helper.PredefinedEntityPointConstants.REQUIRED_PROPERTY_NAME_SET, (EntityV4.EntityOrBuilder)value.getEntityValue());
                double lat = propertyMap.get("x").getDoubleValue();
                double lon = propertyMap.get("y").getDoubleValue();
                ValidationException.validateAssertion(Math.abs(lat) <= 90.0, "Latitude must be between -90 and 90.", new Object[0]);
                ValidationException.validateAssertion(Math.abs(lon) <= 180.0, "Longitude must be between -180 and 180.", new Object[0]);
                break;
            }
            case 21: {
                this.validatePredefinedValueEntity("Point", (Map<String, Integer>)EntityV4Helper.PredefinedEntityPointConstants.PROPERTY_MAP, (Set<String>)EntityV4Helper.PredefinedEntityPointConstants.REQUIRED_PROPERTY_NAME_SET, (EntityV4.EntityOrBuilder)value.getEntityValue());
                break;
            }
            case 20: {
                this.validatePredefinedValueEntity("User", (Map<String, Integer>)EntityV4Helper.PredefinedEntityUserConstants.PROPERTY_MAP, (Set<String>)EntityV4Helper.PredefinedEntityUserConstants.REQUIRED_PROPERTY_NAME_SET, (EntityV4.EntityOrBuilder)value.getEntityValue());
                break;
            }
            case 18: {
                ValidationException.validateAssertion(!this.isInput, "Entity has index-only meaning.", new Object[0]);
            }
        }
    }

    private Map<String, EntityV4.ValueOrBuilder> validatePredefinedValueEntity(String predefinedEntityName, Map<String, Integer> allowedProperties, Set<String> requiredPropertyNameSet, EntityV4.EntityOrBuilder entity) throws ValidationException {
        ValidationException.validateAssertion(!entity.hasKey(), "%s entity has a key.", predefinedEntityName);
        HashMap propertyMap = Maps.newHashMap();
        for (EntityV4.Property property : entity.getPropertyList()) {
            String propertyName = property.getName();
            ValidationException.validateAssertion(allowedProperties.containsKey(propertyName), "%s entity property \"%s\" is not allowed.", predefinedEntityName, propertyName);
            ValidationException.validateAssertion(!property.getMulti(), "%s entity property \"%s\" is multi-valued.", predefinedEntityName, propertyName);
            EntityV4.Value value = property.getValue(0);
            boolean isValueRequiredType = value.hasField(EntityV4.Value.getDescriptor().findFieldByNumber(allowedProperties.get(propertyName).intValue()));
            ValidationException.validateAssertion(isValueRequiredType, "%s entity property \"%s\" is the wrong type.", predefinedEntityName, propertyName);
            ValidationException.validateAssertion(!value.hasMeaning(), "%s entity property \"%s\" has a meaning.", predefinedEntityName, propertyName);
            ValidationException.validateAssertion(!value.getIndexed(), "%s entity property \"%s\" is indexed.", predefinedEntityName, propertyName);
            propertyMap.put(propertyName, value);
        }
        for (String requiredPropertyName : requiredPropertyNameSet) {
            ValidationException.validateAssertion(propertyMap.containsKey(requiredPropertyName), "%s entity is missing required property \"%s\".", predefinedEntityName, requiredPropertyName);
        }
        return propertyMap;
    }

    private void validateValueIndexConstraints(EntityV4.ValueOrBuilder value) throws ValidationException {
        if (!value.getIndexed()) {
            return;
        }
        if (value.hasStringValue() && value.getMeaning() != 2) {
            ValidationException.validateAssertion(value.getStringValue().length() <= 500, "Indexed string value has too many characters.", new Object[0]);
        } else if (value.hasBlobValue()) {
            ValidationException.validateAssertion(value.getBlobValue().size() <= 500, "Indexed blob value has too many bytes.", new Object[0]);
        } else if (value.hasEntityValue()) {
            ValidationException.validateAssertion(value.hasMeaning(), "Entity value cannot be indexed.", new Object[0]);
        }
    }

    private void validateStringUtf8(String stringName, ByteString byteString) throws ValidationException {
        if (this.validateStringsAsUtf8) {
            ValidationException.validateAssertion(byteString.isValidUtf8(), "Non-utf8 %s.", stringName);
        }
    }

    private void validateStringNotEmpty(String stringName, String string) throws ValidationException {
        ValidationException.validateAssertion(!string.isEmpty(), "Empty %s.", stringName);
    }

    private void validateStringNotReserved(String stringName, String string) throws ValidationException {
        if (this.isInput) {
            ValidationException.validateAssertion(!Paths.RESERVED_NAME.matcher(string).matches(), "%s \"%s\" is reserved.", stringName, string);
        }
    }

    public static enum KeyConstraint {
        PATH_COMPLETE,
        PATH_COMPLETE_WITH_ID,
        PATH_INCOMPLETE,
        ANY;

    }
}

