/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.http.client.methods;

import com.google.appengine.repackaged.org.apache.http.ProtocolVersion;
import com.google.appengine.repackaged.org.apache.http.RequestLine;
import com.google.appengine.repackaged.org.apache.http.annotation.NotThreadSafe;
import com.google.appengine.repackaged.org.apache.http.client.methods.AbortableHttpRequest;
import com.google.appengine.repackaged.org.apache.http.client.methods.HttpUriRequest;
import com.google.appengine.repackaged.org.apache.http.client.utils.CloneUtils;
import com.google.appengine.repackaged.org.apache.http.conn.ClientConnectionRequest;
import com.google.appengine.repackaged.org.apache.http.conn.ConnectionReleaseTrigger;
import com.google.appengine.repackaged.org.apache.http.message.AbstractHttpMessage;
import com.google.appengine.repackaged.org.apache.http.message.BasicRequestLine;
import com.google.appengine.repackaged.org.apache.http.message.HeaderGroup;
import com.google.appengine.repackaged.org.apache.http.params.HttpParams;
import com.google.appengine.repackaged.org.apache.http.params.HttpProtocolParams;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@NotThreadSafe
public abstract class HttpRequestBase
extends AbstractHttpMessage
implements HttpUriRequest,
AbortableHttpRequest,
Cloneable {
    private Lock abortLock = new ReentrantLock();
    private boolean aborted;
    private URI uri;
    private ClientConnectionRequest connRequest;
    private ConnectionReleaseTrigger releaseTrigger;

    public abstract String getMethod();

    public ProtocolVersion getProtocolVersion() {
        return HttpProtocolParams.getVersion(this.getParams());
    }

    public URI getURI() {
        return this.uri;
    }

    public RequestLine getRequestLine() {
        String method = this.getMethod();
        ProtocolVersion ver = this.getProtocolVersion();
        URI uri = this.getURI();
        String uritext = null;
        if (uri != null) {
            uritext = uri.toASCIIString();
        }
        if (uritext == null || uritext.length() == 0) {
            uritext = "/";
        }
        return new BasicRequestLine(method, uritext, ver);
    }

    public void setURI(URI uri) {
        this.uri = uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionRequest(ClientConnectionRequest connRequest) throws IOException {
        this.abortLock.lock();
        try {
            if (this.aborted) {
                throw new IOException("Request already aborted");
            }
            this.releaseTrigger = null;
            this.connRequest = connRequest;
        }
        finally {
            this.abortLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReleaseTrigger(ConnectionReleaseTrigger releaseTrigger) throws IOException {
        this.abortLock.lock();
        try {
            if (this.aborted) {
                throw new IOException("Request already aborted");
            }
            this.connRequest = null;
            this.releaseTrigger = releaseTrigger;
        }
        finally {
            this.abortLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        ConnectionReleaseTrigger localTrigger;
        ClientConnectionRequest localRequest;
        this.abortLock.lock();
        try {
            if (this.aborted) {
                return;
            }
            this.aborted = true;
            localRequest = this.connRequest;
            localTrigger = this.releaseTrigger;
        }
        finally {
            this.abortLock.unlock();
        }
        if (localRequest != null) {
            localRequest.abortRequest();
        }
        if (localTrigger != null) {
            try {
                localTrigger.abortConnection();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public Object clone() throws CloneNotSupportedException {
        HttpRequestBase clone = (HttpRequestBase)super.clone();
        clone.abortLock = new ReentrantLock();
        clone.aborted = false;
        clone.releaseTrigger = null;
        clone.connRequest = null;
        clone.headergroup = (HeaderGroup)CloneUtils.clone(this.headergroup);
        clone.params = (HttpParams)CloneUtils.clone(this.params);
        return clone;
    }
}

