/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.commons.httpclient.methods;

import com.google.appengine.repackaged.org.apache.commons.httpclient.Header;
import com.google.appengine.repackaged.org.apache.commons.httpclient.HttpConnection;
import com.google.appengine.repackaged.org.apache.commons.httpclient.HttpMethodBase;
import com.google.appengine.repackaged.org.apache.commons.httpclient.HttpState;
import com.google.appengine.repackaged.org.apache.commons.logging.Log;
import com.google.appengine.repackaged.org.apache.commons.logging.LogFactory;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class OptionsMethod
extends HttpMethodBase {
    private static final Log LOG = LogFactory.getLog(OptionsMethod.class);
    private Vector methodsAllowed = new Vector();

    public OptionsMethod() {
    }

    public OptionsMethod(String string) {
        super(string);
    }

    public String getName() {
        return "OPTIONS";
    }

    public boolean isAllowed(String string) {
        this.checkUsed();
        return this.methodsAllowed.contains(string);
    }

    public Enumeration getAllowedMethods() {
        this.checkUsed();
        return this.methodsAllowed.elements();
    }

    protected void processResponseHeaders(HttpState httpState, HttpConnection httpConnection) {
        LOG.trace("enter OptionsMethod.processResponseHeaders(HttpState, HttpConnection)");
        Header header = this.getResponseHeader("allow");
        if (header != null) {
            String string = header.getValue();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreElements()) {
                String string2 = stringTokenizer.nextToken().trim().toUpperCase();
                this.methodsAllowed.addElement(string2);
            }
        }
    }

    public boolean needContentLength() {
        return false;
    }
}

