/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.commons.httpclient.auth;

import com.google.appengine.repackaged.org.apache.commons.codec.binary.Base64;
import com.google.appengine.repackaged.org.apache.commons.httpclient.Credentials;
import com.google.appengine.repackaged.org.apache.commons.httpclient.HttpMethod;
import com.google.appengine.repackaged.org.apache.commons.httpclient.UsernamePasswordCredentials;
import com.google.appengine.repackaged.org.apache.commons.httpclient.auth.AuthenticationException;
import com.google.appengine.repackaged.org.apache.commons.httpclient.auth.InvalidCredentialsException;
import com.google.appengine.repackaged.org.apache.commons.httpclient.auth.MalformedChallengeException;
import com.google.appengine.repackaged.org.apache.commons.httpclient.auth.RFC2617Scheme;
import com.google.appengine.repackaged.org.apache.commons.httpclient.util.EncodingUtil;
import com.google.appengine.repackaged.org.apache.commons.logging.Log;
import com.google.appengine.repackaged.org.apache.commons.logging.LogFactory;

public class BasicScheme
extends RFC2617Scheme {
    private static final Log LOG = LogFactory.getLog(BasicScheme.class);
    private boolean complete;

    public BasicScheme() {
        this.complete = false;
    }

    public BasicScheme(String string) throws MalformedChallengeException {
        super(string);
        this.complete = true;
    }

    public String getSchemeName() {
        return "basic";
    }

    public void processChallenge(String string) throws MalformedChallengeException {
        super.processChallenge(string);
        this.complete = true;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public String authenticate(Credentials credentials, String string, String string2) throws AuthenticationException {
        LOG.trace("enter BasicScheme.authenticate(Credentials, String, String)");
        UsernamePasswordCredentials usernamePasswordCredentials = null;
        try {
            usernamePasswordCredentials = (UsernamePasswordCredentials)credentials;
        }
        catch (ClassCastException classCastException) {
            throw new InvalidCredentialsException("Credentials cannot be used for basic authentication: " + credentials.getClass().getName());
        }
        return BasicScheme.authenticate(usernamePasswordCredentials);
    }

    public boolean isConnectionBased() {
        return false;
    }

    public String authenticate(Credentials credentials, HttpMethod httpMethod) throws AuthenticationException {
        LOG.trace("enter BasicScheme.authenticate(Credentials, HttpMethod)");
        if (httpMethod == null) {
            throw new IllegalArgumentException("Method may not be null");
        }
        UsernamePasswordCredentials usernamePasswordCredentials = null;
        try {
            usernamePasswordCredentials = (UsernamePasswordCredentials)credentials;
        }
        catch (ClassCastException classCastException) {
            throw new InvalidCredentialsException("Credentials cannot be used for basic authentication: " + credentials.getClass().getName());
        }
        return BasicScheme.authenticate(usernamePasswordCredentials, httpMethod.getParams().getCredentialCharset());
    }

    public static String authenticate(UsernamePasswordCredentials usernamePasswordCredentials) {
        return BasicScheme.authenticate(usernamePasswordCredentials, "ISO-8859-1");
    }

    public static String authenticate(UsernamePasswordCredentials usernamePasswordCredentials, String string) {
        LOG.trace("enter BasicScheme.authenticate(UsernamePasswordCredentials, String)");
        if (usernamePasswordCredentials == null) {
            throw new IllegalArgumentException("Credentials may not be null");
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("charset may not be null or empty");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(usernamePasswordCredentials.getUserName());
        stringBuffer.append(":");
        stringBuffer.append(usernamePasswordCredentials.getPassword());
        return "Basic " + EncodingUtil.getAsciiString(Base64.encodeBase64(EncodingUtil.getBytes(stringBuffer.toString(), string)));
    }
}

