/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.socket.dev;

import com.google.appengine.api.socket.SocketServicePb;
import com.google.appengine.api.socket.dev.LocalSocket;
import com.google.appengine.api.socket.dev.LocalSocketService;
import com.google.appengine.api.socket.dev.SocketImplAccessor;
import com.google.appengine.api.socket.dev.SocketPermissions;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.net.ConnectException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicLong;

class LocalStreamSocket
extends LocalSocket {
    private static final InetAddress LOCAL_IPV4_ADDR = LocalStreamSocket.toInetAddress(new byte[]{0, 0, 0, 0});
    private static final InetAddress LOCAL_IPV6_ADDR = LocalStreamSocket.toInetAddress(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
    SocketImplAccessor socketImplAccessor = SocketImplAccessor.newSocketImplAccessor();

    LocalStreamSocket(LocalSocketService socketService) {
        super(socketService);
        try {
            this.socketImplAccessor.create(true);
        }
        catch (IOException e) {
            throw new ApiProxy.ApplicationException(SocketServicePb.RemoteSocketServiceError.ErrorCode.FAILURE.getValue(), "Socket create failed: " + e.getMessage());
        }
    }

    protected InetAddress toInetAddress(SocketServicePb.AddressPort addressPort) {
        try {
            return InetAddress.getByAddress(addressPort.getPackedAddressAsBytes());
        }
        catch (UnknownHostException e) {
            throw this.newAppExceptionAndClose(SocketServicePb.RemoteSocketServiceError.ErrorCode.FAILURE, "Unexpected UnknownHostException thrown: " + e.getMessage());
        }
    }

    static InetAddress toInetAddress(byte[] addr) {
        try {
            if (addr.length == 4) {
                return InetAddress.getByAddress(addr);
            }
            return Inet6Address.getByAddress(null, addr, null);
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("getByAddress(byte[]) should not fail.", e);
        }
    }

    SocketImplAccessor getImpl() {
        return this.socketImplAccessor;
    }

    @Override
    public IOException close() {
        this.socketService.removeSocket(this.getSocketDescriptor());
        if (this.socketImplAccessor != null) {
            try {
                this.socketImplAccessor.close();
            }
            catch (IOException e) {
                return e;
            }
        }
        return null;
    }

    @Override
    public SocketServicePb.BindReply bind(SocketServicePb.BindRequest request) {
        this.bind(request.getProxyExternalIp());
        return new SocketServicePb.BindReply();
    }

    protected InetAddress getLocalAddress() {
        InetAddress localAddr = null;
        try {
            localAddr = (InetAddress)this.getImpl().getOption(15);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (localAddr == null || localAddr.isAnyLocalAddress()) {
            localAddr = this.socketFamily == SocketServicePb.CreateSocketRequest.SocketFamily.IPv6 ? LOCAL_IPV6_ADDR : LOCAL_IPV4_ADDR;
        }
        return localAddr;
    }

    @Override
    public SocketServicePb.GetSocketNameReply getSocketName(SocketServicePb.GetSocketNameRequest request) {
        SocketServicePb.GetSocketNameReply response = new SocketServicePb.GetSocketNameReply();
        response.getMutableProxyExternalIp().setPackedAddressAsBytes(this.addrAsBytes(this.getLocalAddress())).setPort(this.getImpl().getLocalPort());
        return response;
    }

    @Override
    public SocketServicePb.GetPeerNameReply getPeerName(SocketServicePb.GetPeerNameRequest request) {
        SocketServicePb.GetPeerNameReply response = new SocketServicePb.GetPeerNameReply();
        response.getMutablePeerIp().setPackedAddressAsBytes(this.addrAsBytes(this.getImpl().getInetAddress())).setPort(this.getImpl().getPort());
        return response;
    }

    @Override
    public SocketServicePb.SetSocketOptionsReply setSocketOptions(SocketServicePb.SetSocketOptionsRequest request) {
        SocketPermissions.getSocketPermissions().checkSetSocketOpt();
        throw new ApiProxy.ApplicationException(SocketServicePb.RemoteSocketServiceError.ErrorCode.FAILURE.getValue(), "setSocketOptions: Not yet implemented");
    }

    @Override
    public SocketServicePb.GetSocketOptionsReply getSocketOptions(SocketServicePb.GetSocketOptionsRequest request) {
        throw new ApiProxy.ApplicationException(SocketServicePb.RemoteSocketServiceError.ErrorCode.FAILURE.getValue(), "getSocketOptions: Not yet implemented");
    }

    @Override
    public SocketServicePb.ConnectReply connect(SocketServicePb.ConnectRequest request) {
        double timeOutSeconds = request.hasTimeoutSeconds() ? request.getTimeoutSeconds() : 0.0;
        this.connect(request.getRemoteIp(), timeOutSeconds);
        return new SocketServicePb.ConnectReply();
    }

    @Override
    public SocketServicePb.ListenReply listen(SocketServicePb.ListenRequest request) {
        this.listen(request.getBacklog());
        return new SocketServicePb.ListenReply();
    }

    @Override
    public SocketServicePb.AcceptReply accept(SocketServicePb.AcceptRequest request) {
        SocketPermissions.getSocketPermissions().checkListen();
        LocalStreamSocket acceptingSocket = (LocalStreamSocket)this.socketService.newLocalSocket(true);
        try {
            this.fixTimeout(request.getTimeoutSeconds());
            this.getImpl().accept(acceptingSocket.getImpl());
        }
        catch (IOException e) {
            acceptingSocket.close();
            throw this.newAppExceptionAndClose(SocketServicePb.RemoteSocketServiceError.ErrorCode.FAILURE, "accept error: " + e.getMessage());
        }
        SocketServicePb.AcceptReply reply = new SocketServicePb.AcceptReply();
        reply.setNewSocketDescriptor(acceptingSocket.getSocketDescriptor());
        reply.setRemoteAddress(acceptingSocket.getPeerName(null).getPeerIp());
        return reply;
    }

    @Override
    public SocketServicePb.ShutDownReply shutDown(SocketServicePb.ShutDownRequest request) {
        try {
            switch (request.getHowEnum()) {
                case SOCKET_SHUT_RD: {
                    this.getImpl().shutdownInput();
                    break;
                }
                case SOCKET_SHUT_WR: {
                    this.getImpl().shutdownOutput();
                    break;
                }
                case SOCKET_SHUT_RDWR: {
                    this.getImpl().shutdownInput();
                    this.getImpl().shutdownOutput();
                }
            }
        }
        catch (IOException e) {
            throw this.newAppException(SocketServicePb.RemoteSocketServiceError.ErrorCode.SYSTEM_ERROR, e.getMessage());
        }
        return new SocketServicePb.ShutDownReply();
    }

    @Override
    public SocketServicePb.CloseReply close(SocketServicePb.CloseRequest request) {
        IOException e = this.close();
        if (e != null) {
            throw new ApiProxy.ApplicationException(SocketServicePb.RemoteSocketServiceError.ErrorCode.FAILURE.getValue(), "close error: " + e.getMessage());
        }
        return new SocketServicePb.CloseReply();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketServicePb.SendReply send(SocketServicePb.SendRequest request) {
        byte[] data = request.getDataAsBytes();
        AtomicLong atomicLong = this.streamSendOffset;
        synchronized (atomicLong) {
            if (this.streamSendOffset.getAndAdd(data.length) != request.getStreamOffset()) {
                throw this.newAppException(SocketServicePb.RemoteSocketServiceError.ErrorCode.SYSTEM_ERROR, "Write stream offset mismatch.");
            }
            try {
                this.fixTimeout(request.getTimeoutSeconds());
                this.getImpl().getOutputStream().write(data);
            }
            catch (SocketTimeoutException e) {
                throw this.newSystemAppException("Resource temporarily unavailable", SocketServicePb.RemoteSocketServiceError.SystemError.SYS_EAGAIN);
            }
            catch (IOException e) {
                this.streamSendOffset.addAndGet(-data.length);
                throw this.newAppException(SocketServicePb.RemoteSocketServiceError.ErrorCode.SYSTEM_ERROR, e.getMessage());
            }
        }
        SocketServicePb.SendReply response = new SocketServicePb.SendReply();
        response.setDataSent(data.length);
        return response;
    }

    @Override
    public SocketServicePb.ReceiveReply receive(SocketServicePb.ReceiveRequest request) {
        byte[] resultBuffer;
        int size;
        byte[] buffer = new byte[request.getDataSize()];
        try {
            this.fixTimeout(request.getTimeoutSeconds());
            size = this.getImpl().getInputStream().read(buffer);
        }
        catch (SocketTimeoutException e) {
            throw this.newSystemAppException("Resource temporarily unavailable", SocketServicePb.RemoteSocketServiceError.SystemError.SYS_EAGAIN);
        }
        catch (IOException e) {
            throw this.newAppException(SocketServicePb.RemoteSocketServiceError.ErrorCode.SYSTEM_ERROR, e.getMessage());
        }
        if (size == buffer.length) {
            byte[] e = buffer;
        }
        if (size < 0) {
            resultBuffer = new byte[]{};
            size = 0;
        } else {
            resultBuffer = new byte[size];
            System.arraycopy(buffer, 0, resultBuffer, 0, size);
        }
        SocketServicePb.ReceiveReply response = new SocketServicePb.ReceiveReply();
        response.setDataAsBytes(resultBuffer);
        response.setStreamOffset(this.streamReceiveOffset.getAndAdd(size));
        return response;
    }

    @Override
    public SocketServicePb.CreateSocketReply createSocket(SocketServicePb.CreateSocketRequest request) {
        SocketServicePb.CreateSocketReply response = new SocketServicePb.CreateSocketReply();
        response.setSocketDescriptor(this.getSocketDescriptor());
        this.socketFamily = request.getFamilyEnum();
        if (request.hasProxyExternalIp()) {
            this.bind(request.getProxyExternalIp());
        }
        if (request.hasListenBacklog()) {
            this.listen(request.getListenBacklog());
        }
        if (request.hasRemoteIp()) {
            this.connect(request.getRemoteIp(), 0.0);
        }
        return response;
    }

    SocketAddress toSocketAddress(SocketServicePb.AddressPort addressPort) {
        return new InetSocketAddress(this.toInetAddress(addressPort), addressPort.getPort());
    }

    private void connect(SocketServicePb.AddressPort remoteIp, double timeOutSeconds) {
        SocketPermissions.getSocketPermissions().checkConnect();
        try {
            this.getImpl().connect(this.toSocketAddress(remoteIp), (int)(timeOutSeconds * 1000.0));
        }
        catch (SocketTimeoutException e) {
            throw this.newSystemAppExceptionAndClose("connect error: " + e.getMessage(), SocketServicePb.RemoteSocketServiceError.SystemError.SYS_EINPROGRESS);
        }
        catch (ConnectException e) {
            throw this.newSystemAppExceptionAndClose("connect error: " + e.getMessage(), SocketServicePb.RemoteSocketServiceError.SystemError.SYS_ECONNREFUSED);
        }
        catch (IOException e) {
            throw this.newAppExceptionAndClose(SocketServicePb.RemoteSocketServiceError.ErrorCode.FAILURE, "connect error: " + e.getMessage());
        }
    }

    private ApiProxy.ApplicationException newSystemAppExceptionAndClose(String message, SocketServicePb.RemoteSocketServiceError.SystemError errno) {
        this.close();
        return this.newSystemAppException(message, errno);
    }

    private ApiProxy.ApplicationException newSystemAppException(String message, SocketServicePb.RemoteSocketServiceError.SystemError errno) {
        SocketServicePb.RemoteSocketServiceError serviceError = new SocketServicePb.RemoteSocketServiceError();
        serviceError.setErrorDetail(message).setSystemError(errno.getValue());
        return this.newAppException(SocketServicePb.RemoteSocketServiceError.ErrorCode.SYSTEM_ERROR, serviceError.toFlatString());
    }

    private void listen(int backlog) {
        SocketPermissions.getSocketPermissions().checkBind();
        try {
            this.getImpl().listen(backlog);
        }
        catch (IOException e) {
            throw this.newAppExceptionAndClose(SocketServicePb.RemoteSocketServiceError.ErrorCode.FAILURE, "listen error: " + e.getMessage());
        }
    }

    private void bind(SocketServicePb.AddressPort proxyExternalIp) {
        SocketPermissions.getSocketPermissions().checkBind();
        try {
            this.getImpl().bind(this.toInetAddress(proxyExternalIp), proxyExternalIp.getPort());
        }
        catch (IOException e) {
            throw this.newAppExceptionAndClose(SocketServicePb.RemoteSocketServiceError.ErrorCode.FAILURE, "bind error: " + e.getMessage());
        }
    }

    void fixTimeout(double secs) {
        try {
            if (secs < 0.0) {
                secs = 0.0;
            }
            this.getImpl().setOption(4102, (int)(secs * 1000.0));
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }
}

