/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.dev;

import com.google.appengine.api.search.dev.EvaluationException;
import com.google.appengine.api.search.dev.Expression;
import com.google.apphosting.api.search.DocumentPb;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.Document;

abstract class NumericExpression
extends Expression {
    NumericExpression() {
    }

    @Override
    public DocumentPb.FieldValue eval(Document doc) throws EvaluationException {
        return NumericExpression.makeValue(DocumentPb.FieldValue.ContentType.NUMBER, Double.toString(this.evalDouble(doc)));
    }

    public abstract double evalDouble(Document var1) throws EvaluationException;

    @Override
    public List<Expression.Sorter> getSorters(int sign, double defaultValueNumeric, String defaultValueText) {
        ArrayList<Expression.Sorter> sorters = new ArrayList<Expression.Sorter>(1);
        sorters.add(this.getNumericSorter(sign, defaultValueNumeric));
        return sorters;
    }

    public Expression.Sorter getNumericSorter(final int sign, final double defaultValueNumeric) {
        return new Expression.Sorter(){

            @Override
            public Object eval(Document doc) {
                try {
                    return NumericExpression.this.evalDouble(doc);
                }
                catch (EvaluationException e) {
                    return defaultValueNumeric;
                }
            }

            @Override
            public int compare(Object left, Object right) {
                Double leftDouble = (Double)left;
                Double rightDouble = (Double)right;
                return sign * leftDouble.compareTo(rightDouble);
            }
        };
    }
}

