/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore.dev;

import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.dev.HighRepJobPolicy;
import com.google.apphosting.datastore.DatastoreV3Pb;

abstract class LocalDatastoreJob {
    final HighRepJobPolicy jobPolicy;
    final Key entityGroup;
    boolean newJob = true;
    boolean applied = false;

    LocalDatastoreJob(HighRepJobPolicy jobPolicy, Key entityGroup) {
        if (jobPolicy == null) {
            throw new NullPointerException("jobPolicy cannot be null");
        }
        this.jobPolicy = jobPolicy;
        if (entityGroup == null) {
            throw new NullPointerException("entityGroup cannot be null");
        }
        this.entityGroup = entityGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final TryApplyResult tryApply() {
        try {
            if (this.newJob) {
                if (this.jobPolicy.shouldApplyNewJob(this.entityGroup)) {
                    TryApplyResult tryApplyResult = new TryApplyResult(true, this.apply());
                    return tryApplyResult;
                }
            } else if (this.jobPolicy.shouldRollForwardExistingJob(this.entityGroup)) {
                TryApplyResult tryApplyResult = new TryApplyResult(true, this.apply());
                return tryApplyResult;
            }
            TryApplyResult tryApplyResult = new TryApplyResult(false, this.calculateJobCost());
            return tryApplyResult;
        }
        finally {
            this.newJob = false;
        }
    }

    final DatastoreV3Pb.Cost apply() {
        if (this.applied) {
            throw new IllegalStateException(String.format("Job on entity group %s was already applied.", this.entityGroup));
        }
        this.applied = true;
        return this.applyInternal();
    }

    abstract DatastoreV3Pb.Cost applyInternal();

    abstract DatastoreV3Pb.Cost calculateJobCost();

    static class TryApplyResult {
        final boolean applied;
        final DatastoreV3Pb.Cost cost;

        TryApplyResult(boolean applied, DatastoreV3Pb.Cost cost) {
            this.applied = applied;
            this.cost = cost;
        }
    }
}

