/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf.bridge;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.cache.Cache;
import com.google.appengine.repackaged.com.google.common.cache.CacheBuilder;
import com.google.appengine.repackaged.com.google.common.cache.CacheBuilderSpec;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolDB;
import com.google.appengine.repackaged.com.google.io.protocol.proto.ProtocolDescriptor;
import com.google.appengine.repackaged.com.google.protobuf.DescriptorProtos;
import com.google.appengine.repackaged.com.google.protobuf.Descriptors;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistry;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistryLite;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protos.proto2.bridge.MessageSet;
import com.google.appengine.repackaged.com.google.protos.proto2.bridge.MessageSetProtos;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class DescriptorUpgrader {
    private static final Logger logger = Logger.getLogger(DescriptorUpgrader.class.getCanonicalName());
    private static final String PROTO2_MESSAGESET_NAME = MessageSet.getDescriptor().getFullName();
    private final ProtocolDB db;
    private final Options options;
    private final Cache<String, Descriptors.FileDescriptor> fileDescriptors;
    private final Cache<String, Descriptors.Descriptor> descriptors;

    public DescriptorUpgrader(ProtocolDB db, Options options) {
        this.db = db;
        this.options = options;
        this.fileDescriptors = CacheBuilder.from(options.cacheBuilderSpec).build();
        this.descriptors = CacheBuilder.from(options.cacheBuilderSpec).build();
    }

    public DescriptorUpgrader(ProtocolDB db) {
        this(db, new Options());
    }

    @Nullable
    public Descriptors.Descriptor upgradeMessageType(String typeName) throws Descriptors.DescriptorValidationException {
        Descriptors.Descriptor existing = this.descriptors.getIfPresent(typeName);
        if (existing != null) {
            return existing;
        }
        ProtocolDescriptor proto1 = this.db.find(typeName);
        if (proto1 == null) {
            return null;
        }
        this.upgradeFile(proto1.getFilename());
        return this.descriptors.getIfPresent(typeName);
    }

    public Descriptors.FileDescriptor upgradeFile(String fileName) throws Descriptors.DescriptorValidationException {
        Descriptors.FileDescriptor existing = this.fileDescriptors.getIfPresent(fileName);
        if (existing != null) {
            return existing;
        }
        Set<String> content = this.db.findByFileName(fileName);
        this.addMessageSetIfNecessary(content);
        DescriptorProtos.FileDescriptorProto fileProto = this.buildFileDescriptorProto(fileName, content);
        Descriptors.FileDescriptor upgradedFile = Descriptors.FileDescriptor.buildFrom(fileProto, this.fetchDependencies(fileProto));
        this.addFile(upgradedFile);
        return upgradedFile;
    }

    private void addFile(Descriptors.FileDescriptor file) {
        this.fileDescriptors.put(file.getName(), file);
        for (Descriptors.Descriptor type : file.getMessageTypes()) {
            this.addDescriptor(type);
        }
    }

    private void addDescriptor(Descriptors.Descriptor type) {
        this.descriptors.put(type.getFullName(), type);
        for (Descriptors.Descriptor nested : type.getNestedTypes()) {
            this.addNestedDescriptor(type.getFullName() + "_", nested);
        }
    }

    private void addNestedDescriptor(String typePrefix, Descriptors.Descriptor type) {
        String fullName = typePrefix + type.getName();
        this.descriptors.put(fullName, type);
        this.descriptors.put(type.getFullName(), type);
        String prefix = fullName + "_";
        for (Descriptors.Descriptor nested : type.getNestedTypes()) {
            this.addNestedDescriptor(prefix, nested);
        }
    }

    private Descriptors.FileDescriptor[] fetchDependencies(DescriptorProtos.FileDescriptorProto fileProto) throws Descriptors.DescriptorValidationException {
        Descriptors.FileDescriptor[] dependencies = new Descriptors.FileDescriptor[fileProto.getDependencyCount()];
        for (int i = 0; i < dependencies.length; ++i) {
            String dependencyName = fileProto.getDependency(i);
            dependencies[i] = this.upgradeFile(dependencyName);
        }
        return dependencies;
    }

    private DescriptorProtos.FileDescriptorProto buildFileDescriptorProto(String fileName, Set<String> content) {
        DescriptorProtos.FileDescriptorProto.Builder builder = DescriptorProtos.FileDescriptorProto.newBuilder();
        builder.setName(fileName);
        if (!content.isEmpty()) {
            DescriptorProtos.FileDescriptorProto proto2File;
            if (this.options.useProto2TypeTunneling && (proto2File = this.tryExtractTunneledProto2(content)) != null) {
                return proto2File;
            }
            String packageName = this.extractPackage(content.iterator().next());
            if (packageName != null) {
                builder.setPackage(packageName);
            }
        }
        builder.setOptions(DescriptorProtos.FileOptions.newBuilder().setJavaApiVersion(1).build());
        HashSet<String> foreignTypes = Sets.newHashSet();
        for (String messageTypeName : content) {
            MessageTypeUpgrader messageTypeUpgrader = new MessageTypeUpgrader(this.db.find(messageTypeName), this.options.forceByteStrings);
            builder.addMessageType(messageTypeUpgrader.upgrade(foreignTypes));
        }
        HashSet<String> dependencies = Sets.newHashSet();
        for (String foreignTypeName : foreignTypes) {
            Descriptors.Descriptor proto2 = this.descriptors.getIfPresent(foreignTypeName);
            if (proto2 != null) {
                dependencies.add(proto2.getFile().getName());
                continue;
            }
            ProtocolDescriptor proto1 = this.db.find(foreignTypeName);
            if (proto1 == null) continue;
            dependencies.add(proto1.getFilename());
        }
        dependencies.remove(fileName);
        builder.addAllDependency(dependencies);
        return builder.build();
    }

    @Nullable
    private String extractPackage(String typeName) {
        int lastDot = typeName.lastIndexOf(46);
        if (lastDot == -1) {
            return null;
        }
        return typeName.substring(0, lastDot);
    }

    @Nullable
    private DescriptorProtos.FileDescriptorProto tryExtractTunneledProto2(Set<String> types) {
        ProtocolDescriptor master;
        ProtocolDescriptor message = this.db.find(types.iterator().next());
        if (message.hasProto2FileDescriptor()) {
            master = message;
        } else if (message.hasProto2FileMaster()) {
            master = this.db.find(message.getProto2FileMaster());
        } else {
            return null;
        }
        try {
            return DescriptorProtos.FileDescriptorProto.parseFrom(master.getProto2FileDescriptorAsBytes(), (ExtensionRegistryLite)this.options.extensionRegistry);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalStateException(String.format("ProtocolDB contained invalid descriptor for proto2_file_descriptor in message type %s in file %s", master.getProtoName(), master.getFilename()), e);
        }
    }

    private void addMessageSetIfNecessary(Set<String> types) {
        for (String messageTypeName : types) {
            ProtocolDescriptor source = this.db.find(messageTypeName);
            for (ProtocolDescriptor.Tag tag : source.tags()) {
                String foreign;
                DescriptorProtos.FieldDescriptorProto.Type type = DescriptorProtos.FieldDescriptorProto.Type.forNumber(tag.getDeclaredType());
                if (type != DescriptorProtos.FieldDescriptorProto.Type.TYPE_MESSAGE || !"MessageSet".equals(foreign = tag.hasForeignProtoName() ? tag.getForeignProtoName() : tag.getForeign())) continue;
                this.addFile(MessageSetProtos.getDescriptor());
                return;
            }
        }
    }

    private static class MessageTypeUpgrader {
        private final ProtocolDescriptor source;
        private final String currentTypeName;
        private final DescriptorProtos.DescriptorProto.Builder messageBuilder;
        private final DescriptorProtos.DescriptorProto.Builder[] groupBuilders;
        private final boolean forceByteStrings;

        MessageTypeUpgrader(ProtocolDescriptor source, boolean forceByteStrings) {
            Preconditions.checkNotNull(source, "source");
            this.source = source;
            this.forceByteStrings = forceByteStrings;
            this.currentTypeName = source.hasProtoName() ? source.getProtoName() : source.getName();
            this.messageBuilder = DescriptorProtos.DescriptorProto.newBuilder();
            this.groupBuilders = new DescriptorProtos.DescriptorProto.Builder[source.tagSize()];
        }

        DescriptorProtos.DescriptorProto upgrade(Set<String> foreignTypes) {
            this.messageBuilder.setName(MessageTypeUpgrader.lastPathElement(this.currentTypeName));
            for (int i = 0; i < this.groupBuilders.length; ++i) {
                this.groupBuilders[i] = this.createGroupBuilder(this.source.getTag(i));
            }
            Set<String> tagNames = MessageTypeUpgrader.buildTagNameSet(this.source);
            String[] enumNames = new String[this.source.enumTypeSize()];
            for (int i = 0; i < enumNames.length; ++i) {
                ProtocolDescriptor.EnumType enumType = this.source.getEnumType(i);
                DescriptorProtos.EnumDescriptorProto proto = this.addEnum(enumType, tagNames);
                String enumName = proto.getName();
                if (enumType.hasParent()) {
                    enumName = this.source.getTag(enumType.getParent()).getName() + "." + enumName;
                }
                enumNames[i] = enumName;
            }
            for (ProtocolDescriptor.Tag tag : this.source.tags()) {
                this.addField(tag, foreignTypes, enumNames);
            }
            for (int i = this.groupBuilders.length - 1; i >= 0; --i) {
                DescriptorProtos.DescriptorProto.Builder groupBuilder = this.groupBuilders[i];
                if (groupBuilder == null) continue;
                this.getParent(this.source.getTag(i).getParent()).addNestedType(groupBuilder);
            }
            return this.messageBuilder.build();
        }

        private static Set<String> buildTagNameSet(ProtocolDescriptor source) {
            ImmutableSet.Builder tagNames = ImmutableSet.builder();
            for (ProtocolDescriptor.Tag tag : source.tags()) {
                tagNames.add(tag.getName());
            }
            return tagNames.build();
        }

        @Nullable
        private DescriptorProtos.DescriptorProto.Builder createGroupBuilder(ProtocolDescriptor.Tag tag) {
            if (tag.getDeclaredType() != ProtocolDescriptor.DeclaredType.TYPE_GROUP.getValue()) {
                return null;
            }
            return DescriptorProtos.DescriptorProto.newBuilder().setName(MessageTypeUpgrader.lastPathElement(tag.getName()));
        }

        private DescriptorProtos.DescriptorProto.Builder getParent(int groupIndex) {
            if (groupIndex == -1) {
                return this.messageBuilder;
            }
            return this.groupBuilders[groupIndex];
        }

        private DescriptorProtos.EnumDescriptorProto addEnum(ProtocolDescriptor.EnumType type, Set<String> tagNames) {
            DescriptorProtos.EnumDescriptorProto.Builder enumBuilder = DescriptorProtos.EnumDescriptorProto.newBuilder();
            String name = MessageTypeUpgrader.lastPathElement(type.getName());
            if (tagNames.contains(type.getName())) {
                logger.logp(Level.WARNING, "com.google.appengine.repackaged.com.google.protobuf.bridge.DescriptorUpgrader$MessageTypeUpgrader", "addEnum", "In .proto file \"" + this.source.getFilename() + "\":  Type \"" + this.source.getName() + "\" contains both a field and an enum type named \"" + name + "\".  Why would someone give the same name to both a type and a field?  It is pure coincidence that this even works in C++, Java, and Python.  You should probably fix it before it breaks something.");
                name = name + "_WARNING_ConflictsWithAFieldName";
            }
            enumBuilder.setName(name);
            for (ProtocolDescriptor.EnumTypeTag tag : type.tags()) {
                enumBuilder.addValue(DescriptorProtos.EnumValueDescriptorProto.newBuilder().setName(tag.getName()).setNumber(tag.getValue()));
            }
            DescriptorProtos.EnumDescriptorProto proto = enumBuilder.build();
            this.getParent(type.hasParent() ? type.getParent() : -1).addEnumType(proto);
            return proto;
        }

        private void addField(ProtocolDescriptor.Tag tag, Set<String> foreignTypes, String[] enumNames) {
            DescriptorProtos.FieldDescriptorProto.Builder builder = DescriptorProtos.FieldDescriptorProto.newBuilder();
            builder.setName(MessageTypeUpgrader.lastPathElement(tag.getName()));
            builder.setNumber(tag.getNumber());
            builder.setLabel(DescriptorProtos.FieldDescriptorProto.Label.forNumber(tag.getLabel()));
            String defaultValue = tag.hasDefaultValue() ? tag.getDefaultValue() : null;
            DescriptorProtos.FieldDescriptorProto.Type type = DescriptorProtos.FieldDescriptorProto.Type.forNumber(tag.getDeclaredType());
            switch (type) {
                case TYPE_GROUP: {
                    builder.setName(builder.getName().toLowerCase());
                    builder.setTypeName("." + this.currentTypeName + "." + tag.getName());
                    break;
                }
                case TYPE_MESSAGE: {
                    String foreign;
                    String string = foreign = tag.hasForeignProtoName() ? tag.getForeignProtoName() : tag.getForeign();
                    if ("RawMessage".equals(foreign)) {
                        type = DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES;
                        break;
                    }
                    if ("MessageSet".equals(foreign)) {
                        foreign = PROTO2_MESSAGESET_NAME;
                    }
                    builder.setTypeName("." + foreign);
                    foreignTypes.add(foreign);
                    break;
                }
                case TYPE_INT32: {
                    if (!tag.hasEnumId()) break;
                    type = DescriptorProtos.FieldDescriptorProto.Type.TYPE_ENUM;
                    builder.setTypeName("." + this.currentTypeName + "." + enumNames[tag.getEnumId()]);
                    if (defaultValue == null) break;
                    defaultValue = this.extractDefaultEnumValue(tag);
                    break;
                }
                case TYPE_BOOL: {
                    if (defaultValue == null) break;
                    defaultValue = "true".equals(defaultValue) || "1".equals(defaultValue) ? "true" : "false";
                    break;
                }
                case TYPE_STRING: {
                    if (!this.forceByteStrings) break;
                    type = DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES;
                    break;
                }
            }
            builder.setType(type);
            if (defaultValue != null) {
                builder.setDefaultValue(defaultValue);
            }
            if (tag.optionSize() > 0 || tag.isDeprecated()) {
                DescriptorProtos.FieldOptions.Builder fieldOptions = DescriptorProtos.FieldOptions.newBuilder();
                if (tag.isDeprecated()) {
                    fieldOptions.setDeprecated(true);
                }
                for (ProtocolDescriptor.TagOption tagOption : tag.options()) {
                    DescriptorProtos.FieldOptions.UpgradedOption upgradedOption = DescriptorProtos.FieldOptions.UpgradedOption.newBuilder().setName(tagOption.getName()).setValue(tagOption.getValue()).build();
                    fieldOptions.addUpgradedOption(upgradedOption);
                }
                builder.setOptions(fieldOptions);
            }
            this.getParent(tag.getParent()).addField(builder);
        }

        private String extractDefaultEnumValue(ProtocolDescriptor.Tag tag) {
            int defaultValueAsInt;
            String defaultValue = tag.getDefaultValue();
            try {
                defaultValueAsInt = Integer.parseInt(defaultValue);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
            ProtocolDescriptor.EnumType enumType = this.source.getEnumType(tag.getEnumId());
            for (ProtocolDescriptor.EnumTypeTag enumValue : enumType.tags()) {
                if (defaultValueAsInt != enumValue.getValue()) continue;
                return enumValue.getName();
            }
            return defaultValue;
        }

        private static String lastPathElement(String path) {
            int lastDotPosition = path.lastIndexOf(46);
            if (lastDotPosition == -1) {
                return path;
            }
            return path.substring(lastDotPosition + 1);
        }
    }

    public static class Options {
        private boolean forceByteStrings = false;
        private CacheBuilderSpec cacheBuilderSpec = CacheBuilderSpec.parse("concurrencyLevel=1");
        private boolean useProto2TypeTunneling = false;
        private ExtensionRegistry extensionRegistry = ExtensionRegistry.newInstance();

        public Options setForceByteStrings(boolean forceByteStrings) {
            this.forceByteStrings = forceByteStrings;
            return this;
        }

        public Options setUseProto2TypeTunneling(boolean useProto2TypeTunneling) {
            this.useProto2TypeTunneling = useProto2TypeTunneling;
            return this;
        }

        public Options setCacheBuilderSpec(CacheBuilderSpec spec) {
            this.cacheBuilderSpec = spec;
            return this;
        }

        public Options addExtensionRegistryForProto2TypeTunneling(ExtensionRegistry extensionRegistry) {
            this.extensionRegistry = ExtensionRegistry.combine(ImmutableList.of(this.extensionRegistry, extensionRegistry));
            return this;
        }
    }
}

