/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.io.protocol;

import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.Interner;
import com.google.appengine.repackaged.com.google.common.collect.Interners;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.io.protocol.ProtoString;
import com.google.appengine.repackaged.com.google.io.protocol.Protocol;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessageEnum;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSource;
import com.google.appengine.repackaged.com.google.io.protocol.UninterpretedTags;
import com.google.appengine.repackaged.com.google.protobuf.CodedInputStream;
import com.google.appengine.repackaged.com.google.protobuf.Descriptors;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.appengine.repackaged.com.google.protobuf.MutableMessage;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class ProtocolSupport {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    public static final float[] EMPTY_FLOAT_ARRAY = new float[0];
    public static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    public static final ProtoString EMPTY_PROTO_STRING = new ProtoString(EMPTY_BYTE_ARRAY);
    public static final String UNINTERPRETED_TAGS_FIELD = "uninterpreted";
    private static final Interner<String> STRING_INTERNER = Interners.newWeakInterner();
    private static final int ENSURE_CAPACITY_EXTRA = 10;

    public static String internString(String s) {
        Preconditions.checkNotNull(s);
        return STRING_INTERNER.intern(s);
    }

    public static <T> T unsupportedOperation() {
        throw new UnsupportedOperationException("Modifying immutable object");
    }

    public static int hashCode(boolean b) {
        return b ? 1 : 0;
    }

    public static int hashCode(int i) {
        return i;
    }

    public static int hashCode(long l) {
        return (int)(l + (l >>> 32));
    }

    public static int hashCode(float f) {
        return Float.floatToIntBits(f);
    }

    public static int hashCode(double d) {
        long l = Double.doubleToLongBits(d);
        return (int)(l + (l >>> 32));
    }

    public static int hashCode(ProtocolMessageEnum e) {
        return e.getValue();
    }

    public static int hashCode(List<? extends ProtocolMessageEnum> enumList) {
        int hash = 1;
        for (ProtocolMessageEnum protocolMessageEnum : enumList) {
            hash = 31 * hash + ProtocolSupport.hashCode(protocolMessageEnum);
        }
        return hash;
    }

    public static <T> T[] growArray(T[] array) {
        int newLength = Math.max(4, array.length * 2);
        Class<?> newType = array.getClass();
        Object[] copy = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(array, 0, copy, 0, Math.min(array.length, newLength));
        Object[] arr = copy;
        return arr;
    }

    public static boolean[] growArray(boolean[] array) {
        int newLength = Math.max(4, array.length * 2);
        boolean[] copy = new boolean[newLength];
        System.arraycopy(array, 0, copy, 0, Math.min(array.length, newLength));
        return copy;
    }

    public static int[] growArray(int[] array) {
        int newLength = Math.max(4, array.length * 2);
        int[] copy = new int[newLength];
        System.arraycopy(array, 0, copy, 0, Math.min(array.length, newLength));
        return copy;
    }

    public static long[] growArray(long[] array) {
        int newLength = Math.max(4, array.length * 2);
        long[] copy = new long[newLength];
        System.arraycopy(array, 0, copy, 0, Math.min(array.length, newLength));
        return copy;
    }

    public static float[] growArray(float[] array) {
        int newLength = Math.max(4, array.length * 2);
        float[] copy = new float[newLength];
        System.arraycopy(array, 0, copy, 0, Math.min(array.length, newLength));
        return copy;
    }

    public static double[] growArray(double[] array) {
        int newLength = Math.max(4, array.length * 2);
        double[] copy = new double[newLength];
        System.arraycopy(array, 0, copy, 0, Math.min(array.length, newLength));
        return copy;
    }

    public static boolean[] ensureCapacity(boolean[] array, int size) {
        if (size > array.length) {
            return Arrays.copyOf(array, size + 10);
        }
        return array;
    }

    public static int[] ensureCapacity(int[] array, int size) {
        if (size > array.length) {
            return Arrays.copyOf(array, size + 10);
        }
        return array;
    }

    public static long[] ensureCapacity(long[] array, int size) {
        if (size > array.length) {
            return Arrays.copyOf(array, size + 10);
        }
        return array;
    }

    public static float[] ensureCapacity(float[] array, int size) {
        if (size > array.length) {
            return Arrays.copyOf(array, size + 10);
        }
        return array;
    }

    public static double[] ensureCapacity(double[] array, int size) {
        if (size > array.length) {
            return Arrays.copyOf(array, size + 10);
        }
        return array;
    }

    public static List<Integer> asList(final int[] array, final int start, final int end) {
        return new AbstractList<Integer>(){
            private int listSize;
            {
                this.listSize = end - start;
            }

            @Override
            public int size() {
                return this.listSize;
            }

            @Override
            public Integer get(int i) {
                if (i < 0 || i >= this.listSize) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                return array[i + start];
            }
        };
    }

    public static List<Long> asList(final long[] array, final int start, final int end) {
        return new AbstractList<Long>(){
            private int listSize;
            {
                this.listSize = end - start;
            }

            @Override
            public int size() {
                return this.listSize;
            }

            @Override
            public Long get(int i) {
                if (i < 0 || i >= this.listSize) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                return array[i + start];
            }
        };
    }

    public static List<Float> asList(final float[] array, final int start, final int end) {
        return new AbstractList<Float>(){
            private int listSize;
            {
                this.listSize = end - start;
            }

            @Override
            public int size() {
                return this.listSize;
            }

            @Override
            public Float get(int i) {
                if (i < 0 || i >= this.listSize) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                return Float.valueOf(array[i + start]);
            }
        };
    }

    public static List<Double> asList(final double[] array, final int start, final int end) {
        return new AbstractList<Double>(){
            private int listSize;
            {
                this.listSize = end - start;
            }

            @Override
            public int size() {
                return this.listSize;
            }

            @Override
            public Double get(int i) {
                if (i < 0 || i >= this.listSize) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                return array[i + start];
            }
        };
    }

    public static List<Boolean> asList(final boolean[] array, final int start, final int end) {
        return new AbstractList<Boolean>(){
            private int listSize;
            {
                this.listSize = end - start;
            }

            @Override
            public int size() {
                return this.listSize;
            }

            @Override
            public Boolean get(int i) {
                if (i < 0 || i >= this.listSize) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                return array[i + start];
            }
        };
    }

    public static Iterator<String> byteArrayToUnicodeIterator(List<byte[]> data) {
        return ByteArrayToUnicodeFunction.getInstance().asList(data).iterator();
    }

    public static Iterator<String> byteArrayToUnicodeIterator(List<byte[]> data, Charset cs) {
        return ByteArrayToUnicodeFunction.getInstance(cs).asList(data).iterator();
    }

    public static <T> Iterator<T> emptyIterator() {
        return Collections.emptyIterator();
    }

    public static List<String> byteArrayToUnicodeList(List<byte[]> data) {
        return ByteArrayToUnicodeFunction.getInstance().asList(data);
    }

    public static List<String> byteArrayToUnicodeList(List<byte[]> data, Charset cs) {
        return ByteArrayToUnicodeFunction.getInstance(cs).asList(data);
    }

    public static byte[] toBytes(String str, Charset charset) {
        return str != null ? str.getBytes(charset) : null;
    }

    public static byte[] toBytesUtf8(String str) {
        return ProtocolSupport.toBytes(str, StandardCharsets.UTF_8);
    }

    public static String toString(byte[] data, Charset charset) {
        return data != null ? new String(data, charset) : null;
    }

    public static String toStringUtf8(byte[] data) {
        return data != null ? ProtocolSupport.toStringUtf8(data, 0, data.length) : null;
    }

    public static String toStringUtf8(byte[] data, int offset, int length) {
        return data == null ? null : (length == 0 ? "" : new String(data, offset, length, StandardCharsets.UTF_8));
    }

    public static <T extends ProtocolMessage> T newInstance(Class<T> clazz) {
        try {
            return (T)((ProtocolMessage)clazz.newInstance());
        }
        catch (InstantiationException e) {
            if (clazz == ProtocolMessage.class) {
                throw new IllegalArgumentException("ProtocolMessage.class cannot be instantiated");
            }
            throw new AssertionError((Object)("Protocol messages should always be instantiable (class: " + clazz.getCanonicalName() + ")"));
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)("Protocol messages constructors should always be public (class: " + clazz.getCanonicalName() + ")"));
        }
    }

    public static UninterpretedTags getUninterpreted(ProtocolMessage<?> pb) {
        if (pb == null) {
            return null;
        }
        Class<?> clazz = pb.getClass();
        try {
            Field utagsField = clazz.getDeclaredField(UNINTERPRETED_TAGS_FIELD);
            utagsField.setAccessible(true);
            UninterpretedTags utags = (UninterpretedTags)utagsField.get(pb);
            if (utags == null) {
                return null;
            }
            UninterpretedTags utagsClone = new UninterpretedTags();
            for (Map.Entry message : utags.entries()) {
                utagsClone.put(Integer.valueOf((Integer)message.getKey()), (byte[])((byte[])message.getValue()).clone());
            }
            return utagsClone;
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            return new UninterpretedTags();
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setUninterpreted(ProtocolMessage<?> pb, UninterpretedTags uninterpreted) {
        try {
            Class<?> clazz = pb.getClass();
            Field utagsField = clazz.getDeclaredField(UNINTERPRETED_TAGS_FIELD);
            utagsField.setAccessible(true);
            utagsField.set(pb, uninterpreted);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> List<T> unmodifiableList(List<T> list) {
        if (list == null) {
            return ImmutableList.of();
        }
        return Collections.unmodifiableList(list);
    }

    public static boolean isProto2Message(Object object) {
        return object instanceof Message && !(object instanceof ProtocolMessage);
    }

    public static boolean isProto2MessageClass(Class<?> clazz) {
        return Message.class.isAssignableFrom(clazz) && !ProtocolMessage.class.isAssignableFrom(clazz);
    }

    public static boolean isProto2ImmutableMessage(Object object) {
        return object instanceof Message && !(object instanceof MutableMessage);
    }

    public static boolean isProto2ImmutableMessageClass(Class<?> clazz) {
        return Message.class.isAssignableFrom(clazz) && !MutableMessage.class.isAssignableFrom(clazz);
    }

    public static boolean isProto2MutableMessage(Object object) {
        return object instanceof MutableMessage && !(object instanceof ProtocolMessage);
    }

    public static boolean isProto2MutableMessageClass(Class<?> clazz) {
        return MutableMessage.class.isAssignableFrom(clazz) && !ProtocolMessage.class.isAssignableFrom(clazz);
    }

    private static boolean compareMessageIgnoreUnknownFields(Object a, Object b) {
        if (a instanceof ProtocolMessage && b instanceof ProtocolMessage) {
            ProtocolMessage message1 = (ProtocolMessage)a;
            ProtocolMessage message2 = (ProtocolMessage)b;
            return message1.equalsIgnoreUninterpreted(message2);
        }
        MutableMessage message1 = (MutableMessage)a;
        MutableMessage message2 = (MutableMessage)b;
        return ProtocolSupport.compareMessage(message1, message2, true);
    }

    private static boolean compareBytes(Object a, Object b) {
        return Arrays.equals((byte[])a, (byte[])b);
    }

    public static boolean mergeProto2MutableMessage(MutableMessage message, ProtocolSource source) {
        if (!message.mergeFrom(source.array(), source.position(), source.remaining())) {
            return false;
        }
        source.skip(source.remaining());
        return true;
    }

    private static boolean compareFieldsIgnoreUnknownFields(Map<Descriptors.FieldDescriptor, Object> a, Map<Descriptors.FieldDescriptor, Object> b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (Descriptors.FieldDescriptor descriptor : a.keySet()) {
            int i;
            List list2;
            List list1;
            if (!b.containsKey(descriptor)) {
                return false;
            }
            Object value1 = a.get(descriptor);
            Object value2 = b.get(descriptor);
            if (descriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                if (descriptor.isRepeated()) {
                    list1 = (List)value1;
                    list2 = (List)value2;
                    if (list1.size() != list2.size()) {
                        return false;
                    }
                    for (i = 0; i < list1.size(); ++i) {
                        if (ProtocolSupport.compareMessageIgnoreUnknownFields(list1.get(i), list2.get(i))) continue;
                        return false;
                    }
                    continue;
                }
                if (ProtocolSupport.compareMessageIgnoreUnknownFields(value1, value2)) continue;
                return false;
            }
            if (descriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.BYTE_STRING) {
                if (descriptor.isRepeated()) {
                    list1 = (List)value1;
                    list2 = (List)value2;
                    if (list1.size() != list2.size()) {
                        return false;
                    }
                    for (i = 0; i < list1.size(); ++i) {
                        if (ProtocolSupport.compareBytes(list1.get(i), list2.get(i))) continue;
                        return false;
                    }
                    continue;
                }
                if (ProtocolSupport.compareBytes(value1, value2)) continue;
                return false;
            }
            if (value1.equals(value2)) continue;
            return false;
        }
        return true;
    }

    public static boolean compareMessage(MutableMessage a, MutableMessage b, boolean ignoreUnknownFields) {
        if (!ignoreUnknownFields) {
            return a.equals(b);
        }
        if (a == b) {
            return true;
        }
        if (a.getDescriptorForType() != b.getDescriptorForType()) {
            return false;
        }
        return ProtocolSupport.compareFieldsIgnoreUnknownFields(a.getAllFields(), b.getAllFields());
    }

    public static ProtocolSource readCodedInputToProtocolSource(CodedInputStream input) throws IOException {
        byte[] bytes;
        int messageSize = input.getBytesUntilLimit();
        if (messageSize == -1) {
            int pos = 0;
            bytes = new byte[1024];
            while (!input.isAtEnd()) {
                bytes[pos++] = input.readRawByte();
                if (pos != bytes.length) continue;
                byte[] oldBytes = bytes;
                bytes = new byte[oldBytes.length * 2];
                System.arraycopy(oldBytes, 0, bytes, 0, oldBytes.length);
            }
            messageSize = pos;
        } else {
            bytes = input.readRawBytes(messageSize);
        }
        return new ProtocolSource(bytes, 0, messageSize);
    }

    public static <T extends MessageLite> T getDefaultInstance(Class<T> cls) {
        try {
            return (T)((MessageLite)cls.getMethod("getDefaultInstance", new Class[0]).invoke(null, new Object[0]));
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)"Message getDefaultInstance() method should always be accessible!");
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Base type of message haven't getDefaultInstance() method!", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Failed invoking getDefaultInstance() method!", e);
        }
    }

    public static String stringAsUtf8String(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        return ProtocolSupport.toStringUtf8((byte[])value);
    }

    public static byte[] stringAsUtf8Bytes(Object value) {
        if (value instanceof String) {
            return ProtocolSupport.toBytesUtf8((String)value);
        }
        return (byte[])value;
    }

    public static int stringHashCode(Object value) {
        if (value instanceof String) {
            return Arrays.hashCode(ProtocolSupport.toBytesUtf8((String)value));
        }
        return Arrays.hashCode((byte[])value);
    }

    public static boolean stringEquals(Object value1, Object value2) {
        if (value1 instanceof String && value2 instanceof String) {
            return value1.equals(value2);
        }
        return Arrays.equals(ProtocolSupport.stringAsUtf8Bytes(value1), ProtocolSupport.stringAsUtf8Bytes(value2));
    }

    public static int stringEncodingSize(Object value) {
        if (value instanceof String) {
            return Protocol.stringSize(ProtocolSupport.toBytesUtf8((String)value).length);
        }
        return Protocol.stringSize(((byte[])value).length);
    }

    private ProtocolSupport() {
    }

    private static class ByteArrayToUnicodeFunction
    implements Function<byte[], String> {
        static final ByteArrayToUnicodeFunction defaultFunction = new ByteArrayToUnicodeFunction(StandardCharsets.UTF_8);
        private final Charset cs;

        static ByteArrayToUnicodeFunction getInstance() {
            return defaultFunction;
        }

        static ByteArrayToUnicodeFunction getInstance(Charset cs) {
            return new ByteArrayToUnicodeFunction(cs);
        }

        private ByteArrayToUnicodeFunction(Charset cs) {
            this.cs = cs;
        }

        @Override
        public String apply(byte[] object) {
            return Protocol.toString(object, this.cs);
        }

        List<String> asList(List<byte[]> data) {
            if (data == null) {
                return ImmutableList.of();
            }
            return Collections.unmodifiableList(Lists.transform(data, this));
        }
    }
}

