/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time;

import com.google.appengine.repackaged.org.joda.time.Chronology;
import com.google.appengine.repackaged.org.joda.time.DateTime;
import com.google.appengine.repackaged.org.joda.time.DateTimeField;
import com.google.appengine.repackaged.org.joda.time.DateTimeFieldType;
import com.google.appengine.repackaged.org.joda.time.DateTimeUtils;
import com.google.appengine.repackaged.org.joda.time.DateTimeZone;
import com.google.appengine.repackaged.org.joda.time.DurationFieldType;
import com.google.appengine.repackaged.org.joda.time.LocalTime;
import com.google.appengine.repackaged.org.joda.time.ReadablePartial;
import com.google.appengine.repackaged.org.joda.time.ReadablePeriod;
import com.google.appengine.repackaged.org.joda.time.base.BasePartial;
import com.google.appengine.repackaged.org.joda.time.chrono.ISOChronology;
import com.google.appengine.repackaged.org.joda.time.field.AbstractPartialFieldProperty;
import com.google.appengine.repackaged.org.joda.time.field.FieldUtils;
import com.google.appengine.repackaged.org.joda.time.format.ISODateTimeFormat;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

@Deprecated
public final class TimeOfDay
extends BasePartial
implements ReadablePartial,
Serializable {
    private static final long serialVersionUID = 3633353405803318660L;
    private static final DateTimeFieldType[] FIELD_TYPES = new DateTimeFieldType[]{DateTimeFieldType.hourOfDay(), DateTimeFieldType.minuteOfHour(), DateTimeFieldType.secondOfMinute(), DateTimeFieldType.millisOfSecond()};
    public static final TimeOfDay MIDNIGHT = new TimeOfDay(0, 0, 0, 0);
    public static final int HOUR_OF_DAY = 0;
    public static final int MINUTE_OF_HOUR = 1;
    public static final int SECOND_OF_MINUTE = 2;
    public static final int MILLIS_OF_SECOND = 3;

    public static TimeOfDay fromCalendarFields(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException("The calendar must not be null");
        }
        return new TimeOfDay(calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14));
    }

    public static TimeOfDay fromDateFields(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return new TimeOfDay(date.getHours(), date.getMinutes(), date.getSeconds(), ((int)(date.getTime() % 1000L) + 1000) % 1000);
    }

    public static TimeOfDay fromMillisOfDay(long millisOfDay) {
        return TimeOfDay.fromMillisOfDay(millisOfDay, null);
    }

    public static TimeOfDay fromMillisOfDay(long millisOfDay, Chronology chrono) {
        chrono = DateTimeUtils.getChronology(chrono);
        chrono = chrono.withUTC();
        return new TimeOfDay(millisOfDay, chrono);
    }

    public TimeOfDay() {
    }

    public TimeOfDay(DateTimeZone zone) {
        super(ISOChronology.getInstance(zone));
    }

    public TimeOfDay(Chronology chronology) {
        super(chronology);
    }

    public TimeOfDay(long instant) {
        super(instant);
    }

    public TimeOfDay(long instant, Chronology chronology) {
        super(instant, chronology);
    }

    public TimeOfDay(Object instant) {
        super(instant, null, ISODateTimeFormat.timeParser());
    }

    public TimeOfDay(Object instant, Chronology chronology) {
        super(instant, DateTimeUtils.getChronology(chronology), ISODateTimeFormat.timeParser());
    }

    public TimeOfDay(int hourOfDay, int minuteOfHour) {
        this(hourOfDay, minuteOfHour, 0, 0, null);
    }

    public TimeOfDay(int hourOfDay, int minuteOfHour, Chronology chronology) {
        this(hourOfDay, minuteOfHour, 0, 0, chronology);
    }

    public TimeOfDay(int hourOfDay, int minuteOfHour, int secondOfMinute) {
        this(hourOfDay, minuteOfHour, secondOfMinute, 0, null);
    }

    public TimeOfDay(int hourOfDay, int minuteOfHour, int secondOfMinute, Chronology chronology) {
        this(hourOfDay, minuteOfHour, secondOfMinute, 0, chronology);
    }

    public TimeOfDay(int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond) {
        this(hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond, null);
    }

    public TimeOfDay(int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond, Chronology chronology) {
        super(new int[]{hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond}, chronology);
    }

    TimeOfDay(TimeOfDay partial, int[] values) {
        super((BasePartial)partial, values);
    }

    TimeOfDay(TimeOfDay partial, Chronology chrono) {
        super((BasePartial)partial, chrono);
    }

    @Override
    public int size() {
        return 4;
    }

    @Override
    protected DateTimeField getField(int index, Chronology chrono) {
        switch (index) {
            case 0: {
                return chrono.hourOfDay();
            }
            case 1: {
                return chrono.minuteOfHour();
            }
            case 2: {
                return chrono.secondOfMinute();
            }
            case 3: {
                return chrono.millisOfSecond();
            }
        }
        throw new IndexOutOfBoundsException(new StringBuilder(26).append("Invalid index: ").append(index).toString());
    }

    @Override
    public DateTimeFieldType getFieldType(int index) {
        return FIELD_TYPES[index];
    }

    @Override
    public DateTimeFieldType[] getFieldTypes() {
        return (DateTimeFieldType[])FIELD_TYPES.clone();
    }

    public TimeOfDay withChronologyRetainFields(Chronology newChronology) {
        newChronology = DateTimeUtils.getChronology(newChronology);
        if ((newChronology = newChronology.withUTC()) == this.getChronology()) {
            return this;
        }
        TimeOfDay newTimeOfDay = new TimeOfDay(this, newChronology);
        newChronology.validate(newTimeOfDay, this.getValues());
        return newTimeOfDay;
    }

    public TimeOfDay withField(DateTimeFieldType fieldType, int value) {
        int index = this.indexOfSupported(fieldType);
        if (value == this.getValue(index)) {
            return this;
        }
        int[] newValues = this.getValues();
        newValues = this.getField(index).set(this, index, newValues, value);
        return new TimeOfDay(this, newValues);
    }

    public TimeOfDay withFieldAdded(DurationFieldType fieldType, int amount) {
        int index = this.indexOfSupported(fieldType);
        if (amount == 0) {
            return this;
        }
        int[] newValues = this.getValues();
        newValues = this.getField(index).addWrapPartial(this, index, newValues, amount);
        return new TimeOfDay(this, newValues);
    }

    public TimeOfDay withPeriodAdded(ReadablePeriod period, int scalar) {
        if (period == null || scalar == 0) {
            return this;
        }
        int[] newValues = this.getValues();
        for (int i = 0; i < period.size(); ++i) {
            DurationFieldType fieldType = period.getFieldType(i);
            int index = this.indexOf(fieldType);
            if (index < 0) continue;
            newValues = this.getField(index).addWrapPartial(this, index, newValues, FieldUtils.safeMultiply(period.getValue(i), scalar));
        }
        return new TimeOfDay(this, newValues);
    }

    public TimeOfDay plus(ReadablePeriod period) {
        return this.withPeriodAdded(period, 1);
    }

    public TimeOfDay plusHours(int hours) {
        return this.withFieldAdded(DurationFieldType.hours(), hours);
    }

    public TimeOfDay plusMinutes(int minutes) {
        return this.withFieldAdded(DurationFieldType.minutes(), minutes);
    }

    public TimeOfDay plusSeconds(int seconds) {
        return this.withFieldAdded(DurationFieldType.seconds(), seconds);
    }

    public TimeOfDay plusMillis(int millis) {
        return this.withFieldAdded(DurationFieldType.millis(), millis);
    }

    public TimeOfDay minus(ReadablePeriod period) {
        return this.withPeriodAdded(period, -1);
    }

    public TimeOfDay minusHours(int hours) {
        return this.withFieldAdded(DurationFieldType.hours(), FieldUtils.safeNegate(hours));
    }

    public TimeOfDay minusMinutes(int minutes) {
        return this.withFieldAdded(DurationFieldType.minutes(), FieldUtils.safeNegate(minutes));
    }

    public TimeOfDay minusSeconds(int seconds) {
        return this.withFieldAdded(DurationFieldType.seconds(), FieldUtils.safeNegate(seconds));
    }

    public TimeOfDay minusMillis(int millis) {
        return this.withFieldAdded(DurationFieldType.millis(), FieldUtils.safeNegate(millis));
    }

    public Property property(DateTimeFieldType type) {
        return new Property(this, this.indexOfSupported(type));
    }

    public LocalTime toLocalTime() {
        return new LocalTime(this.getHourOfDay(), this.getMinuteOfHour(), this.getSecondOfMinute(), this.getMillisOfSecond(), this.getChronology());
    }

    public DateTime toDateTimeToday() {
        return this.toDateTimeToday(null);
    }

    public DateTime toDateTimeToday(DateTimeZone zone) {
        Chronology chrono = this.getChronology().withZone(zone);
        long instantMillis = DateTimeUtils.currentTimeMillis();
        long resolved = chrono.set(this, instantMillis);
        return new DateTime(resolved, chrono);
    }

    public int getHourOfDay() {
        return this.getValue(0);
    }

    public int getMinuteOfHour() {
        return this.getValue(1);
    }

    public int getSecondOfMinute() {
        return this.getValue(2);
    }

    public int getMillisOfSecond() {
        return this.getValue(3);
    }

    public TimeOfDay withHourOfDay(int hour) {
        int[] newValues = this.getValues();
        newValues = this.getChronology().hourOfDay().set(this, 0, newValues, hour);
        return new TimeOfDay(this, newValues);
    }

    public TimeOfDay withMinuteOfHour(int minute) {
        int[] newValues = this.getValues();
        newValues = this.getChronology().minuteOfHour().set(this, 1, newValues, minute);
        return new TimeOfDay(this, newValues);
    }

    public TimeOfDay withSecondOfMinute(int second) {
        int[] newValues = this.getValues();
        newValues = this.getChronology().secondOfMinute().set(this, 2, newValues, second);
        return new TimeOfDay(this, newValues);
    }

    public TimeOfDay withMillisOfSecond(int millis) {
        int[] newValues = this.getValues();
        newValues = this.getChronology().millisOfSecond().set(this, 3, newValues, millis);
        return new TimeOfDay(this, newValues);
    }

    public Property hourOfDay() {
        return new Property(this, 0);
    }

    public Property minuteOfHour() {
        return new Property(this, 1);
    }

    public Property secondOfMinute() {
        return new Property(this, 2);
    }

    public Property millisOfSecond() {
        return new Property(this, 3);
    }

    @Override
    public String toString() {
        return ISODateTimeFormat.tTime().print(this);
    }

    @Deprecated
    public static class Property
    extends AbstractPartialFieldProperty
    implements Serializable {
        private static final long serialVersionUID = 5598459141741063833L;
        private final TimeOfDay iTimeOfDay;
        private final int iFieldIndex;

        Property(TimeOfDay partial, int fieldIndex) {
            this.iTimeOfDay = partial;
            this.iFieldIndex = fieldIndex;
        }

        @Override
        public DateTimeField getField() {
            return this.iTimeOfDay.getField(this.iFieldIndex);
        }

        @Override
        protected ReadablePartial getReadablePartial() {
            return this.iTimeOfDay;
        }

        public TimeOfDay getTimeOfDay() {
            return this.iTimeOfDay;
        }

        @Override
        public int get() {
            return this.iTimeOfDay.getValue(this.iFieldIndex);
        }

        public TimeOfDay addToCopy(int valueToAdd) {
            int[] newValues = this.iTimeOfDay.getValues();
            newValues = this.getField().addWrapPartial(this.iTimeOfDay, this.iFieldIndex, newValues, valueToAdd);
            return new TimeOfDay(this.iTimeOfDay, newValues);
        }

        public TimeOfDay addNoWrapToCopy(int valueToAdd) {
            int[] newValues = this.iTimeOfDay.getValues();
            newValues = this.getField().add(this.iTimeOfDay, this.iFieldIndex, newValues, valueToAdd);
            return new TimeOfDay(this.iTimeOfDay, newValues);
        }

        public TimeOfDay addWrapFieldToCopy(int valueToAdd) {
            int[] newValues = this.iTimeOfDay.getValues();
            newValues = this.getField().addWrapField(this.iTimeOfDay, this.iFieldIndex, newValues, valueToAdd);
            return new TimeOfDay(this.iTimeOfDay, newValues);
        }

        public TimeOfDay setCopy(int value) {
            int[] newValues = this.iTimeOfDay.getValues();
            newValues = this.getField().set(this.iTimeOfDay, this.iFieldIndex, newValues, value);
            return new TimeOfDay(this.iTimeOfDay, newValues);
        }

        public TimeOfDay setCopy(String text, Locale locale) {
            int[] newValues = this.iTimeOfDay.getValues();
            newValues = this.getField().set(this.iTimeOfDay, this.iFieldIndex, newValues, text, locale);
            return new TimeOfDay(this.iTimeOfDay, newValues);
        }

        public TimeOfDay setCopy(String text) {
            return this.setCopy(text, null);
        }

        public TimeOfDay withMaximumValue() {
            return this.setCopy(this.getMaximumValue());
        }

        public TimeOfDay withMinimumValue() {
            return this.setCopy(this.getMinimumValue());
        }
    }
}

