/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.io.protocol;

import com.google.appengine.repackaged.com.google.common.base.MoreObjects;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSetMultimap;
import com.google.appengine.repackaged.com.google.common.collect.SetMultimap;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolDB;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSupport;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolType;
import com.google.appengine.repackaged.com.google.io.protocol.proto.ProtocolDescriptor;
import com.google.appengine.repackaged.com.google.io.protocol.proto.RPC_ServiceDescriptor;
import com.google.appengine.repackaged.com.google.protobuf.DescriptorProtos;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jspecify.nullness.Nullable;

public final class SimpleProtocolDB
extends ProtocolDB {
    private final Map<String, ProtocolDescriptor> descriptorByName;
    private final Map<Integer, ProtocolDescriptor> descriptorByTypeId;
    private final Map<String, Map<Integer, String>> extensionByName;
    private final SetMultimap<String, String> fileContent;
    private final Map<String, RPC_ServiceDescriptor> serviceByName;

    public static Builder builder() {
        return new Builder();
    }

    private SimpleProtocolDB(Builder builder) {
        this.descriptorByName = ImmutableMap.copyOf(builder.descriptorByName);
        this.serviceByName = ImmutableMap.copyOf(builder.serviceByName);
        this.extensionByName = ImmutableMap.copyOf(builder.extensionByName);
        this.fileContent = SimpleProtocolDB.createFileContent(this.descriptorByName);
        this.descriptorByTypeId = SimpleProtocolDB.createTypeIdMap(this.descriptorByName.values());
    }

    @Override
    public ProtocolDescriptor find(String name) {
        return this.descriptorByName.get(name);
    }

    @Override
    public ProtocolDescriptor findByTypeId(int typeId) {
        return this.descriptorByTypeId.get(typeId);
    }

    @Override
    public Set<String> findByFileName(String fileName) {
        Collection names = this.fileContent.get((Object)fileName);
        if (names == null) {
            return ImmutableSet.of();
        }
        return names;
    }

    @Override
    public RPC_ServiceDescriptor findService(String name) {
        return this.serviceByName.get(name);
    }

    @Override
    public @Nullable String findFileNameContainingExtension(String extendeeType, int number) {
        Map<Integer, String> numberLookup = this.extensionByName.get(extendeeType);
        if (numberLookup == null) {
            return null;
        }
        return numberLookup.get(number);
    }

    @Override
    public Set<Integer> findAllExtensionNumbers(String extendeeType) {
        Map<Integer, String> numberLookup = this.extensionByName.get(extendeeType);
        if (numberLookup == null) {
            return ImmutableSet.of();
        }
        return numberLookup.keySet();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("types", this.descriptorByName.keySet()).add("files", this.fileContent.keySet()).toString();
    }

    private static SetMultimap<String, String> createFileContent(Map<String, ProtocolDescriptor> descriptorByName) {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        for (Map.Entry<String, ProtocolDescriptor> entry : descriptorByName.entrySet()) {
            String name = entry.getKey();
            String fileName = entry.getValue().getFilename();
            builder.put(fileName, name);
        }
        return builder.build();
    }

    private static Map<Integer, ProtocolDescriptor> createTypeIdMap(Iterable<ProtocolDescriptor> descriptors) {
        ImmutableMap.Builder<Integer, ProtocolDescriptor> builder = ImmutableMap.builder();
        for (ProtocolDescriptor descriptor : descriptors) {
            Integer typeId = SimpleProtocolDB.extractTypeId(descriptor);
            if (typeId == null) continue;
            builder.put(typeId, descriptor);
        }
        return builder.buildOrThrow();
    }

    private static @Nullable Integer extractTypeId(ProtocolDescriptor descriptor) {
        for (ProtocolDescriptor.EnumType enumType : descriptor.enumTypes()) {
            if (!"TypeId".equals(enumType.getName())) continue;
            for (ProtocolDescriptor.EnumTypeTag tag : enumType.tags()) {
                if (!"MESSAGE_TYPE_ID".equals(tag.getName())) continue;
                return tag.getValue();
            }
        }
        return null;
    }

    public static final class Builder {
        private final Map<String, ProtocolDescriptor> descriptorByName = new HashMap<String, ProtocolDescriptor>();
        private final Map<String, RPC_ServiceDescriptor> serviceByName = new HashMap<String, RPC_ServiceDescriptor>();
        private final Map<String, Map<Integer, String>> extensionByName = new HashMap<String, Map<Integer, String>>();
        private final Set<String> completeTypes = new HashSet<String>();

        public SimpleProtocolDB build() {
            return new SimpleProtocolDB(this);
        }

        @CanIgnoreReturnValue
        public Builder add(ProtocolDescriptor descriptor) {
            Preconditions.checkNotNull(descriptor, "descriptor");
            this.descriptorByName.put(this.extractProtoName(descriptor), descriptor);
            this.addEmbeddedExtensions(descriptor);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAll(Iterable<ProtocolDescriptor> descriptors) {
            Preconditions.checkNotNull(descriptors, "descriptors");
            for (ProtocolDescriptor descriptor : descriptors) {
                this.add(descriptor);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addService(RPC_ServiceDescriptor service) {
            this.serviceByName.put(this.extractFullName(service), service);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllService(Iterable<RPC_ServiceDescriptor> services) {
            Preconditions.checkNotNull(services, "services");
            for (RPC_ServiceDescriptor service : services) {
                this.addService(service);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addRecursively(ProtocolType type) {
            ProtocolDescriptor descriptor;
            Preconditions.checkNotNull(type, "type");
            ProtocolMessage<?> message = ProtocolSupport.newInstance(type.getProtocolMessageClass());
            try {
                descriptor = type.getProtocolDescriptor();
            }
            catch (IllegalStateException e) {
                throw new IllegalArgumentException(type.getProtocolMessageClass() + " has no ProtocolDescriptor. If it is a group, please add the top-level protocol buffer instead.", e);
            }
            String name = this.extractProtoName(descriptor);
            if (this.completeTypes.contains(name)) {
                return this;
            }
            if (!this.descriptorByName.containsKey(name)) {
                this.descriptorByName.put(name, descriptor);
            }
            this.completeTypes.add(name);
            this.addEmbeddedExtensions(descriptor);
            for (ProtocolType.FieldType tag : ProtocolType.getTags(message)) {
                if (tag.getBaseType() != ProtocolType.FieldBaseType.FOREIGN) continue;
                this.addRecursively(ProtocolSupport.newInstance(tag.getSubclass()).getProtocolType());
            }
            return this;
        }

        private String extractProtoName(ProtocolDescriptor descriptor) {
            if (descriptor.hasProtoName()) {
                return descriptor.getProtoName();
            }
            return descriptor.getName();
        }

        private String extractFullName(RPC_ServiceDescriptor descriptor) {
            if (descriptor.hasFullName()) {
                return descriptor.getFullName();
            }
            return descriptor.getName();
        }

        private void addEmbeddedExtensions(ProtocolDescriptor descriptor) {
            String filename = descriptor.getFilename();
            if (descriptor.hasProto2ExtensionInfo()) {
                this.addEmbeddedProto2ExtensionInfo(descriptor, filename);
            }
            if (descriptor.hasProto2FileScopeInfo()) {
                this.addEmbeddedProto2FileScopeInfo(descriptor, filename);
            }
        }

        private void addEmbeddedProto2ExtensionInfo(ProtocolDescriptor descriptor, String filename) {
            DescriptorProtos.DescriptorProto proto2;
            byte[] descriptorBytes = descriptor.getProto2ExtensionInfoAsBytes();
            try {
                proto2 = DescriptorProtos.DescriptorProto.parseFrom(descriptorBytes);
            }
            catch (InvalidProtocolBufferException e) {
                throw new IllegalArgumentException("Descriptor has an ill-formed embedded proto2 descriptor.");
            }
            this.addNestedExtensions(proto2, filename);
        }

        private void addEmbeddedProto2FileScopeInfo(ProtocolDescriptor descriptor, String filename) {
            DescriptorProtos.FileDescriptorProto fileProto2;
            byte[] fileDescriptorBytes = descriptor.getProto2FileScopeInfoAsBytes();
            try {
                fileProto2 = DescriptorProtos.FileDescriptorProto.parseFrom(fileDescriptorBytes);
            }
            catch (InvalidProtocolBufferException e) {
                throw new IllegalArgumentException("Descriptor has an ill-formed embedded proto2 file descriptor.");
            }
            for (DescriptorProtos.FieldDescriptorProto extension : fileProto2.getExtensionList()) {
                this.addExtension(extension, filename);
            }
        }

        private void addNestedExtensions(DescriptorProtos.DescriptorProto proto2, String filename) {
            for (DescriptorProtos.FieldDescriptorProto extension : proto2.getExtensionList()) {
                this.addExtension(extension, filename);
            }
            for (DescriptorProtos.DescriptorProto nested : proto2.getNestedTypeList()) {
                this.addNestedExtensions(nested, filename);
            }
        }

        private void addExtension(DescriptorProtos.FieldDescriptorProto extension, String filename) {
            String extendee = extension.getExtendee();
            int number = extension.getNumber();
            this.addExtensionMapping(extendee, number, filename);
        }

        private void addExtensionMapping(String extendee, int number, String filename) {
            if (extendee.isEmpty()) {
                return;
            }
            Map<Integer, String> extensions = this.extensionByName.get(extendee);
            if (extensions == null) {
                extensions = new HashMap<Integer, String>();
                this.extensionByName.put(extendee, extensions);
            }
            extensions.put(number, filename);
        }
    }
}

