/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.util.concurrent;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import java.util.concurrent.Semaphore;
import org.jspecify.nullness.NullMarked;

@NullMarked
@GoogleInternal
@GwtIncompatible
public final class ResizableSemaphore
extends Semaphore {
    private static final long serialVersionUID = 0L;
    private volatile int totalPermits;

    public ResizableSemaphore(int permits, boolean fair) {
        super(permits, fair);
        this.totalPermits = permits;
    }

    public synchronized void setTotalPermits(int permits) {
        if (this.totalPermits == permits) {
            return;
        }
        if (permits < 0) {
            throw new IllegalArgumentException("Cannot resize semaphore to a negative size.");
        }
        int diff = permits - this.totalPermits;
        if (diff > 0) {
            this.release(diff);
        } else {
            this.reducePermits(-diff);
        }
        this.totalPermits = permits;
    }

    public int getTotalPermits() {
        return this.totalPermits;
    }
}

