/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.util.concurrent;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.util.concurrent.Futures;
import com.google.appengine.repackaged.com.google.common.util.concurrent.Internal;
import com.google.appengine.repackaged.com.google.common.util.concurrent.ListenableFuture;
import com.google.appengine.repackaged.com.google.common.util.concurrent.ListeningExecutorService;
import com.google.appengine.repackaged.com.google.common.util.concurrent.ParametricNullness;
import com.google.appengine.repackaged.com.google.common.util.concurrent.TrustedListenableFutureTask;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.appengine.repackaged.com.google.errorprone.annotations.DoNotMock;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.CheckForNull;
import org.jspecify.nullness.NullMarked;

@NullMarked
@GoogleInternal
@GwtIncompatible
public final class BoundedExecutorService
implements ListeningExecutorService {
    private final int maxPermits;
    private final ExecutorService delegate;
    private final Semaphore semaphore;

    public BoundedExecutorService(int maxPermits, boolean fair, ExecutorService delegate) {
        Preconditions.checkNotNull(delegate);
        Preconditions.checkArgument(maxPermits > 0);
        this.maxPermits = maxPermits;
        this.delegate = delegate;
        this.semaphore = new Semaphore(maxPermits, fair);
    }

    private int permitsForTask(Object task, BoundedExecutorService bes) {
        Preconditions.checkNotNull(task);
        return task instanceof ResourceConstrained ? ((ResourceConstrained)task).permitsFor(bes) : 1;
    }

    @CheckForNull
    public <T> ListenableFuture<T> trySubmit(Callable<T> task) {
        int permits = this.permitsForTask(task, this);
        if (this.semaphore.tryAcquire(permits)) {
            return this.wrapAndSubmit(task, permits);
        }
        return null;
    }

    @CheckForNull
    public ListenableFuture<?> trySubmit(Runnable task) {
        int permits = this.permitsForTask(task, this);
        if (this.semaphore.tryAcquire(permits)) {
            return this.wrapAndSubmit(task, null, permits);
        }
        return null;
    }

    @CheckForNull
    public <T> ListenableFuture<T> trySubmit(Runnable task, @ParametricNullness T result) {
        int permits = this.permitsForTask(task, this);
        if (this.semaphore.tryAcquire(permits)) {
            return this.wrapAndSubmit(task, result, permits);
        }
        return null;
    }

    @CheckForNull
    public <T> ListenableFuture<T> trySubmit(Callable<T> task, Duration timeout) throws InterruptedException {
        return this.trySubmit(task, Internal.toNanosSaturated(timeout), TimeUnit.NANOSECONDS);
    }

    @CheckForNull
    public <T> ListenableFuture<T> trySubmit(Callable<T> task, long timeout, TimeUnit unit) throws InterruptedException {
        int permits = this.permitsForTask(task, this);
        if (this.semaphore.tryAcquire(permits, timeout, unit)) {
            return this.wrapAndSubmit(task, permits);
        }
        return null;
    }

    @CheckForNull
    public ListenableFuture<?> trySubmit(Runnable task, Duration timeout) throws InterruptedException {
        return this.trySubmit(task, Internal.toNanosSaturated(timeout), TimeUnit.NANOSECONDS);
    }

    @CheckForNull
    public ListenableFuture<?> trySubmit(Runnable task, long timeout, TimeUnit unit) throws InterruptedException {
        int permits = this.permitsForTask(task, this);
        if (this.semaphore.tryAcquire(permits, timeout, unit)) {
            return this.wrapAndSubmit(task, null, permits);
        }
        return null;
    }

    @CheckForNull
    public <T> ListenableFuture<T> trySubmit(Runnable task, @ParametricNullness T result, Duration timeout) throws InterruptedException {
        return this.trySubmit(task, result, Internal.toNanosSaturated(timeout), TimeUnit.NANOSECONDS);
    }

    @CheckForNull
    public <T> ListenableFuture<T> trySubmit(Runnable task, @ParametricNullness T result, long timeout, TimeUnit unit) throws InterruptedException {
        int permits = this.permitsForTask(task, this);
        if (this.semaphore.tryAcquire(permits, timeout, unit)) {
            return this.wrapAndSubmit(task, result, permits);
        }
        return null;
    }

    public <T> ListenableFuture<T> submitInterruptibly(Callable<T> task) throws InterruptedException {
        int permits = this.permitsForTask(task, this);
        this.semaphore.acquire(permits);
        return this.wrapAndSubmit(task, permits);
    }

    public ListenableFuture<?> submitInterruptibly(Runnable task) throws InterruptedException {
        int permits = this.permitsForTask(task, this);
        this.semaphore.acquire(permits);
        return this.wrapAndSubmit(task, null, permits);
    }

    public <T> ListenableFuture<T> submitInterruptibly(Runnable task, @ParametricNullness T result) throws InterruptedException {
        int permits = this.permitsForTask(task, this);
        this.semaphore.acquire(permits);
        return this.wrapAndSubmit(task, result, permits);
    }

    @Override
    public <T> ListenableFuture<T> submit(Callable<T> task) {
        int permits = this.permitsForTask(task, this);
        this.semaphore.acquireUninterruptibly(permits);
        return this.wrapAndSubmit(task, permits);
    }

    @Override
    public ListenableFuture<?> submit(Runnable task) {
        int permits = this.permitsForTask(task, this);
        this.semaphore.acquireUninterruptibly(permits);
        return this.wrapAndSubmit(task, null, permits);
    }

    @Override
    public <T> ListenableFuture<T> submit(Runnable task, @ParametricNullness T result) {
        int permits = this.permitsForTask(task, this);
        this.semaphore.acquireUninterruptibly(permits);
        return this.wrapAndSubmit(task, result, permits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        Preconditions.checkNotNull(tasks);
        ArrayList<Future<T>> futures = Lists.newArrayListWithExpectedSize(tasks.size());
        try {
            for (Callable<T> callable : tasks) {
                futures.add(this.submitInterruptibly(callable));
            }
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (CancellationException | ExecutionException exception) {}
            }
        }
        finally {
            for (Future future : futures) {
                future.cancel(false);
            }
        }
        return futures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        Preconditions.checkNotNull(tasks);
        Preconditions.checkNotNull(unit);
        long startTime = System.nanoTime();
        long endTime = startTime + TimeUnit.NANOSECONDS.convert(timeout, unit);
        if (endTime - startTime < 0L) {
            endTime = startTime;
        }
        ArrayList<Future<T>> futures = Lists.newArrayListWithExpectedSize(tasks.size());
        ListenableFuture unstartedTaskFuture = null;
        try {
            for (Callable<T> callable : tasks) {
                ListenableFuture<Object> future = this.trySubmit(callable, BoundedExecutorService.nanosUntil(endTime), TimeUnit.NANOSECONDS);
                if (future == null) {
                    if (unstartedTaskFuture == null) {
                        unstartedTaskFuture = Futures.immediateCancelledFuture();
                    }
                    future = unstartedTaskFuture;
                }
                futures.add(future);
            }
            for (Future future : futures) {
                try {
                    future.get(BoundedExecutorService.nanosUntil(endTime), TimeUnit.NANOSECONDS);
                }
                catch (CancellationException | ExecutionException | TimeoutException exception) {}
            }
        }
        finally {
            for (Future future : futures) {
                future.cancel(false);
            }
        }
        return futures;
    }

    private static long nanosUntil(long endTimeNanos) {
        return endTimeNanos - System.nanoTime();
    }

    @Override
    @ParametricNullness
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws ExecutionException, InterruptedException {
        List<Future<T>> futures = this.invokeAll(tasks);
        Preconditions.checkArgument(!futures.isEmpty());
        ExecutionException lastExec = null;
        CancellationException lastCancel = null;
        for (Future<T> future : futures) {
            try {
                return future.get();
            }
            catch (ExecutionException e) {
                lastExec = e;
            }
            catch (CancellationException e) {
                lastCancel = e;
            }
        }
        if (lastExec != null) {
            throw lastExec;
        }
        if (lastCancel != null) {
            throw new ExecutionException(lastCancel);
        }
        throw new AssertionError();
    }

    @Override
    @ParametricNullness
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        List<Future<T>> futures = this.invokeAll(tasks, timeout, unit);
        ExecutionException lastExec = null;
        for (Future<T> future : futures) {
            try {
                return future.get();
            }
            catch (ExecutionException e) {
                lastExec = e;
            }
            catch (CancellationException e) {
                throw new TimeoutException();
            }
        }
        if (lastExec != null) {
            throw lastExec;
        }
        throw new AssertionError();
    }

    @Override
    public void execute(Runnable command) {
        Future possiblyIgnoredError = this.submit(command);
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    @CanIgnoreReturnValue
    public List<Runnable> shutdownNow() {
        List<Runnable> unstartedTasks = this.delegate.shutdownNow();
        for (Runnable r : unstartedTasks) {
            if (!(r instanceof Future)) continue;
            ((Future)((Object)r)).cancel(false);
        }
        return unstartedTasks;
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    public int availablePermits() {
        return this.semaphore.availablePermits();
    }

    public int maxPermits() {
        return this.maxPermits;
    }

    private <T> ListenableFuture<T> wrapAndSubmit(Runnable task, @ParametricNullness T result, int permits) {
        ReleasingFutureTask<T> futureTask = new ReleasingFutureTask<T>(task, result, permits);
        this.submitToDelegate(futureTask);
        return futureTask;
    }

    private <T> ListenableFuture<T> wrapAndSubmit(Callable<T> task, int permits) {
        ReleasingFutureTask<T> futureTask = new ReleasingFutureTask<T>(task, permits);
        this.submitToDelegate(futureTask);
        return futureTask;
    }

    private void submitToDelegate(ReleasingFutureTask<?> task) {
        boolean successful = false;
        try {
            this.delegate.execute(task);
            successful = true;
        }
        finally {
            if (!successful) {
                task.cancel(false);
            }
        }
    }

    @DoNotMock(value="Implement this normally when implementing a Callable or Runnable")
    public static interface ResourceConstrained {
        public int permitsFor(BoundedExecutorService var1);
    }

    private class ReleasingFutureTask<V>
    extends TrustedListenableFutureTask<V>
    implements ResourceConstrained {
        final int permits;
        @CheckForNull
        final Callable<V> callableTask;
        @CheckForNull
        final Runnable runnableTask;
        final AtomicBoolean releaseResponsibility;

        public ReleasingFutureTask(Callable<V> callable, int permits) {
            super(callable);
            this.releaseResponsibility = new AtomicBoolean(false);
            this.permits = permits;
            this.callableTask = callable;
            this.runnableTask = null;
        }

        public ReleasingFutureTask(@ParametricNullness Runnable runnable, V result, int permits) {
            super(Executors.callable(runnable, result));
            this.releaseResponsibility = new AtomicBoolean(false);
            this.permits = permits;
            this.callableTask = null;
            this.runnableTask = runnable;
        }

        @Override
        public void run() {
            if (this.releaseResponsibility.compareAndSet(false, true)) {
                try {
                    super.run();
                }
                finally {
                    BoundedExecutorService.this.semaphore.release(this.permits);
                }
            }
        }

        @Override
        protected void afterDone() {
            super.afterDone();
            if (this.isCancelled() && this.releaseResponsibility.compareAndSet(false, true)) {
                BoundedExecutorService.this.semaphore.release(this.permits);
            }
        }

        @Override
        public int permitsFor(BoundedExecutorService bes) {
            Object task = this.callableTask != null ? this.callableTask : Objects.requireNonNull(this.runnableTask);
            return BoundedExecutorService.this.permitsForTask(task, bes);
        }
    }
}

