/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flogger.backend.google;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.flogger.LogContext;
import com.google.appengine.repackaged.com.google.common.flogger.backend.LogData;
import com.google.appengine.repackaged.com.google.common.flogger.backend.LogMessageFormatter;
import com.google.appengine.repackaged.com.google.common.flogger.backend.LoggerBackend;
import com.google.appengine.repackaged.com.google.common.flogger.backend.Metadata;
import com.google.appengine.repackaged.com.google.common.flogger.backend.Platform;
import com.google.appengine.repackaged.com.google.common.flogger.backend.google.GoogleLoggerShutdownHandler;
import com.google.appengine.repackaged.com.google.common.flogger.backend.google.ShutdownChecker;
import com.google.appengine.repackaged.com.google.common.flogger.backend.google.SimpleCustomFormatter;
import com.google.appengine.repackaged.com.google.common.flogger.backend.system.AbstractBackend;
import com.google.appengine.repackaged.com.google.common.flogger.backend.system.AbstractLogRecord;
import com.google.appengine.repackaged.com.google.common.flogger.backend.system.BackendFactory;
import com.google.appengine.repackaged.com.google.common.flogger.backend.system.SimpleLogRecord;

public final class GoogleLoggerBackend
extends BackendFactory {
    private static final GoogleLoggerBackend INSTANCE = new GoogleLoggerBackend();
    private final LogMessageFormatter formatter = SimpleCustomFormatter.fromTemplateString(System.getProperty("google.debug_logs.format_template"));

    public static BackendFactory getInstance() {
        return INSTANCE;
    }

    private static LogMessageFormatter getFormatter() {
        return GoogleLoggerBackend.INSTANCE.formatter;
    }

    private GoogleLoggerBackend() {
    }

    @Override
    public LoggerBackend create(String loggingClass) {
        return new BackendImpl(loggingClass);
    }

    public String toString() {
        return "Google logger backend factory";
    }

    private static final class BackendImpl
    extends AbstractBackend {
        private BackendImpl(String loggingClass) {
            super(loggingClass);
        }

        @Override
        public void log(LogData data) {
            GoogleLogRecord record = new GoogleLogRecord(data, Platform.getInjectedMetadata());
            this.log(record, data.wasForced());
            if (ShutdownChecker.isInSystemShutdown()) {
                GoogleLoggerShutdownHandler.shutdownFallbackLog(record);
            }
        }

        @Override
        public void handleError(RuntimeException error, LogData badData) {
            SimpleLogRecord record = SimpleLogRecord.error(error, badData, Platform.getInjectedMetadata());
            this.log(record, badData.wasForced());
            if (ShutdownChecker.isInSystemShutdown()) {
                GoogleLoggerShutdownHandler.shutdownFallbackLog(record);
            }
        }
    }

    @VisibleForTesting
    static final class GoogleLogRecord
    extends AbstractLogRecord {
        GoogleLogRecord(LogData logData, Metadata scope) {
            super(logData, scope);
            this.setThrown(logData.getMetadata().findValue(LogContext.Key.LOG_CAUSE));
            this.getMessage();
        }

        @Override
        protected LogMessageFormatter getLogMessageFormatter() {
            return GoogleLoggerBackend.getFormatter();
        }
    }
}

