/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.NamespaceManager;
import com.google.appengine.api.appidentity.AppIdentityService;
import com.google.appengine.api.appidentity.AppIdentityServiceFactory;
import com.google.appengine.api.datastore.AppIdNamespace;
import com.google.appengine.api.datastore.CommittedButStillApplyingException;
import com.google.appengine.api.datastore.DatastoreFailureException;
import com.google.appengine.api.datastore.DatastoreNeedIndexException;
import com.google.appengine.api.datastore.DatastoreServiceGlobalConfig;
import com.google.appengine.api.datastore.DatastoreTimeoutException;
import com.google.appengine.api.utils.FutureWrapper;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.appengine.repackaged.com.google.rpc.Code;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.DatastorePb;
import java.util.ConcurrentModificationException;
import java.util.concurrent.Future;

public final class DatastoreApiHelper {
    static final String DATASTORE_V3_PACKAGE = "datastore_v3";
    static final String APP_ID_OVERRIDE_KEY = "com.google.appengine.datastore.AppIdOverride";
    private static final AppIdentityService appIdentityService = AppIdentityServiceFactory.getAppIdentityService();

    private DatastoreApiHelper() {
    }

    public static RuntimeException translateError(ApiProxy.ApplicationException exception) {
        DatastorePb.Error.ErrorCode errorCode = DatastorePb.Error.ErrorCode.valueOf(exception.getApplicationError());
        if (errorCode == null) {
            return new DatastoreFailureException(exception.getErrorDetail());
        }
        switch (errorCode) {
            case BAD_REQUEST: {
                return new IllegalArgumentException(exception.getErrorDetail());
            }
            case CONCURRENT_TRANSACTION: {
                return new ConcurrentModificationException(exception.getErrorDetail());
            }
            case NEED_INDEX: {
                return new DatastoreNeedIndexException(exception.getErrorDetail());
            }
            case TIMEOUT: 
            case BIGTABLE_ERROR: {
                return new DatastoreTimeoutException(exception.getErrorDetail());
            }
            case COMMITTED_BUT_STILL_APPLYING: {
                return new CommittedButStillApplyingException(exception.getErrorDetail());
            }
            case RESOURCE_EXHAUSTED: {
                return new ApiProxy.OverQuotaException(exception.getErrorDetail(), (Throwable)null);
            }
        }
        return new DatastoreFailureException(exception.getErrorDetail());
    }

    static RuntimeException createV1Exception(Code code, String message, Throwable cause) {
        if (code == null) {
            return new DatastoreFailureException(message, cause);
        }
        switch (code) {
            case ABORTED: {
                return new ConcurrentModificationException(message, cause);
            }
            case FAILED_PRECONDITION: {
                if (message.contains("The Cloud Datastore API is not enabled for the project")) {
                    return new DatastoreFailureException(message, cause);
                }
                return new DatastoreNeedIndexException(message, cause);
            }
            case DEADLINE_EXCEEDED: {
                return new DatastoreTimeoutException(message, cause);
            }
            case INVALID_ARGUMENT: 
            case PERMISSION_DENIED: {
                return new IllegalArgumentException(message, cause);
            }
            case UNAVAILABLE: {
                return new ApiProxy.RPCFailedException(message, cause);
            }
            case RESOURCE_EXHAUSTED: {
                return new ApiProxy.OverQuotaException(message, cause);
            }
        }
        return new DatastoreFailureException(message, cause);
    }

    static <T extends ProtocolMessage<T>> Future<T> makeAsyncCall(ApiProxy.ApiConfig apiConfig, final DatastorePb.DatastoreService_3.Method method, MessageLite request, final T responseProto) {
        Future<byte[]> response = ApiProxy.makeAsyncCall(DATASTORE_V3_PACKAGE, method.name(), request.toByteArray(), apiConfig);
        return new FutureWrapper<byte[], T>(response){

            @Override
            protected T wrap(byte[] responseBytes) throws InvalidProtocolBufferException {
                if (responseBytes != null && responseProto != null) {
                    if (!responseProto.parseFrom(responseBytes)) {
                        throw new InvalidProtocolBufferException(String.format("Invalid %s.%s response", DatastoreApiHelper.DATASTORE_V3_PACKAGE, method.name()));
                    }
                    String initializationError = responseProto.findInitializationError();
                    if (initializationError != null) {
                        throw new InvalidProtocolBufferException(initializationError);
                    }
                }
                return responseProto;
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                if (cause instanceof ApiProxy.ApplicationException) {
                    return DatastoreApiHelper.translateError((ApiProxy.ApplicationException)cause);
                }
                return cause;
            }
        };
    }

    static String getCurrentProjectId() {
        return DatastoreApiHelper.toProjectId(DatastoreApiHelper.getCurrentAppId());
    }

    static String toProjectId(String appId) {
        AppIdentityService.ParsedAppId parsedAppId = appIdentityService.parseFullAppId(appId);
        if (parsedAppId.getDomain().isEmpty()) {
            return parsedAppId.getId();
        }
        return String.format("%s:%s", parsedAppId.getDomain(), parsedAppId.getId());
    }

    static String getCurrentAppId() {
        ApiProxy.Environment environment = DatastoreServiceGlobalConfig.getCurrentApiProxyEnvironment();
        if (environment == null) {
            throw new NullPointerException("No API environment is registered for this thread.");
        }
        Object appIdOverride = environment.getAttributes().get(APP_ID_OVERRIDE_KEY);
        if (appIdOverride != null) {
            return (String)appIdOverride;
        }
        return environment.getAppId();
    }

    static AppIdNamespace getCurrentAppIdNamespace() {
        return DatastoreApiHelper.getCurrentAppIdNamespace(DatastoreApiHelper.getCurrentAppId());
    }

    static AppIdNamespace getCurrentAppIdNamespace(String appId) {
        String namespace = NamespaceManager.get();
        namespace = namespace == null ? "" : namespace;
        return new AppIdNamespace(appId, namespace);
    }
}

