/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time.chrono;

import com.google.appengine.repackaged.org.joda.time.Chronology;
import com.google.appengine.repackaged.org.joda.time.DateTimeField;
import com.google.appengine.repackaged.org.joda.time.DateTimeFieldType;
import com.google.appengine.repackaged.org.joda.time.DateTimeZone;
import com.google.appengine.repackaged.org.joda.time.DurationField;
import com.google.appengine.repackaged.org.joda.time.DurationFieldType;
import com.google.appengine.repackaged.org.joda.time.IllegalFieldValueException;
import com.google.appengine.repackaged.org.joda.time.ReadablePartial;
import com.google.appengine.repackaged.org.joda.time.ReadablePeriod;
import com.google.appengine.repackaged.org.joda.time.field.FieldUtils;
import com.google.appengine.repackaged.org.joda.time.field.UnsupportedDateTimeField;
import com.google.appengine.repackaged.org.joda.time.field.UnsupportedDurationField;
import java.io.Serializable;

public abstract class BaseChronology
extends Chronology
implements Serializable {
    private static final long serialVersionUID = -7310865996721419676L;

    protected BaseChronology() {
    }

    @Override
    public abstract DateTimeZone getZone();

    @Override
    public abstract Chronology withUTC();

    @Override
    public abstract Chronology withZone(DateTimeZone var1);

    @Override
    public long getDateTimeMillis(int year, int monthOfYear, int dayOfMonth, int millisOfDay) throws IllegalArgumentException {
        long instant = this.year().set(0L, year);
        instant = this.monthOfYear().set(instant, monthOfYear);
        instant = this.dayOfMonth().set(instant, dayOfMonth);
        return this.millisOfDay().set(instant, millisOfDay);
    }

    @Override
    public long getDateTimeMillis(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond) throws IllegalArgumentException {
        long instant = this.year().set(0L, year);
        instant = this.monthOfYear().set(instant, monthOfYear);
        instant = this.dayOfMonth().set(instant, dayOfMonth);
        instant = this.hourOfDay().set(instant, hourOfDay);
        instant = this.minuteOfHour().set(instant, minuteOfHour);
        instant = this.secondOfMinute().set(instant, secondOfMinute);
        return this.millisOfSecond().set(instant, millisOfSecond);
    }

    @Override
    public long getDateTimeMillis(long instant, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond) throws IllegalArgumentException {
        instant = this.hourOfDay().set(instant, hourOfDay);
        instant = this.minuteOfHour().set(instant, minuteOfHour);
        instant = this.secondOfMinute().set(instant, secondOfMinute);
        return this.millisOfSecond().set(instant, millisOfSecond);
    }

    @Override
    public void validate(ReadablePartial partial, int[] values) {
        DateTimeField field;
        int value;
        int i;
        int size = partial.size();
        for (i = 0; i < size; ++i) {
            value = values[i];
            field = partial.getField(i);
            if (value < field.getMinimumValue()) {
                throw new IllegalFieldValueException(field.getType(), (Number)value, (Number)field.getMinimumValue(), null);
            }
            if (value <= field.getMaximumValue()) continue;
            throw new IllegalFieldValueException(field.getType(), (Number)value, null, (Number)field.getMaximumValue());
        }
        for (i = 0; i < size; ++i) {
            value = values[i];
            field = partial.getField(i);
            if (value < field.getMinimumValue(partial, values)) {
                throw new IllegalFieldValueException(field.getType(), (Number)value, (Number)field.getMinimumValue(partial, values), null);
            }
            if (value <= field.getMaximumValue(partial, values)) continue;
            throw new IllegalFieldValueException(field.getType(), (Number)value, null, (Number)field.getMaximumValue(partial, values));
        }
    }

    @Override
    public int[] get(ReadablePartial partial, long instant) {
        int size = partial.size();
        int[] values = new int[size];
        for (int i = 0; i < size; ++i) {
            values[i] = partial.getFieldType(i).getField(this).get(instant);
        }
        return values;
    }

    @Override
    public long set(ReadablePartial partial, long instant) {
        int isize = partial.size();
        for (int i = 0; i < isize; ++i) {
            instant = partial.getFieldType(i).getField(this).set(instant, partial.getValue(i));
        }
        return instant;
    }

    @Override
    public int[] get(ReadablePeriod period, long startInstant, long endInstant) {
        int size = period.size();
        int[] values = new int[size];
        if (startInstant != endInstant) {
            for (int i = 0; i < size; ++i) {
                DurationField field = period.getFieldType(i).getField(this);
                int value = field.getDifference(endInstant, startInstant);
                startInstant = field.add(startInstant, value);
                values[i] = value;
            }
        }
        return values;
    }

    @Override
    public int[] get(ReadablePeriod period, long duration) {
        int size = period.size();
        int[] values = new int[size];
        if (duration != 0L) {
            long current = 0L;
            for (int i = 0; i < size; ++i) {
                DurationField field = period.getFieldType(i).getField(this);
                if (!field.isPrecise()) continue;
                int value = field.getDifference(duration, current);
                current = field.add(current, value);
                values[i] = value;
            }
        }
        return values;
    }

    @Override
    public long add(ReadablePeriod period, long instant, int scalar) {
        if (scalar != 0 && period != null) {
            int isize = period.size();
            for (int i = 0; i < isize; ++i) {
                long value = period.getValue(i);
                if (value == 0L) continue;
                instant = period.getFieldType(i).getField(this).add(instant, value * (long)scalar);
            }
        }
        return instant;
    }

    @Override
    public long add(long instant, long duration, int scalar) {
        if (duration == 0L || scalar == 0) {
            return instant;
        }
        long add = FieldUtils.safeMultiply(duration, scalar);
        return FieldUtils.safeAdd(instant, add);
    }

    @Override
    public DurationField millis() {
        return UnsupportedDurationField.getInstance(DurationFieldType.millis());
    }

    @Override
    public DateTimeField millisOfSecond() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.millisOfSecond(), this.millis());
    }

    @Override
    public DateTimeField millisOfDay() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.millisOfDay(), this.millis());
    }

    @Override
    public DurationField seconds() {
        return UnsupportedDurationField.getInstance(DurationFieldType.seconds());
    }

    @Override
    public DateTimeField secondOfMinute() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.secondOfMinute(), this.seconds());
    }

    @Override
    public DateTimeField secondOfDay() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.secondOfDay(), this.seconds());
    }

    @Override
    public DurationField minutes() {
        return UnsupportedDurationField.getInstance(DurationFieldType.minutes());
    }

    @Override
    public DateTimeField minuteOfHour() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.minuteOfHour(), this.minutes());
    }

    @Override
    public DateTimeField minuteOfDay() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.minuteOfDay(), this.minutes());
    }

    @Override
    public DurationField hours() {
        return UnsupportedDurationField.getInstance(DurationFieldType.hours());
    }

    @Override
    public DateTimeField hourOfDay() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.hourOfDay(), this.hours());
    }

    @Override
    public DateTimeField clockhourOfDay() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.clockhourOfDay(), this.hours());
    }

    @Override
    public DurationField halfdays() {
        return UnsupportedDurationField.getInstance(DurationFieldType.halfdays());
    }

    @Override
    public DateTimeField hourOfHalfday() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.hourOfHalfday(), this.hours());
    }

    @Override
    public DateTimeField clockhourOfHalfday() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.clockhourOfHalfday(), this.hours());
    }

    @Override
    public DateTimeField halfdayOfDay() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.halfdayOfDay(), this.halfdays());
    }

    @Override
    public DurationField days() {
        return UnsupportedDurationField.getInstance(DurationFieldType.days());
    }

    @Override
    public DateTimeField dayOfWeek() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.dayOfWeek(), this.days());
    }

    @Override
    public DateTimeField dayOfMonth() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.dayOfMonth(), this.days());
    }

    @Override
    public DateTimeField dayOfYear() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.dayOfYear(), this.days());
    }

    @Override
    public DurationField weeks() {
        return UnsupportedDurationField.getInstance(DurationFieldType.weeks());
    }

    @Override
    public DateTimeField weekOfWeekyear() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.weekOfWeekyear(), this.weeks());
    }

    @Override
    public DurationField weekyears() {
        return UnsupportedDurationField.getInstance(DurationFieldType.weekyears());
    }

    @Override
    public DateTimeField weekyear() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.weekyear(), this.weekyears());
    }

    @Override
    public DateTimeField weekyearOfCentury() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.weekyearOfCentury(), this.weekyears());
    }

    @Override
    public DurationField months() {
        return UnsupportedDurationField.getInstance(DurationFieldType.months());
    }

    @Override
    public DateTimeField monthOfYear() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.monthOfYear(), this.months());
    }

    @Override
    public DurationField years() {
        return UnsupportedDurationField.getInstance(DurationFieldType.years());
    }

    @Override
    public DateTimeField year() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.year(), this.years());
    }

    @Override
    public DateTimeField yearOfEra() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.yearOfEra(), this.years());
    }

    @Override
    public DateTimeField yearOfCentury() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.yearOfCentury(), this.years());
    }

    @Override
    public DurationField centuries() {
        return UnsupportedDurationField.getInstance(DurationFieldType.centuries());
    }

    @Override
    public DateTimeField centuryOfEra() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.centuryOfEra(), this.centuries());
    }

    @Override
    public DurationField eras() {
        return UnsupportedDurationField.getInstance(DurationFieldType.eras());
    }

    @Override
    public DateTimeField era() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.era(), this.eras());
    }

    @Override
    public abstract String toString();
}

