/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.xml;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Throwables;
import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.AbstractList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.EntityResolver2;

@GoogleInternal
@GwtIncompatible
public final class DocumentUtil {
    private static final String UNSAFE_METHOD_WARNING = "Unsafe method call. See javadoc for details.";
    private static final Logger logger = Logger.getLogger(DocumentUtil.class.getName());
    private static final ThreadLocal<TransformerFactory> transformerFactory = new ThreadLocal<TransformerFactory>(){

        @Override
        protected TransformerFactory initialValue() {
            return TransformerFactory.newInstance();
        }
    };
    private final EntityResolver resolver;

    private DocumentUtil(EntityResolver resolver) {
        this.resolver = Preconditions.checkNotNull(resolver);
    }

    public static DocumentUtil getInstance(Resolver safeResolver) {
        return safeResolver.instance;
    }

    public static DocumentUtil getInstance(EntityResolver resolver) {
        logger.logp(Level.WARNING, "com.google.appengine.repackaged.com.google.common.xml.DocumentUtil", "getInstance", UNSAFE_METHOD_WARNING);
        return new DocumentUtil(resolver);
    }

    public static Document createDocument() throws ProcessingException {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            return builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            String err = "Could not create new Document";
            logger.logp(Level.SEVERE, "com.google.appengine.repackaged.com.google.common.xml.DocumentUtil", "createDocument", err);
            throw new ProcessingException(err, e);
        }
    }

    public Document fromFile(File file) throws FileNotFoundException, ProcessingException {
        return this.fromStream(new FileInputStream(file));
    }

    public Document fromString(String data) throws ProcessingException {
        return this.fromStream(new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8)));
    }

    @Deprecated
    public static Document fromString(String xml, boolean validating) throws ProcessingException {
        logger.logp(Level.WARNING, "com.google.appengine.repackaged.com.google.common.xml.DocumentUtil", "fromString", UNSAFE_METHOD_WARNING);
        ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
        return DocumentUtil.fromStream(in, validating);
    }

    public Document fromStream(InputStream in) throws ProcessingException {
        return this.fromInputSource(new InputSource(in));
    }

    @Deprecated
    public static Document fromStream(InputStream in, boolean validate) throws ProcessingException {
        logger.logp(Level.WARNING, "com.google.appengine.repackaged.com.google.common.xml.DocumentUtil", "fromStream", UNSAFE_METHOD_WARNING);
        return new DocumentParser().validating(validate).parse(new InputSource(in));
    }

    public Document fromInputSource(InputSource in) throws ProcessingException {
        Document dom;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(this.resolver);
            builder.setErrorHandler(SimpleErrorHandler.INSTANCE);
            dom = builder.parse(in);
        }
        catch (SAXException e) {
            String string = String.valueOf(e.toString());
            String err = string.length() != 0 ? "Caught SAXException: ".concat(string) : new String("Caught SAXException: ");
            logger.logp(Level.SEVERE, "com.google.appengine.repackaged.com.google.common.xml.DocumentUtil", "fromInputSource", err);
            throw new ProcessingException(err, e);
        }
        catch (ParserConfigurationException e) {
            String string = String.valueOf(e.toString());
            String err = string.length() != 0 ? "Caught ParserConfigurationException: ".concat(string) : new String("Caught ParserConfigurationException: ");
            logger.logp(Level.SEVERE, "com.google.appengine.repackaged.com.google.common.xml.DocumentUtil", "fromInputSource", err);
            throw new ProcessingException(err, e);
        }
        catch (IOException e) {
            String string = String.valueOf(e.toString());
            String err = string.length() != 0 ? "Caught IOException: ".concat(string) : new String("Caught IOException: ");
            logger.logp(Level.SEVERE, "com.google.appengine.repackaged.com.google.common.xml.DocumentUtil", "fromInputSource", err);
            throw new ProcessingException(err, e);
        }
        return dom;
    }

    public static List<Node> asList(final NodeList nodeList) {
        return new AbstractList<Node>(){

            @Override
            public Node get(int index) {
                Node node = nodeList.item(index);
                if (node == null) {
                    int n = nodeList.getLength();
                    throw new IndexOutOfBoundsException(new StringBuilder(66).append("Node index out of bounds: Requested ").append(index).append("; size: ").append(n).toString());
                }
                return node;
            }

            @Override
            public int size() {
                return nodeList.getLength();
            }
        };
    }

    public static String asString(NodeList nodes) throws ProcessingException {
        return DocumentUtil.asString(nodes, false);
    }

    private static String asString(NodeList nodes, boolean pretty) throws ProcessingException {
        StringWriter writer = new StringWriter();
        Result result = DocumentUtil.getFragmentResult(writer);
        for (int i = 0; i < nodes.getLength(); ++i) {
            DocumentUtil.transform(nodes.item(i), result, pretty);
        }
        return writer.toString();
    }

    public static String asString(Node node) throws ProcessingException {
        return DocumentUtil.asString(node, false);
    }

    private static String asString(Node node, boolean pretty) throws ProcessingException {
        StringWriter writer = new StringWriter();
        DocumentUtil.transform(node, DocumentUtil.getFragmentResult(writer), pretty);
        return writer.toString();
    }

    public static String asString(Document dom) throws ProcessingException {
        return DocumentUtil.asString(dom, false);
    }

    private static String asString(Document dom, boolean pretty) throws ProcessingException {
        StringWriter writer = new StringWriter();
        DocumentUtil.transform(dom.getDocumentElement(), DocumentUtil.getResult(writer), pretty);
        return writer.toString();
    }

    public static String asPrettyString(NodeList nodes) throws ProcessingException {
        return DocumentUtil.asString(nodes, true);
    }

    public static String asPrettyString(Node node) throws ProcessingException {
        return DocumentUtil.asString(node, true);
    }

    public static String asPrettyString(Document dom) throws ProcessingException {
        return DocumentUtil.asString(dom, true);
    }

    private static Result getFragmentResult(Writer w) throws ProcessingException {
        OutputFormat fmt = new OutputFormat();
        fmt.setOmitXMLDeclaration(true);
        fmt.setIndenting(false);
        try {
            return new SAXResult(new XMLSerializer(w, fmt).asContentHandler());
        }
        catch (IOException e) {
            String string = String.valueOf(e.toString());
            String err = string.length() != 0 ? "Caught IOException: ".concat(string) : new String("Caught IOException: ");
            logger.logp(Level.SEVERE, "com.google.appengine.repackaged.com.google.common.xml.DocumentUtil", "getFragmentResult", err);
            throw new ProcessingException(err, e);
        }
    }

    private static Result getResult(Writer w) {
        return new StreamResult(w);
    }

    private static void transform(Node node, Result result, boolean pretty) throws ProcessingException {
        try {
            Transformer transformer = transformerFactory.get().newTransformer();
            if (pretty) {
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            }
            transformer.transform(new DOMSource(node), result);
        }
        catch (TransformerConfigurationException e) {
            String string = String.valueOf(e.toString());
            String err = string.length() != 0 ? "Caught TransformerConfigurationException: ".concat(string) : new String("Caught TransformerConfigurationException: ");
            logger.logp(Level.SEVERE, "com.google.appengine.repackaged.com.google.common.xml.DocumentUtil", "transform", err);
            throw new ProcessingException(err, e);
        }
        catch (TransformerException e) {
            String string = String.valueOf(e.toString());
            String err = string.length() != 0 ? "Caught TransformerException: ".concat(string) : new String("Caught TransformerException: ");
            logger.logp(Level.SEVERE, "com.google.appengine.repackaged.com.google.common.xml.DocumentUtil", "transform", err);
            throw new ProcessingException(err, e);
        }
    }

    private static class SimpleErrorHandler
    implements ErrorHandler {
        private static final ErrorHandler INSTANCE = new SimpleErrorHandler();

        private SimpleErrorHandler() {
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            String string = String.valueOf(Throwables.getStackTraceAsString(e));
            logger.logp(Level.WARNING, "com.google.appengine.repackaged.com.google.common.xml.DocumentUtil$SimpleErrorHandler", "warning", string.length() != 0 ? "Encountered a warning while parsing error:\n".concat(string) : new String("Encountered a warning while parsing error:\n"));
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            String string = String.valueOf(Throwables.getStackTraceAsString(e));
            logger.logp(Level.FINE, "com.google.appengine.repackaged.com.google.common.xml.DocumentUtil$SimpleErrorHandler", "error", string.length() != 0 ? "Encountered a recoverable parsing error:\n".concat(string) : new String("Encountered a recoverable parsing error:\n"));
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            String string = String.valueOf(Throwables.getStackTraceAsString(e));
            logger.logp(Level.SEVERE, "com.google.appengine.repackaged.com.google.common.xml.DocumentUtil$SimpleErrorHandler", "fatalError", string.length() != 0 ? "Encountered a fatal parsing error:\n".concat(string) : new String("Encountered a fatal parsing error:\n"));
            throw e;
        }
    }

    public static final class ProcessingException
    extends Exception {
        private static final long serialVersionUID = -6037987398917742165L;

        public ProcessingException(String message) {
            super(message);
        }

        public ProcessingException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    @Deprecated
    private static class DocumentParser {
        private EntityResolver er;
        private ErrorHandler eh = new SimpleErrorHandler(){

            @Override
            public void error(SAXParseException e) throws SAXException {
                if (validating) {
                    String string = String.valueOf(Throwables.getStackTraceAsString(e));
                    logger.logp(Level.SEVERE, "com.google.appengine.repackaged.com.google.common.xml.DocumentUtil$DocumentParser$1", "error", string.length() != 0 ? "rethrowing\n".concat(string) : new String("rethrowing\n"));
                    throw e;
                }
                String string = String.valueOf(Throwables.getStackTraceAsString(e));
                logger.logp(Level.WARNING, "com.google.appengine.repackaged.com.google.common.xml.DocumentUtil$DocumentParser$1", "error", string.length() != 0 ? "ignoring\n".concat(string) : new String("ignoring\n"));
            }
        };
        private boolean validating;

        private DocumentParser() {
        }

        @Deprecated
        public DocumentParser usingEntityResolver(EntityResolver newResolver) {
            logger.logp(Level.WARNING, "com.google.appengine.repackaged.com.google.common.xml.DocumentUtil$DocumentParser", "usingEntityResolver", DocumentUtil.UNSAFE_METHOD_WARNING);
            this.er = newResolver;
            return this;
        }

        @Deprecated
        public DocumentParser validating(boolean newValidating) {
            logger.logp(Level.WARNING, "com.google.appengine.repackaged.com.google.common.xml.DocumentUtil$DocumentParser", "validating", DocumentUtil.UNSAFE_METHOD_WARNING);
            this.validating = newValidating;
            return this;
        }

        @Deprecated
        public Document parse(InputSource in) throws ProcessingException {
            Document dom;
            logger.logp(Level.WARNING, "com.google.appengine.repackaged.com.google.common.xml.DocumentUtil$DocumentParser", "parse", DocumentUtil.UNSAFE_METHOD_WARNING);
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                factory.setValidating(this.validating);
                DocumentBuilder builder = factory.newDocumentBuilder();
                if (null != this.er) {
                    builder.setEntityResolver(this.er);
                }
                builder.setErrorHandler(this.eh);
                dom = builder.parse(in);
            }
            catch (SAXException e) {
                String string = String.valueOf(e.toString());
                String err = string.length() != 0 ? "Caught SAXException: ".concat(string) : new String("Caught SAXException: ");
                logger.logp(Level.SEVERE, "com.google.appengine.repackaged.com.google.common.xml.DocumentUtil$DocumentParser", "parse", err);
                throw new ProcessingException(err, e);
            }
            catch (ParserConfigurationException e) {
                String string = String.valueOf(e.toString());
                String err = string.length() != 0 ? "Caught ParserConfigurationException: ".concat(string) : new String("Caught ParserConfigurationException: ");
                logger.logp(Level.SEVERE, "com.google.appengine.repackaged.com.google.common.xml.DocumentUtil$DocumentParser", "parse", err);
                throw new ProcessingException(err, e);
            }
            catch (IOException e) {
                String string = String.valueOf(e.toString());
                String err = string.length() != 0 ? "Caught IOException: ".concat(string) : new String("Caught IOException: ");
                logger.logp(Level.SEVERE, "com.google.appengine.repackaged.com.google.common.xml.DocumentUtil$DocumentParser", "parse", err);
                throw new ProcessingException(err, e);
            }
            return dom;
        }
    }

    public static enum Resolver implements EntityResolver2
    {
        NOOP{

            @Override
            public InputSource getExternalSubset(String name, String baseURI) {
                return new InputSource(new StringReader(""));
            }

            @Override
            public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) {
                return new InputSource(new StringReader(""));
            }

            @Override
            public InputSource resolveEntity(String publicId, String systemId) {
                return new InputSource(new StringReader(""));
            }
        }
        ,
        EXCEPTION{

            @Override
            public InputSource getExternalSubset(String name, String baseURI) throws IOException {
                throw new IOException(String.format("Denied access to name '%s' with baseURI '%s'", name, baseURI));
            }

            @Override
            public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws IOException {
                throw new IOException(String.format("Denied access to entity '%s'", systemId));
            }

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws IOException {
                throw new IOException(String.format("Denied access to entity '%s'", systemId));
            }
        };

        private final DocumentUtil instance = new DocumentUtil(this);
    }
}

