/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.html.types;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.flags.Flag;
import com.google.appengine.repackaged.com.google.common.html.types.TrustedResourceUrl;
import com.google.appengine.repackaged.com.google.common.html.types.TrustedResourceUrlProto;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CompileTimeConstant;
import com.google.security.types.common.TrustedString;
import java.util.Map;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

@CheckReturnValue
@GwtCompatible(emulated=true)
public final class TrustedResourceUrls {
    private TrustedResourceUrls() {
    }

    public static TrustedResourceUrl fromProto(TrustedResourceUrlProto proto) {
        return TrustedResourceUrls.create(proto.getPrivateDoNotAccessOrElseTrustedResourceUrlWrappedValue());
    }

    public static TrustedResourceUrlProto toProto(TrustedResourceUrl url) {
        return TrustedResourceUrlProto.newBuilder().setPrivateDoNotAccessOrElseTrustedResourceUrlWrappedValue(url.getTrustedResourceUrlString()).build();
    }

    public static TrustedResourceUrl fromConstant(@CompileTimeConstant String url) {
        return TrustedResourceUrls.create(url);
    }

    @Nullable
    @GwtIncompatible(value="System.getEnv")
    public static TrustedResourceUrl fromEnvironmentVariable(@CompileTimeConstant String variableName) {
        String var = System.getenv(variableName);
        if (var == null) {
            return null;
        }
        return TrustedResourceUrls.create(var);
    }

    @GwtIncompatible(value="Flag")
    public static Flag<TrustedResourceUrl> createFlag(@Nullable TrustedResourceUrl defaultValue) {
        return new Flag<TrustedResourceUrl>(defaultValue){

            @Override
            protected TrustedResourceUrl parse(String valueString) {
                return new TrustedResourceUrl(valueString);
            }

            @Override
            protected boolean isSetFromStringAllowed() {
                return false;
            }
        };
    }

    @GwtIncompatible(value="Flag")
    public static Flag<TrustedResourceUrl> createFlag(@Nullable @CompileTimeConstant String defaultValue) {
        return TrustedResourceUrls.createFlag(defaultValue == null ? null : TrustedResourceUrls.fromConstant(defaultValue));
    }

    @GwtIncompatible(value="Flag")
    public static TrustedResourceUrl fromFlag(Flag<?> flag) {
        return TrustedResourceUrls.create(flag.parsableStringValue());
    }

    @GwtIncompatible(value="Flag")
    public static ImmutableList<TrustedResourceUrl> fromIterableFlag(Flag<? extends Iterable<String>> flag) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (String value : flag.get()) {
            result.add(TrustedResourceUrls.create(value));
        }
        return result.build();
    }

    @GwtIncompatible(value="Flag")
    public static <T> ImmutableMap<T, TrustedResourceUrl> fromMapFlag(Flag<? extends Map<T, String>> flag) {
        ImmutableMap.Builder<T, TrustedResourceUrl> result = ImmutableMap.builder();
        if (flag.get() != null) {
            for (Map.Entry<T, String> entry : flag.get().entrySet()) {
                result.put(entry.getKey(), TrustedResourceUrls.create(entry.getValue()));
            }
        }
        return result.buildOrThrow();
    }

    @GwtIncompatible(value="TrustedString")
    public static TrustedResourceUrl fromTrustedString(TrustedString s) {
        return TrustedResourceUrls.create(s.toString());
    }

    static TrustedResourceUrl create(String url) {
        return new TrustedResourceUrl(url);
    }
}

