/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.api.client.protobuf;

import com.google.appengine.repackaged.com.google.api.client.util.Beta;
import com.google.appengine.repackaged.com.google.api.client.util.Throwables;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;

@Beta
public class ProtocolBuffers {
    public static final String CONTENT_TYPE = "application/x-protobuf";
    public static final String ALT_CONTENT_TYPE = "application/x-protobuffer";

    public static <T extends MessageLite> T parseAndClose(InputStream inputStream, Class<T> messageClass) throws IOException {
        try {
            Method newBuilder = messageClass.getDeclaredMethod("parseFrom", InputStream.class);
            MessageLite messageLite = (MessageLite)messageClass.cast(newBuilder.invoke(null, inputStream));
            return (T)messageLite;
        }
        catch (Exception e) {
            Throwables.propagateIfPossible(e, IOException.class);
            String string = String.valueOf(messageClass);
            IOException io = new IOException(new StringBuilder(30 + String.valueOf(string).length()).append("Error parsing message of type ").append(string).toString());
            io.initCause(e);
            throw io;
        }
        finally {
            inputStream.close();
        }
    }

    private ProtocolBuffers() {
    }
}

